/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.StoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreMaterialService")
public class InstoreMaterialService
extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity>
implements IInstoreMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    private static String PARAM_APPLY_COUNT = "P-Zm16p834";
    private static String PARAM_DETAIL_COUNT = "P-4bxJ4C64";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private IUseApplyService useApplyService;
    private static final String PARAM_TOTAL_MNY = "P-5j78wo43";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    private static final String PARAM_MATERIAL_PRICE = "P-1N735378";
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";
    private static String PARAM_DETAIL_PRICE = "P-Yn663f82";
    @Autowired
    private IPickRegisterService pickRegisterService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.eq((Object)"dr", (Object)0);
        return this.instoreMaterialMapper.countAmount((QueryWrapper<InstoreEntity>)queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate, Long storeId, Integer pageNum, Integer pageSize, Long sectionDocId) {
        Page page = new Page();
        page.setCurrent((long)pageNum.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        String materialTypeName = "";
        String materialName = "";
        String materialSpec = "";
        String materialUnit = "";
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"materialCategoryName") != null) {
                materialTypeName = search.get((Object)"materialCategoryName").toString();
            }
            if (search.get((Object)"materialName") != null) {
                materialName = search.get((Object)"materialName").toString();
            }
            if (search.get((Object)"materialSpec") != null) {
                materialSpec = search.get((Object)"materialSpec").toString();
            }
            if (search.get((Object)"materialUnit") != null) {
                materialUnit = search.get((Object)"materialUnit").toString();
            }
        }
        Long count = this.instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName, materialName, materialSpec, materialUnit, sectionDocId);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName, materialName, materialSpec, materialUnit, sectionDocId);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        Page page = new Page();
        Long count = this.instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0L) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent((long)pageNumber.intValue());
                page.setSize((long)pageSize.intValue());
            }
            List<InstoreMaterialVO> list = this.instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return this.instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        Page page = new Page();
        page.setCurrent((long)pageNumber.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return this.instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        List<MaterialPriceVO> detailList = vo.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
            HashMap<Long, MaterialPriceVO> numMap = new HashMap<Long, MaterialPriceVO>();
            detailList.forEach(detail -> {
                MaterialPriceVO materialPriceVO = (MaterialPriceVO)numMap.get(detail.getMaterialId());
                if (materialPriceVO != null) {
                    materialPriceVO.setNum(ComputeUtil.safeAdd((BigDecimal)materialPriceVO.getNum(), (BigDecimal)detail.getNum()));
                    materialPriceVO.setAmount(ComputeUtil.safeAdd((BigDecimal)materialPriceVO.getAmount(), (BigDecimal)detail.getAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), (MaterialPriceVO)detail);
                }
            });
            vo.setDetail(new ArrayList(numMap.values()));
            List detail2 = vo.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)detail2)) {
                List billParamVOS;
                CommonResponse response4;
                CommonResponse response3;
                CommonResponse response2;
                BigDecimal roleValue;
                StringBuffer stringBuffer;
                ParamsCheckDsVO paramsCheckDsVO;
                List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
                paramControlVO.setProjectId(vo.getProjectId());
                paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO.setIds(materialIds);
                CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
                if (!res.isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
                }
                if (null != res.getData()) {
                    CommonResponse response22;
                    BudgetProjectDetailProVO detailProVO;
                    CommonResponse response1;
                    BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res.getData();
                    Map detailProMap = quantityAndMnyVO.getDetailProMap();
                    CommonResponse response5 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
                    if (!response5.isSuccess()) {
                        throw new BusinessException("\u3010\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\u3011 \u63a7 \u3010\u6750\u6599\u5165\u5e93\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response5.getMsg());
                    }
                    List billParamVOS2 = (List)response5.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS2) && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        BigDecimal lastTotalAmount = this.instoreMaterialMapper.fetchLastTotalAmount(vo.getProjectId(), vo.getId());
                        BigDecimal amount = detail2.stream().map(MaterialPriceVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal totalAmount = lastTotalAmount.add(amount);
                        for (Object billParamVO : billParamVOS2) {
                            if (0 == billParamVO.getControlType()) continue;
                            BigDecimal bigDecimal = billParamVO.getRoleValue();
                            BigDecimal scale = bigDecimal.divide(new BigDecimal("100"));
                            BigDecimal bigDecimal2 = ComputeUtil.safeMultiply((BigDecimal)quantityAndMnyVO.getMaterialTaxMny(), (BigDecimal)scale);
                            if (totalAmount.compareTo(bigDecimal2) <= 0) continue;
                            BigDecimal over = totalAmount.subtract(bigDecimal2);
                            ParamsCheckDsVO paramsCheckDsVO2 = new ParamsCheckDsVO(vo.getId(), "amount");
                            paramsCheckDsVO2.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO2.setWarnItem("\u6750\u6599\u5165\u5e93\u603b\u91d1\u989d\u8d85\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d");
                            paramsCheckDsVO2.setWarnName("\u6750\u6599\u5165\u5e93\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * " + bigDecimal + "%");
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append("\u8be5\u9879\u76ee\u6750\u6599\u5165\u5e93\u603b\u91d1\u989d\uff1a").append(totalAmount.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * ").append(bigDecimal).append("%\uff1a").append(bigDecimal2.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                            paramsCheckDsVO2.setContent(stringBuffer2.toString());
                            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, (BillParamVO)billParamVO, paramsCheckDsVO2);
                        }
                    }
                    if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId)).isSuccess()) {
                        throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
                    }
                    List billParamVOS1 = (List)response1.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS1) && !detailProMap.isEmpty() && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        Object billParamVO;
                        Map<Long, MaterialPriceVO> lastSubMap = this.instoreMaterialMapper.sumLastTotalNumAndTotalAmount(vo.getId(), vo.getProjectId(), numMap.keySet());
                        HashMap<Long, MaterialPriceVO> currentMergeMap = new HashMap<Long, MaterialPriceVO>();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry entry : lastSubMap.entrySet()) {
                                Long materialId = (Long)entry.getKey();
                                if (!numMap.containsKey(materialId)) continue;
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                MaterialPriceVO cur = (MaterialPriceVO)numMap.get(materialId);
                                Iterator num = materialPriceVO.getNum();
                                materialPriceVO.setNum(((BigDecimal)((Object)num)).add(cur.getNum()));
                                entry.setValue(materialPriceVO);
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }
                        billParamVO = billParamVOS1.iterator();
                        while (billParamVO.hasNext()) {
                            BillParamVO billParamVO2 = (BillParamVO)billParamVO.next();
                            if (0 == billParamVO2.getControlType()) continue;
                            Iterator roleValue2 = billParamVO2.getRoleValue();
                            BigDecimal bigDecimal = ((BigDecimal)((Object)roleValue2)).divide(new BigDecimal("100"));
                            HashMap dProMap = new HashMap();
                            for (Map.Entry entry : detailProMap.entrySet()) {
                                BudgetProjectDetailProVO detailProVO2 = (BudgetProjectDetailProVO)entry.getValue();
                                BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                BigDecimal num = detailProVO2.getNum() == null ? BigDecimal.ZERO : detailProVO2.getNum();
                                budgetProjectDetailProVO.setNum(num.multiply(bigDecimal));
                                dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                            }
                            for (Map.Entry entry : currentMergeMap.entrySet()) {
                                BigDecimal dNum;
                                Long materialId = (Long)entry.getKey();
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                if (!dProMap.containsKey(materialId)) continue;
                                detailProVO = (BudgetProjectDetailProVO)dProMap.get(materialId);
                                BigDecimal cNum = materialPriceVO.getNum();
                                if (cNum.compareTo(dNum = detailProVO.getNum()) <= 0) continue;
                                BigDecimal over = cNum.subtract(dNum);
                                paramsCheckDsVO = new ParamsCheckDsVO(materialId, "num");
                                paramsCheckDsVO.setOrgName(billParamVO2.getOrgName());
                                paramsCheckDsVO.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                paramsCheckDsVO.setWarnName("\u6536\u6599\u5165\u5e93\u6750\u6599\u6e05\u5355\u91cf+\u76f4\u5165\u76f4\u51fa\u6750\u6599\u6e05\u5355\u91cf\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * " + roleValue2 + "%");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u6863\u6848\u7d2f\u8ba1\u6570\u91cf\uff1a").append(cNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * ").append(roleValue2).append("%\uff1a").append(dNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91cf\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO2, paramsCheckDsVO);
                            }
                        }
                    }
                    if (!(response22 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId)).isSuccess()) {
                        throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response22.getMsg());
                    }
                    List billParamVOS22 = (List)response22.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS22) && !detailProMap.isEmpty() && (1 == vo.getInstoreType() || 2 == vo.getInstoreType())) {
                        Map<Long, MaterialPriceVO> lastSubMap = this.instoreMaterialMapper.sumLastTotalNumAndTotalAmount(vo.getId(), vo.getProjectId(), numMap.keySet());
                        HashMap<Long, MaterialPriceVO> hashMap = new HashMap<Long, MaterialPriceVO>();
                        if (lastSubMap.isEmpty()) {
                            hashMap.putAll(numMap);
                        } else {
                            for (Map.Entry entry : lastSubMap.entrySet()) {
                                Long materialId = (Long)entry.getKey();
                                if (!numMap.containsKey(materialId)) continue;
                                MaterialPriceVO subVO = (MaterialPriceVO)entry.getValue();
                                MaterialPriceVO cur = (MaterialPriceVO)numMap.get(materialId);
                                Iterator amount = subVO.getAmount();
                                subVO.setAmount(((BigDecimal)((Object)amount)).add(cur.getAmount()));
                                entry.setValue(subVO);
                            }
                            hashMap.putAll(lastSubMap);
                        }
                        for (BillParamVO billParamVO : billParamVOS22) {
                            if (0 == billParamVO.getControlType()) continue;
                            roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                            HashMap dProMap = new HashMap();
                            for (Map.Entry entry : detailProMap.entrySet()) {
                                detailProVO = (BudgetProjectDetailProVO)entry.getValue();
                                BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                                budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                                dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                            }
                            for (Map.Entry entry : hashMap.entrySet()) {
                                BigDecimal dMaterialTaxMnyCost;
                                Long materialId = (Long)entry.getKey();
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                if (!dProMap.containsKey(materialId)) continue;
                                BudgetProjectDetailProVO detailProVO3 = (BudgetProjectDetailProVO)dProMap.get(materialId);
                                BigDecimal cAmount = materialPriceVO.getAmount();
                                if (cAmount.compareTo(dMaterialTaxMnyCost = detailProVO3.getMaterialTaxMnyCost()) <= 0) continue;
                                BigDecimal over = cAmount.subtract(dMaterialTaxMnyCost);
                                ParamsCheckDsVO paramsCheckDsVO3 = new ParamsCheckDsVO(materialId, "amount");
                                paramsCheckDsVO3.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO3.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                paramsCheckDsVO3.setWarnName("\u6536\u6599\u5165\u5e93\u6750\u6599\u6e05\u5355\u91d1\u989d+\u76f4\u5165\u76f4\u51fa\u6750\u6599\u6e05\u5355\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * " + roleValue + "%");
                                StringBuffer stringBuffer3 = new StringBuffer();
                                stringBuffer3.append("\u6863\u6848\u7d2f\u8ba1\u91d1\u989d\uff1a").append(cAmount.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                                paramsCheckDsVO3.setContent(stringBuffer3.toString());
                                InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO3);
                            }
                        }
                    }
                }
                if (!(response2 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u6750\u6599\u5165\u5e93\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
                }
                List billParamVOS2 = (List)response2.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                    List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    List<MaterialPriceVO> materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                    if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                        Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                        for (MaterialPriceVO v : detail2) {
                            Long materialId = v.getMaterialId();
                            MaterialPriceVO p = priceVOMap.get(materialId);
                            if (null == p) continue;
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    for (BillParamVO billParamVO : billParamVOS2) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue4 = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue4.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal _planNum;
                            BigDecimal bigDecimal = d.getNum();
                            BigDecimal planNum = d.getPlanNum();
                            BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(bigDecimal);
                            if (allNum.compareTo(_planNum = planNum.multiply(divide)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO4 = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                            paramsCheckDsVO4.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO4.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO4.setWarnName("\u6750\u6599\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                            StringBuffer stringBuffer4 = new StringBuffer();
                            stringBuffer4.append("\u8be5\u9879\u76ee\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(bigDecimal.setScale(2, 4)).append("\uff0c\u5df2\u5165\u5e93\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue4).append("%: ").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                            paramsCheckDsVO4.setContent(stringBuffer4.toString());
                            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO4);
                        }
                    }
                }
                if (!(response3 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_APPLY_COUNT, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u7528\u6599\u7533\u8bf7\u3011\u63a7\u5236\u3010\u6750\u6599\u5165\u5e93\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
                }
                List billParamVOS3 = (List)response3.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS3)) {
                    List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    List<MaterialApplyCountVO> applyCountVOS = this.useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                    for (BillParamVO billParamVO : billParamVOS3) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue2 = billParamVO.getRoleValue();
                        BigDecimal bigDecimal = roleValue2.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal _applyNum;
                            Iterator num = d.getNum();
                            BigDecimal applyNum = applyVOMap.get(d.getMaterialId()) != null ? applyVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, num);
                            if (allNum.compareTo(_applyNum = applyNum.multiply(bigDecimal)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO5 = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                            paramsCheckDsVO5.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO5.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO5.setWarnName("\u9879\u76ee\u5165\u5e93\u6570\u91cf\u8d85\u9879\u76ee\u7528\u6599\u7533\u8bf7\u91cf");
                            StringBuffer stringBuffer5 = new StringBuffer();
                            stringBuffer5.append("\u8be5\u9879\u76ee\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(((BigDecimal)((Object)num)).setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u7528\u6599\u7533\u8bf7\u6570\u91cf*").append(roleValue2).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                            paramsCheckDsVO5.setContent(stringBuffer5.toString());
                            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO5);
                        }
                    }
                }
                if (!(response4 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_COUNT, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u6750\u6599\u5408\u540c\u91cf\u3011\u63a7\u5236\u3010\u6750\u6599\u5165\u5e93\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response4.getMsg());
                }
                List billParamVOS4 = (List)response4.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS4) && "hasContract".equals(vo.getContractType())) {
                    List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                    List<MaterialApplyCountVO> materialDetailCountVOS = this.materialContractMapper.queryMaterialDetailCount(vo.getProjectId(), materialIds);
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    Map<Long, BigDecimal> map = materialDetailCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                    for (BillParamVO billParamVO : billParamVOS4) {
                        if (0 == billParamVO.getControlType()) continue;
                        roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal _applyNum;
                            BigDecimal num = d.getNum();
                            BigDecimal applyNum = map.get(d.getMaterialId()) != null ? map.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
                            if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) <= 0) continue;
                            paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u6750\u6599\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u6750\u6599\u5408\u540c\u91cf");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u8be5\u9879\u76ee\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u5165\u5e93\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
                Integer instoreType = vo.getInstoreType();
                Long labourArmyId = vo.getLabourArmyId();
                Long projectId = vo.getProjectId();
                if (instoreType != null && instoreType == 2 && labourArmyId != null) {
                    CommonResponse commonResponse = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                    if (!commonResponse.isSuccess()) {
                        throw new BusinessException("\u52b3\u52a1\u961f\u4f0d\u9886\u6599\u9650\u989d\u91cf\u63a7\u5236\u6750\u6599\u51fa\u5e93\u91cf\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + commonResponse.getMsg());
                    }
                    billParamVOS = (List)commonResponse.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                        Map<Long, BigDecimal> map = this.pickRegisterService.queryLaborLimitMaterialCount(projectId, labourArmyId, materialIds);
                        List<MaterialPriceVO> vos = this.iOutStoreService.queryLaborMaterialCount(vo.getId(), projectId, labourArmyId, materialIds);
                        HashMap numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        for (Object billParamVO : billParamVOS) {
                            if (0 == billParamVO.getControlType()) continue;
                            BigDecimal roleValue5 = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue5.divide(BigDecimal.valueOf(100L));
                            numMap.forEach((arg_0, arg_1) -> InstoreMaterialService.lambda$checkParams$5(map, numVOMap, divide, (BillParamVO)billParamVO, roleValue5, paramsArray, paramsCheckVOMap, arg_0, arg_1));
                        }
                    }
                }
                if (instoreType != null && (instoreType == 2 || instoreType == 1) && "hasContract".equals(vo.getContractType()) && null != vo.getContractId()) {
                    CommonResponse commonResponse = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_PRICE, curOrgId);
                    if (!commonResponse.isSuccess()) {
                        throw new BusinessException("\u3010\u6750\u6599\u5408\u540c\u4ef7\u3011\u63a7\u5236\u3010\u6750\u6599\u5165\u5e93\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + commonResponse.getMsg());
                    }
                    billParamVOS = (List)commonResponse.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                        MaterialContractEntity materialContractEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(vo.getContractId()));
                        MaterialContractVO contractVO = (MaterialContractVO)BeanMapper.map((Object)((Object)materialContractEntity), MaterialContractVO.class);
                        List materialDetailList = contractVO.getMaterialDetailList();
                        Map<Object, Object> conMap = new HashMap();
                        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
                            conMap = materialDetailList.stream().collect(Collectors.toMap(MaterialContractDetailSubVO::getMaterialId, MaterialContractDetailSubVO::getUnitPrice, (v1, v2) -> v2));
                        }
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 == billParamVO.getControlType()) continue;
                            BigDecimal roleValue6 = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue6.divide(BigDecimal.valueOf(100L));
                            for (MaterialPriceVO d : detail2) {
                                BigDecimal conPrice;
                                BigDecimal _conPrice;
                                BigDecimal price;
                                if (!conMap.keySet().contains(String.valueOf(d.getMaterialId())) || (price = d.getPrice()).compareTo(_conPrice = ComputeUtil.safeMultiply((BigDecimal)(conPrice = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)conMap.get(String.valueOf(d.getMaterialId()))))), (BigDecimal)divide)) <= 0) continue;
                                ParamsCheckDsVO paramsCheckDsVO6 = new ParamsCheckDsVO();
                                paramsCheckDsVO6.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO6.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO6.setWarnName("\u6750\u6599\u5165\u5e93\u5355\u4ef7\u5927\u4e8e\u91c7\u8d2d\u5408\u540c\u4ef7");
                                StringBuffer stringBuffer6 = new StringBuffer();
                                stringBuffer6.append("\u672c\u6b21\u5165\u5e93\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u91c7\u8d2d\u5408\u540c\u5355\u4ef7*").append(roleValue6).append("%: ").append(_conPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)_conPrice).setScale(2, 4));
                                paramsCheckDsVO6.setContent(stringBuffer6.toString());
                                InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO6);
                            }
                        }
                    }
                }
                CommonResponse commonResponse = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MATERIAL_PRICE, curOrgId);
                if (!response2.isSuccess()) {
                    throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u4ef7\u3011\u7ba1\u63a7\u3010\u6750\u6599\u5165\u5e93\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
                }
                List billParamVOS5 = (List)commonResponse.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS5)) {
                    List<MaterialPriceVO> list = this.materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds);
                    Map<Object, Object> priceVOMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(list)) {
                        priceVOMap = list.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getPlanPrice));
                    }
                    for (BillParamVO billParamVO : billParamVOS5) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue7 = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue7.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal price = d.getPrice();
                            BigDecimal planPrice = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)priceVOMap.get(d.getMaterialId())));
                            BigDecimal _planPrice = ComputeUtil.safeMultiply((BigDecimal)planPrice, (BigDecimal)divide);
                            if (null == price || price.compareTo(_planPrice) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO7 = new ParamsCheckDsVO();
                            paramsCheckDsVO7.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO7.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO7.setWarnName("\u5165\u5e93\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                            StringBuffer stringBuffer7 = new StringBuffer();
                            stringBuffer7.append("\u672c\u6b21\u5165\u5e93\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue7).append("%: ").append(_planPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u5355\u4ef7\uff1a").append(price.subtract(_planPrice).setScale(2, 4));
                            paramsCheckDsVO7.setContent(stringBuffer7.toString());
                            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO7);
                        }
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<InstoreMaterialVO> storeNumCount(Long orgId, List<Long> materialIds) {
        CommonResponse parentsOrgIds = this.orgApi.findParentsByOrgId(orgId);
        CommonResponse childrenOrgIds = this.orgApi.findChildrenByParentId(orgId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.and(t2 -> {
            t2.in(StoreEntity::getOrgId, (Collection)((List)childrenOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (parentsOrgIds.isSuccess() && parentsOrgIds.getData() != null) {
                t2.or(k -> (LambdaQueryWrapper)((LambdaQueryWrapper)k.in(StoreEntity::getOrgId, (Collection)((List)parentsOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()))).eq(StoreEntity::getProjectType, (Object)"2"));
            }
            return t2;
        });
        List list = this.storeService.list((Wrapper)wrapper);
        return this.instoreMaterialMapper.storeNumCount(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), materialIds);
    }

    private static /* synthetic */ void lambda$checkParams$5(Map planMap, Map numVOMap, BigDecimal divide, BillParamVO billParamVO, BigDecimal roleValue, String[] paramsArray, Map paramsCheckVOMap, Long k, MaterialPriceVO d) {
        BigDecimal _applyNum;
        BigDecimal num = d.getNum();
        BigDecimal applyNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(d.getMaterialId())));
        BigDecimal hasNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)numVOMap.get(d.getMaterialId())));
        BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
        if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) > 0) {
            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
            paramsCheckDsVO.setWarnName("\u52b3\u52a1\u961f\u4f0d\u9886\u6599\u51fa\u5e93\u91cf\u5927\u4e8e\u9886\u6599\u9650\u989d\u91cf");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u8be5\u6750\u6599\u672c\u6b21\u51fa\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u51fa\u5e93\u6570\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u9886\u6599\u9650\u989d\u6570\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
            paramsCheckDsVO.setContent(stringBuffer.toString());
            InstoreMaterialService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
        }
    }
}

