/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.mapper.SectionPlanChangeHisMapper;
import com.ejianc.business.plan.mapper.SectionPlanChangeMapper;
import com.ejianc.business.plan.mapper.SectionPlanChangeSubMapper;
import com.ejianc.business.plan.service.ISectionPlanChangeService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sectionPlanChangeService")
public class SectionPlanChangeServiceImpl
extends BaseServiceImpl<SectionPlanChangeMapper, SectionPlanChangeEntity>
implements ISectionPlanChangeService {
    @Autowired
    private ISectionPlanService sectionPlanService;
    @Autowired
    private SectionPlanChangeSubMapper sectionPlanChangeSubMapper;
    @Autowired
    private SectionPlanChangeHisMapper planChangeHisMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SectionPlanChangeEntity saveOrUpdatePlanChange(SectionPlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList()) && null != saveEntity.getId()) {
            this.sectionPlanChangeSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        SectionPlanEntity planEntity = (SectionPlanEntity)((Object)this.sectionPlanService.selectById(saveEntity.getSourcePlanId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            this.sectionPlanService.saveOrUpdate((Object)planEntity, false);
        }
        return saveEntity;
    }

    @Override
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = ((SectionPlanChangeMapper)this.baseMapper).selectBatchIds(changeIds);
        List planIds = changeList.stream().map(SectionPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.sectionPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.planChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            SectionPlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (SectionPlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setCurChangingPlanId(null);
        }
        this.sectionPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }
}

