/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataModel.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataModel.consts.DataModelEnum;
import com.ejianc.business.dataModel.service.MaterialDataModelService;
import com.ejianc.business.dataModel.vo.MaterialDataModelVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"materialDataModel"})
public class MaterialDataModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MaterialDataModelService materialDataModelService;

    public CommonResponse<List<MaterialDataModelVO>> getList(@RequestBody JSONObject param, HttpServletRequest request) {
        this.logger.info("\u9879\u76ee\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = MaterialDataModelController.processData(param);
        Long projectId = param.getLong("projectId");
        List<Long> materialTypeIds = listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), (Object)"material_id", materialIds);
        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
            queryWrapper.or(wrapper -> (QueryWrapper)((QueryWrapper)wrapper.in((Object)"material_type_id", (Collection)materialTypeIds)).isNull((Object)"material_id"));
        }
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
            materialDataModelVOs = this.materialDataModelService.queryList(projectId, null, (QueryWrapper<T>)queryWrapper);
        }
        materialDataModelVOs = MaterialDataModelController.getChildrenData(param, materialDataModelVOs);
        return CommonResponse.success((String)("\u6750\u6599\u60c5\u51b5\u5165\u53c2\uff1a" + param), materialDataModelVOs);
    }

    @RequestMapping(value={"/listByProject"}, method={RequestMethod.POST})
    public CommonResponse<List<MaterialDataModelVO>> getList2(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success((String)("\u6750\u6599\u60c5\u51b5\u5165\u53c2\uff1a" + param), this.materialDataModelService.queryListByProjectId(param));
    }

    @RequestMapping(value={"/listByContract"}, method={RequestMethod.POST})
    public CommonResponse<List<MaterialDataModelVO>> listByContract2(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success((String)("\u6750\u6599\u60c5\u51b5\u5165\u53c2\uff1a" + param), this.materialDataModelService.queryListByContractId(param));
    }

    @RequestMapping(value={"/listByContract4MaterType"}, method={RequestMethod.POST})
    public CommonResponse<List<MaterialDataModelVO>> listByContract4MaterType(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success((String)("\u6750\u6599\u60c5\u51b5\u5165\u53c2\uff1a" + param), this.materialDataModelService.queryListByContractId4Type(param));
    }

    public CommonResponse<List<MaterialDataModelVO>> listByContract(@RequestBody JSONObject param, HttpServletRequest request) {
        this.logger.info("\u5408\u540c\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = MaterialDataModelController.processData(param);
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        Long contractId = null;
        if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode)) {
            contractId = content.getLong("id");
        } else if (content.get((Object)"contractId") != null) {
            JSONObject contract = new JSONObject((Map)((HashMap)content.get((Object)"contractId")));
            contractId = contract.getLong("id");
        }
        List<Long> materialTypeIds = listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), (Object)"material_id", materialIds);
        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
            queryWrapper.or(wrapper -> (QueryWrapper)((QueryWrapper)wrapper.in((Object)"material_type_id", (Collection)materialTypeIds)).isNull((Object)"material_id"));
        }
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (contractId != null && (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds))) {
            materialDataModelVOs = this.materialDataModelService.queryList(null, contractId, (QueryWrapper<T>)queryWrapper);
        }
        materialDataModelVOs = MaterialDataModelController.getChildrenData(param, materialDataModelVOs);
        return CommonResponse.success((String)("\u6750\u6599\u60c5\u51b5\u5165\u53c2\uff1a" + param), materialDataModelVOs);
    }

    public static Map<String, List<Long>> processData(JSONObject param) {
        JSONArray jsonArray;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        String materialTypeId = "materialTypeId";
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Long> materialTypeIds = new ArrayList<Long>();
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode)) {
                materialTypeId = "materialCategoryId";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                if (subContent.get((Object)"materialId") != null) {
                    String materialId = (String)subContent.get((Object)"materialId");
                    materialIds.add(Long.parseLong(materialId));
                    continue;
                }
                String materialCategoryId = (String)subContent.get((Object)materialTypeId);
                materialTypeIds.add(Long.parseLong(materialCategoryId));
            }
        }
        map.put("materialTypeIds", materialTypeIds);
        map.put("materialIds", materialIds);
        return map;
    }

    public static List<MaterialDataModelVO> getChildrenData(JSONObject param, List<MaterialDataModelVO> materialDataModelVOs) {
        JSONArray jsonArray;
        ArrayList<MaterialDataModelVO> list = new ArrayList<MaterialDataModelVO>();
        Long projectId = param.getLong("projectId");
        String materialTypeId = "materialTypeId";
        String materialTypeName = "materialTypeName";
        String unit = "unit";
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        Map materialMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
        Map materialTypeMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() == null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialTypeId, Function.identity(), (key1, key2) -> key2));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode)) {
                materialTypeName = "materialCategoryName";
                materialTypeId = "materialCategoryId";
            }
            if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode().equals(billTypeCode)) {
                unit = "unitName";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                MaterialDataModelVO materialDataModelVO = new MaterialDataModelVO();
                long materialType = Long.parseLong(subContent.get((Object)materialTypeId).toString());
                long materialId = Long.parseLong(subContent.get((Object)"materialId") != null ? subContent.get((Object)"materialId").toString() : Long.toString(0L));
                if (materialMap.containsKey(materialId)) {
                    materialDataModelVO = (MaterialDataModelVO)materialMap.get(materialId);
                }
                if (materialTypeMap.containsKey(materialType)) {
                    materialDataModelVO = (MaterialDataModelVO)materialTypeMap.get(materialType);
                }
                if (!materialTypeMap.containsKey(materialType) && !materialMap.containsKey(materialId)) {
                    materialDataModelVO.setProjectId(projectId);
                    materialDataModelVO.setProjectName(content.get((Object)"projectName") != null ? content.get((Object)"projectName").toString() : "");
                    materialDataModelVO.setMaterialTypeId(Long.valueOf(materialType));
                    materialDataModelVO.setMaterialTypeName(subContent.get((Object)materialTypeName).toString());
                    materialDataModelVO.setMaterialName(subContent.get((Object)"materialName") != null ? subContent.get((Object)"materialName").toString() : "");
                    if (subContent.get((Object)"materialId") != null) {
                        materialDataModelVO.setMaterialId(Long.valueOf(Long.parseLong(subContent.get((Object)"materialId").toString())));
                    }
                    materialDataModelVO.setSpec(subContent.get((Object)"spec") != null ? subContent.get((Object)"spec").toString() : "");
                    String unitName = subContent.get((Object)unit) != null ? subContent.get((Object)unit).toString() : "";
                    materialDataModelVO.setUnitName(unitName);
                    materialDataModelVO.setContractNum(BigDecimal.ZERO);
                    materialDataModelVO.setPlanNum(BigDecimal.ZERO);
                    materialDataModelVO.setSettlementNum(BigDecimal.ZERO);
                }
                list.add(materialDataModelVO);
            }
        }
        return list;
    }
}

