/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materialContract/"})
public class MaterialContractApi {
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ICustomerApi customerApi;

    @PostMapping(value={"queryContractList"})
    CommonResponse<JSONObject> queryContractList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("org_name");
        queryParam.getFuzzyFields().add("supplier_name");
        queryParam.getOrderMap().put("create_time", "desc");
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        resp.put("pages", (Object)pageData.getPages());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"queryContractById"})
    CommonResponse<JSONObject> queryContractInfoById(@RequestParam(value="id") Long id) {
        JSONObject resp = new JSONObject();
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        resp.put("contract", (Object)contract);
        if (null != contract) {
            CommonResponse customerResp;
            CommonResponse supplierResp;
            if (null != contract.getSupplierId() && (supplierResp = this.supplierApi.queryById(contract.getSupplierId())).isSuccess()) {
                resp.put("supplier", supplierResp.getData());
            }
            if (null != contract.getContractorEnterpriseId() && (customerResp = this.customerApi.detailById(contract.getContractorEnterpriseId())).isSuccess()) {
                resp.put("customer", customerResp.getData());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"queryContractNumAndMoneyAndSettleMoneyByProjectId"})
    CommonResponse<JSONObject> queryContractNumAndMoneyAndSettleMoneyByProjectId(@RequestParam(value="projectId") Long projectId) {
        JSONObject resp = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List contractEntities = this.materialContractService.queryList(param, false);
        if (ListUtil.isEmpty((List)contractEntities)) {
            resp.put("number", (Object)0);
            resp.put("contractAmount", (Object)0.0);
            resp.put("settlementAmount", (Object)0.0);
            return CommonResponse.success((Object)resp);
        }
        resp.put("number", (Object)contractEntities.size());
        BigDecimal contractAmount = BigDecimal.ZERO;
        BigDecimal settlementAmount = BigDecimal.ZERO;
        for (int i = 0; i < contractEntities.size(); ++i) {
            MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)contractEntities.get(i));
            contractAmount = contractAmount.add(contractEntity.getAmountWithTax());
        }
        resp.put("contractAmount", (Object)contractAmount.setScale(2, 4));
        List purchaseSettlementEntities = this.purchaseSettlementService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)purchaseSettlementEntities)) {
            for (int i = 0; i < purchaseSettlementEntities.size(); ++i) {
                PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)purchaseSettlementEntities.get(i));
                settlementAmount = settlementAmount.add(purchaseSettlementEntity.getCurrentSettlementAmountTax());
            }
        }
        resp.put("settlementAmount", (Object)settlementAmount);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/getMonthMaterialMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialReportVo>> getMonthMaterialMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="lastDay") Integer lastDay) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.materialContractService.getMonthMaterialMny(projectId, lastDay));
    }

    @RequestMapping(value={"/getMaterialContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialReportVo> getMaterialContract(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.materialContractService.getMaterialContract(projectId));
    }

    @GetMapping(value={"fetchAmountWithTax"})
    public CommonResponse<BigDecimal> fetchAmountWithTax(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f", (Object)this.materialContractService.fetchAmountWithTax(projectId));
    }

    @PostMapping(value={"getContractByCondition"})
    @ResponseBody
    public CommonResponse<List<MaterialContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(MaterialContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
        lambdaUpdateWrapper.orderByDesc(MaterialContractEntity::getSignDate);
        List list = this.materialContractService.list((Wrapper)lambdaUpdateWrapper);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, MaterialContractVO.class));
    }

    @GetMapping(value={"fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((Object)this.materialContractService.fetchSjzcje(projectId));
    }
}

