/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.mapper.InstoreBillMapper;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreBillService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.InstoreBillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstoreBillService
extends BaseServiceImpl<InstoreBillMapper, InstoreBillEntity>
implements IInstoreBillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;
    @Autowired
    private IInstoreService instoreService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public IPage<InstoreBillVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), InstoreBillVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sureToReceive(InstoreBillEntity entity) {
        entity.getInstoreMaterialList().forEach(e -> {
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        super.saveOrUpdate((Object)entity, false);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(entity.getOutId()));
        if (outStoreEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8c03\u62e8\u51fa\u5e93\u5355\uff0c\u786e\u8ba4\u6536\u6599\u5931\u8d25\uff01");
        }
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o -> o.setStoreState(MaterialStoreState.USED.getCode()));
        this.iOutStoreService.saveOrUpdate((Object)outStoreEntity, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sureToReturn(InstoreBillEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(entity.getOutId()));
        if (outStoreEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8c03\u62e8\u51fa\u5e93\u5355\uff0c\u786e\u8ba4\u6536\u6599\u5931\u8d25\uff01");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o -> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        this.iOutStoreService.saveOrUpdate((Object)outStoreEntity, false);
    }

    @Override
    public void processCost(InstoreBillEntity entity) {
        String factor = "1";
        if (MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())) {
            factor = "-1";
        }
        if (ListUtil.isNotEmpty(entity.getInstoreMaterialList())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getInstoreMaterialList().size(); ++i) {
                CostDetailVO c;
                InstoreBillMaterialEntity sub = entity.getInstoreMaterialList().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L) {
                    c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                    if (sub.getAmount() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        BigDecimal rate = new BigDecimal("1.00");
                        rate = "-1".equals(factor) ? rate.add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4)) : rate.add(entity.getTaxRate() == null ? new BigDecimal("0.00") : entity.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                        BigDecimal happenMny = sub.getAmount().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                } else {
                    canPush = false;
                    break;
                }
                c.setHappenDate(entity.getInstoreDate());
                c.setMemo(entity.getNote());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getInstoreType()));
                c.setSourceTabType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getInstoreType()) + "\u5b50\u8868");
                list.add(c);
            }
            if (canPush) {
                CommonResponse response = this.iCostDetailApi.saveSubject(list);
                this.logger.info("\u63a8\u9001\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getInstoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("1");
            } else {
                CommonResponse response = this.iCostDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u5220\u9664\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getInstoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("0");
            }
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public List<InstoreBillMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return this.instoreBillMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreBillVO> amountSum(List<Long> projectIds) {
        return this.instoreBillMaterialMapper.amountSum(projectIds);
    }

    @Override
    public void pushInstoreManage(Long billId) {
        InstoreBillEntity instoreBillEntity;
        if (billId != null && (instoreBillEntity = (InstoreBillEntity)((Object)this.selectById(billId))) != null) {
            InstoreEntity instoreEntity = (InstoreEntity)((Object)BeanMapper.map((Object)((Object)instoreBillEntity), InstoreEntity.class));
            instoreEntity.setId(null);
            instoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            instoreEntity.getInstoreMaterialList().forEach(item -> item.setId(null));
            this.instoreService.saveOrUpdate((Object)instoreEntity, false);
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(instoreBillEntity.getId()), "BT211105000000001", "straightInoutBill", String.valueOf(instoreEntity.getId()), "BT200616000000005", "straightInout");
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)instoreBillEntity.getId());
            wrapper.set(InstoreBillEntity::getInstoreBillId, (Object)instoreEntity.getId());
            this.update((Wrapper)wrapper);
        }
    }

    @Override
    public boolean instoreIsRevoke(Long billId) {
        InstoreEntity instoreEntity;
        InstoreBillEntity instoreBillEntity;
        boolean flag = false;
        if (billId != null && (instoreBillEntity = (InstoreBillEntity)((Object)this.selectById(billId))) != null && ((instoreEntity = (InstoreEntity)((Object)this.instoreService.selectById(instoreBillEntity.getInstoreBillId()))) == null || instoreEntity.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode())) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void deleteInstoreBill(Long billId) {
        InstoreBillEntity instoreBillEntity;
        if (billId != null && (instoreBillEntity = (InstoreBillEntity)((Object)this.selectById(billId))) != null && instoreBillEntity.getInstoreBillId() != null) {
            this.instoreService.removeById(instoreBillEntity.getInstoreBillId(), false);
        }
    }
}

