/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.mapper.InstoreMapper;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstoreService
extends BaseServiceImpl<InstoreMapper, InstoreEntity>
implements IInstoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInstoreMaterialService materialService;
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;

    @Override
    public IPage<InstoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), InstoreVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sureToReceive(InstoreEntity entity) {
        entity.getInstoreMaterialList().forEach(e -> {
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        super.saveOrUpdate((Object)entity, false);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(entity.getOutId()));
        if (outStoreEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8c03\u62e8\u51fa\u5e93\u5355\uff0c\u786e\u8ba4\u6536\u6599\u5931\u8d25\uff01");
        }
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o -> o.setStoreState(MaterialStoreState.USED.getCode()));
        this.iOutStoreService.saveOrUpdate((Object)outStoreEntity, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sureToReturn(InstoreEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(entity.getOutId()));
        if (outStoreEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8c03\u62e8\u51fa\u5e93\u5355\uff0c\u786e\u8ba4\u6536\u6599\u5931\u8d25\uff01");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o -> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        this.iOutStoreService.saveOrUpdate((Object)outStoreEntity, false);
    }

    @Override
    public void processCost(InstoreEntity entity) {
        String factor = "1";
        if (MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())) {
            factor = "-1";
        }
        if (ListUtil.isNotEmpty(entity.getInstoreMaterialList())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getInstoreMaterialList().size(); ++i) {
                InstoreMaterialEntity sub = entity.getInstoreMaterialList().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = new BigDecimal("1.00");
                    rate = "-1".equals(factor) ? rate.add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4)) : rate.add(entity.getTaxRate() == null ? new BigDecimal("0.00") : entity.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getInstoreDate());
                c.setMemo(entity.getNote());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode((Integer)entity.getInstoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode((Integer)entity.getInstoreType()) + "_DETAIL");
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate instoreDate = entity.getInstoreDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName());
                c.setPeriod(instoreDate.format(df));
                c.setShareFlag(Integer.valueOf(0));
                c.setSourceBillCode(entity.getBillCode());
                if (Objects.equals(MaterialStoreType.RETURN_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.RETURN_IN_STORE.getDescription());
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickReturn/card?id=" + entity.getId());
                }
                if (Objects.equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.STRAIGHT_IN_STORE.getDescription());
                    c.setSourceBillUrl("/ejc-material-frontend/#/straightInout/card?id=" + entity.getId());
                }
                c.setNum(sub.getInstoreNumber() == null ? BigDecimal.ZERO : sub.getInstoreNumber());
                c.setMaterialId(sub.getMaterialId());
                c.setMaterialName(sub.getMaterialName());
                c.setMaterialTypeId(sub.getMaterialCategoryId());
                c.setMaterialTypeName(sub.getMaterialCategoryName());
                c.setUnit(sub.getMaterialUnit());
                c.setSpec(sub.getMaterialSpec());
                list.add(c);
            }
            CommonResponse response = this.iCostDetailApi.saveSubject(list);
            this.logger.info("\u63a8\u9001\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getInstoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public List<InstoreMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return this.instoreMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreAccountSumVO> amountSum(List<Long> projectIds) {
        return this.instoreMaterialMapper.amountSum(projectIds);
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper query = InstoreService.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(total_amount) as totalAmount"});
        Map amount = super.getMap((Wrapper)query);
        return null != amount ? new BigDecimal(amount.get("totalAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public List<MaterialContractDetailSubEntity> totalResidualQuantity(List<MaterialContractDetailSubEntity> records) {
        Map<Long, MaterialContractDetailSubEntity> detailMap = records.stream().collect(Collectors.toMap(BaseEntity::getId, e -> e));
        ArrayList<Long> ids = new ArrayList<Long>(detailMap.keySet());
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"source_id as sourceId,sum(instore_number) as instoreNumber"});
        query.eq((Object)"source_type", (Object)"contractMaterial");
        query.in((Object)"source_id", ids);
        query.groupBy((Object[])new String[]{"source_id"});
        List list = this.materialService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            for (MaterialContractDetailSubEntity entity : records) {
                entity.setResidualQuantity(entity.getCount());
            }
            return records;
        }
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber));
        for (Long id : ids) {
            MaterialContractDetailSubEntity detailSub;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (collect.containsKey(id)) {
                BigDecimal bigDecimal2 = bigDecimal = collect.get(id).compareTo(new BigDecimal(0.0)) == 0 ? new BigDecimal(0) : collect.get(id);
            }
            if (bigDecimal.compareTo((detailSub = detailMap.get(id)).getCount()) > -1) {
                detailMap.remove(id);
                continue;
            }
            detailSub.setResidualQuantity(detailSub.getCount().subtract(bigDecimal));
            detailMap.put(id, detailSub);
        }
        Collection<MaterialContractDetailSubEntity> values = detailMap.values();
        return new ArrayList<MaterialContractDetailSubEntity>(values);
    }

    @Override
    public CommonResponse<String> updateInStoreSettleFlag(List<InstoreMaterialVO> vos) {
        LambdaUpdateWrapper wrapper;
        Map<String, List<InstoreMaterialVO>> groupList = vos.stream().collect(Collectors.groupingBy(InstoreMaterialVO::getSettleFlag));
        if (groupList.containsKey("1")) {
            List<InstoreMaterialVO> settleTrueList = groupList.get("1");
            List settleTrueIds = settleTrueList.stream().map(e -> e.getId()).collect(Collectors.toList());
            wrapper = new LambdaUpdateWrapper();
            wrapper.in(BaseEntity::getId, settleTrueIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag, (Object)"1");
            this.materialService.update((Wrapper)wrapper);
        }
        if (groupList.containsKey("0")) {
            List<InstoreMaterialVO> settleFalseList = groupList.get("0");
            List settleFalseIds = settleFalseList.stream().map(e -> e.getId()).collect(Collectors.toList());
            wrapper = new LambdaUpdateWrapper();
            wrapper.in(BaseEntity::getId, settleFalseIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag, (Object)"0");
            this.materialService.update((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)"");
    }
}

