/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.mapper.PurchaseOrderMapper;
import com.ejianc.business.material.service.IPurchaseOrderService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.business.material.vo.PurchaseOrderVO;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
extends BaseServiceImpl<PurchaseOrderMapper, PurchaseOrderEntity>
implements IPurchaseOrderService {
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IUseApplyService useApplyService;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static String PARAM_APPLY_CONTROL_COUNT = "P-8S560862";
    private static String PARAM_PLAN_CONTROL_COUNT = "P-93M6k263";

    @Override
    public ParamsCheckVO checkParams(PurchaseOrderVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<PurchaseOrderDetailVO> purchaseOrderDetailList = vo.getPurchaseOrderDetailList();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isNotEmpty((Collection)purchaseOrderDetailList) && (int)purchaseOrderDetailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            CommonResponse response3;
            purchaseOrderDetailList = purchaseOrderDetailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            HashMap<Long, PurchaseOrderDetailVO> thisMap = new HashMap<Long, PurchaseOrderDetailVO>();
            purchaseOrderDetailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    PurchaseOrderDetailVO purchaseOrderDetailVO = (PurchaseOrderDetailVO)thisMap.get(item.getMaterialId());
                    purchaseOrderDetailVO.setOrderNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)purchaseOrderDetailVO.getOrderNum(), (BigDecimal)item.getOrderNum())));
                } else {
                    thisMap.put(item.getMaterialId(), (PurchaseOrderDetailVO)item);
                }
            });
            ArrayList<Long> materialIds = new ArrayList<Long>(thisMap.keySet());
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_CONTROL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u91c7\u8d2d\u8ba2\u5355\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                Long projectId = vo.getProjectId();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"project_id", (Object)projectId);
                List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                HashMap planMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)materialMasterPlanEntities)) {
                    QueryWrapper planSubWrapper = new QueryWrapper();
                    List planIds = materialMasterPlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    planSubWrapper.in((Object)"material_master_plan_id", planIds);
                    List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.get(item.getMaterialId()) != null) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(num), (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId()))));
                        } else {
                            planMap.put(item.getMaterialId(), ComputeUtil.toBigDecimal((Double)num));
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    List<MaterialPriceVO> vos = ((PurchaseOrderMapper)this.baseMapper).queryMaterialOrderCount(vo.getId(), vo.getProjectId(), materialIds);
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    thisMap.forEach((k, d) -> {
                        BigDecimal _applyNum;
                        BigDecimal num = d.getOrderNum();
                        BigDecimal applyNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(d.getMaterialId())));
                        BigDecimal hasNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)numVOMap.get(d.getMaterialId())));
                        BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
                        if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "orderNum");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getModel()) ? " [" + d.getModel() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u8ba2\u5355\u91cf\u5927\u4e8e\u7269\u8d44\u603b\u8ba1\u5212\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u8be5\u6750\u6599\u672c\u6b21\u8ba2\u5355\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8ba2\u5355\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u7269\u8d44\u603b\u8ba1\u5212\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            PurchaseOrderServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
            if (!(response3 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_APPLY_CONTROL_COUNT, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u7528\u6599\u7533\u8bf7\u91cf\u3011\u63a7\u5236\u3010\u91c7\u8d2d\u8ba2\u5355\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
            }
            List billParamVOS3 = (List)response3.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS3)) {
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 == billParamVO.getControlType()) continue;
                    List<MaterialPriceVO> vos = ((PurchaseOrderMapper)this.baseMapper).queryMaterialOrderCount(vo.getId(), vo.getProjectId(), materialIds);
                    List<MaterialApplyCountVO> applyCountVOS = this.useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);
                    Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    thisMap.forEach((k, d) -> {
                        BigDecimal _applyNum;
                        BigDecimal num = d.getOrderNum();
                        BigDecimal applyNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)applyVOMap.get(d.getMaterialId())));
                        BigDecimal hasNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)numVOMap.get(d.getMaterialId())));
                        BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
                        if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "orderNum");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getModel()) ? " [" + d.getModel() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u8ba2\u5355\u91cf\u5927\u4e8e\u7528\u6599\u7533\u8bf7\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u8be5\u6750\u6599\u672c\u6b21\u8ba2\u5355\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8ba2\u5355\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u7528\u6599\u7533\u8bf7\u6570\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            PurchaseOrderServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public List<PurchaseOrderDetailVO> querySubData(IPage<PurchaseOrderDetailEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = PurchaseOrderServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<PurchaseOrderDetailVO> list = ((PurchaseOrderMapper)this.baseMapper).querySubData(pageData, wrapper);
        return list;
    }

    @Override
    public List<InstoreMaterialVO> getInstoreMaterialByPurchaseOrder(List<Long> orderIdList) {
        return ((PurchaseOrderMapper)this.baseMapper).getInstoreMaterialByPurchaseOrder(orderIdList);
    }
}

