/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialMasterPlanService")
public class MaterialMasterPlanServiceImpl
extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity>
implements IMaterialMasterPlanService {
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plan_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        if (null != saveEntity.getId()) {
            this.materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return saveEntity;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        List materialSubList;
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
        paramControlVO.setProjectId(vo.getProjectId());
        paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
        if (!res.isSuccess()) {
            throw new BusinessException("\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = proQuantityAndMnyVO.getMaterialTaxMny() == null ? BigDecimal.ZERO : proQuantityAndMnyVO.getMaterialTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\u3011 \u63a7 \u3010\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    Iterator lastTotalPlanAmt = BigDecimal.ZERO;
                    BigDecimal totalPlanAmt = vo.getTotalPlanAmt() == null ? BigDecimal.ZERO : vo.getTotalPlanAmt();
                    BigDecimal planAmt = totalPlanAmt.add((BigDecimal)((Object)lastTotalPlanAmt));
                    if (planAmt.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = planAmt.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(vo.getPlanId(), "totalPlanAmt");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\u8d85\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    Iterator stringBuffer = new StringBuffer();
                    ((StringBuffer)((Object)stringBuffer)).append("\u8be5\u9879\u76ee\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\uff1a").append(planAmt.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(((StringBuffer)((Object)stringBuffer)).toString());
                    MaterialMasterPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialSubList = vo.getPlanControlSubVOList()))) {
            BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO;
            Map detailProMap;
            List subIds = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
            BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
            paramControlVO1.setProjectId(vo.getProjectId());
            paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
            paramControlVO1.setIds(subIds);
            CommonResponse res1 = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
            if (!res1.isSuccess()) {
                throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg());
            }
            if (null != res1.getData() && !(detailProMap = (proQuantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res1.getData()).getDetailProMap()).isEmpty()) {
                CommonResponse response1;
                BudgetProjectDetailProVO detailProVO;
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                    HashMap<Long, PlanControlSubVO> currentSubMap = new HashMap<Long, PlanControlSubVO>();
                    for (PlanControlSubVO masterPlanSubVO : materialSubList) {
                        if (currentSubMap.containsKey(masterPlanSubVO.getMaterialId())) {
                            PlanControlSubVO materialMasterPlanSubVO = (PlanControlSubVO)currentSubMap.get(masterPlanSubVO.getMaterialId());
                            materialMasterPlanSubVO.setNum(Double.valueOf(Double.sum(materialMasterPlanSubVO.getNum(), masterPlanSubVO.getNum())));
                            continue;
                        }
                        currentSubMap.put(masterPlanSubVO.getMaterialId(), masterPlanSubVO);
                    }
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        HashMap dProMap = new HashMap();
                        for (Map.Entry entry : detailProMap.entrySet()) {
                            BudgetProjectDetailProVO detailProVO2 = (BudgetProjectDetailProVO)entry.getValue();
                            BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                            BigDecimal num = detailProVO2.getNum() == null ? BigDecimal.ZERO : detailProVO2.getNum();
                            budgetProjectDetailProVO.setNum(num.multiply(scale));
                            dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                        }
                        for (Map.Entry entry : currentSubMap.entrySet()) {
                            BigDecimal dNum;
                            Long materialId = (Long)entry.getKey();
                            PlanControlSubVO planSubVO = (PlanControlSubVO)entry.getValue();
                            if (!dProMap.containsKey(materialId)) continue;
                            detailProVO = (BudgetProjectDetailProVO)dProMap.get(materialId);
                            BigDecimal cNum = BigDecimal.valueOf(planSubVO.getNum());
                            if (cNum.compareTo(dNum = detailProVO.getNum()) <= 0) continue;
                            BigDecimal over = cNum.subtract(dNum);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "num");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(planSubVO.getMaterialName() + "-" + planSubVO.getUnit() + "-" + planSubVO.getSpec());
                            paramsCheckDsVO.setWarnName("\u7269\u8d44\u603b\u8ba1\u5212\u6750\u6599\u6e05\u5355\u91cf\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u6863\u6848\u7d2f\u8ba1\u6570\u91cf\uff1a").append(cNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * ").append(roleValue).append("%\uff1a").append(dNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91cf\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialMasterPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
                if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
                }
                List billParamVOS1 = (List)response1.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                    HashMap<Long, PlanControlSubVO> currentSubMap = new HashMap<Long, PlanControlSubVO>();
                    for (PlanControlSubVO masterPlanSubVO : materialSubList) {
                        if (currentSubMap.containsKey(masterPlanSubVO.getMaterialId())) {
                            PlanControlSubVO materialMasterPlanSubVO = (PlanControlSubVO)currentSubMap.get(masterPlanSubVO.getMaterialId());
                            materialMasterPlanSubVO.setAmount(materialMasterPlanSubVO.getAmount().add(masterPlanSubVO.getAmount()));
                            continue;
                        }
                        currentSubMap.put(masterPlanSubVO.getMaterialId(), masterPlanSubVO);
                    }
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        HashMap dProMap = new HashMap();
                        for (Map.Entry entry : detailProMap.entrySet()) {
                            detailProVO = (BudgetProjectDetailProVO)entry.getValue();
                            BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                            BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                            budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                            dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                        }
                        for (Map.Entry entry : currentSubMap.entrySet()) {
                            BigDecimal dMaterialTaxMnyCost;
                            Long materialId = (Long)entry.getKey();
                            PlanControlSubVO planSubVO = (PlanControlSubVO)entry.getValue();
                            if (!dProMap.containsKey(materialId)) continue;
                            BudgetProjectDetailProVO detailProVO3 = (BudgetProjectDetailProVO)dProMap.get(materialId);
                            BigDecimal cAmount = planSubVO.getAmount();
                            if (cAmount.compareTo(dMaterialTaxMnyCost = detailProVO3.getMaterialTaxMnyCost()) <= 0) continue;
                            BigDecimal over = cAmount.subtract(dMaterialTaxMnyCost);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "amount");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(planSubVO.getMaterialName() + "-" + planSubVO.getUnit() + "-" + planSubVO.getSpec());
                            paramsCheckDsVO.setWarnName("\u7269\u8d44\u603b\u8ba1\u5212\u6750\u6599\u6e05\u5355\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(" \u6863\u6848\u7d2f\u8ba1\u91d1\u989d\uff1a").append(cAmount.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialMasterPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }
}

