/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialMasterPlan")
public class PlanBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IPlanChangeHisService planChangeHisService;
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.materialMasterPlanService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(billId));
        e.setEffectiveDate(new Date());
        if (state == 1) {
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        this.materialMasterPlanService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(billId));
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(billId));
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u64a4\u56de\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

