/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.bean.SectionPlanChangeHisEntity;
import com.ejianc.business.plan.bean.SectionPlanChangeSubEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanSubEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeHisService;
import com.ejianc.business.plan.service.ISectionPlanChangeService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.service.ISectionPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class SectionPlanChangeThread
implements Runnable {
    private Logger logger;
    private Long billId;
    private Integer state;
    private ISectionPlanChangeService changeService;
    private ISectionPlanChangeHisService changeHisService;
    private ISectionPlanService planService;
    private ISectionPlanSubService planSubService;
    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setChangeService(ISectionPlanChangeService changeService) {
        this.changeService = changeService;
    }

    public void setChangeHisService(ISectionPlanChangeHisService changeHisService) {
        this.changeHisService = changeHisService;
    }

    public void setPlanService(ISectionPlanService planService) {
        this.planService = planService;
    }

    public void setPlanSubService(ISectionPlanSubService planSubService) {
        this.planSubService = planSubService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            this.doSomething();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            String infomsg = sw.toString();
            this.logger.error(infomsg);
        }
    }

    public void doSomething() {
        this.logger.info("\u7ebf\u7a0b\u5f00\u59cb----------------");
        SectionPlanChangeEntity planChange = (SectionPlanChangeEntity)((Object)this.changeService.selectById(this.billId));
        SectionPlanEntity newPlanEntity = null;
        SectionPlanEntity oldPlan = (SectionPlanEntity)((Object)this.planService.selectById(planChange.getSourcePlanId()));
        if (this.state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(this.userCode);
            planChange.setCommitUserName(this.userName);
        }
        planChange.setEffectiveDate(new Date());
        SectionPlanChangeHisEntity recordEntity = (SectionPlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), SectionPlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u6b63\u5728\u56de\u8c03");
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMaterialSubList())) {
            recordEntity.getMaterialSubList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(oldPlan.getCurChangingPlanId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if (recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0.0);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4).doubleValue());
        }
        this.changeHisService.saveOrUpdate((Object)recordEntity, false);
        this.changeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (SectionPlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), SectionPlanEntity.class));
        newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingPlanId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        newPlanEntity.setBillState(oldPlan.getBillState());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
            ArrayList<SectionPlanSubEntity> list = new ArrayList<SectionPlanSubEntity>();
            SectionPlanSubEntity tmp = null;
            Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
            for (SectionPlanChangeSubEntity detail2 : planChange.getMaterialSubList()) {
                tmp = (SectionPlanSubEntity)((Object)BeanMapper.map((Object)((Object)detail2), SectionPlanSubEntity.class));
                if (null != detail2.getTargetId()) {
                    tmp.setId(detail2.getTargetId());
                    tmp.setVersion(map.get(detail2.getTargetId()));
                    if ("2".equals(detail2.getChangeType())) {
                        delDetailIds.add(detail2.getTargetId());
                        continue;
                    }
                    tmp.setRowState("update");
                    list.add(tmp);
                    continue;
                }
                tmp.setRowState("add");
                list.add(tmp);
            }
            newPlanEntity.setMaterialSubList(list);
        }
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.planSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
        }
        if (this.planService.saveOrUpdate((Object)newPlanEntity, false)) {
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        } else {
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
        }
    }
}

