/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storeCheck.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.bean.StoreCheckSubEntity;
import com.ejianc.business.storeCheck.service.IStoreCheckService;
import com.ejianc.business.storeCheck.service.IStoreCheckSubService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="storeCheck")
public class StoreCheckBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IStoreCheckService storeCheckService;
    @Autowired
    private IStoreCheckSubService storeCheckSubService;
    @Autowired
    private IInstoreService instoreService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IInstoreMaterialService instoreMaterialService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String IN_STORE_BILL_CODE = "MATERIAL-INSTORE";
    private static final String OUT_STORE_BILL_CODE = "MATERIAL-OUTSTORE";
    private static final String IN_STORE_BILL_TYPE_CODE = "BT200611000000015";
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return this.submitCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return this.submitCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> submitCheck(Long billId, Integer state, String billTypeCode) {
        StoreCheckEntity e = (StoreCheckEntity)((Object)this.storeCheckService.selectById(billId));
        if (e == null) {
            return CommonResponse.success((String)"\u76d8\u70b9\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u5339\u914d\u7684\u5355\u636e\u4fe1\u606f\uff01");
        }
        this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010{}\u3011\u6267\u884c\u63d0\u4ea4\u524d\u6821\u9a8c\u903b\u8f91\uff01", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if (CollectionUtils.isEmpty(e.getMaterialSubList())) {
            return CommonResponse.error((String)"\u76d8\u70b9\u5355\u636e\u63d0\u4ea4\u5931\u8d25, \u76d8\u70b9\u5355\u636e\u4e2d\u7f3a\u5c11\u8981\u76d8\u70b9\u7684\u7269\u8d44\u4fe1\u606f\uff01");
        }
        return CommonResponse.success((String)"\u76d8\u70b9\u5355\u636e\u6267\u884c\u63d0\u4ea4\u524d\u6821\u9a8c\u5b8c\u6210\uff0c\u6821\u9a8c\u901a\u8fc7\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        StoreCheckEntity e = (StoreCheckEntity)((Object)this.storeCheckService.selectById(billId));
        this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010{}\u3011\u6267\u884c\u63d0\u4ea4\u5904\u7406\u903b\u8f91\uff01", (Object)JSONObject.toJSONString((Object)((Object)e)));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.storeCheckService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4ed3\u5e93\u76d8\u70b9\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StoreCheckEntity e = (StoreCheckEntity)((Object)this.storeCheckService.selectById(billId));
        this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010{}\u3011\u6267\u884c\u5ba1\u6279\u901a\u8fc7\u5904\u7406\u903b\u8f91\uff01", (Object)JSONObject.toJSONString((Object)((Object)e)));
        e.setEffectiveDate(new Date());
        if (state == 1) {
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        ArrayList<InstoreMaterialEntity> inStoreList = new ArrayList<InstoreMaterialEntity>();
        InstoreEntity instoreEntity = null;
        OutStoreEntity outStoreEntity = null;
        ArrayList<OutStoreSubEntity> outStoreList = new ArrayList<OutStoreSubEntity>();
        if (CollectionUtils.isNotEmpty(e.getMaterialSubList())) {
            CommonResponse billCodeResp;
            for (StoreCheckSubEntity sub : e.getMaterialSubList()) {
                if (sub.getInventory() > 0.0) {
                    inStoreList.add(this.generateInStoreBill(sub, e));
                    continue;
                }
                if (!(sub.getInventory() < 0.0)) continue;
                this.generateOutStoreBill(sub, e, outStoreList);
            }
            if (CollectionUtils.isNotEmpty(inStoreList)) {
                ArrayList<String> materialNames = new ArrayList<String>();
                BigDecimal totalAmt = BigDecimal.ZERO.setScale(8);
                BigDecimal totalCount = BigDecimal.ZERO.setScale(8);
                for (InstoreMaterialEntity item : inStoreList) {
                    materialNames.add(item.getMaterialName());
                    totalAmt = totalAmt.add(item.getAmount());
                    totalCount = totalCount.add(item.getInstoreNumber());
                }
                instoreEntity = new InstoreEntity();
                billCodeResp = this.billCodeApi.getCodeBatchByRuleCode(IN_STORE_BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCodeResp.isSuccess()) {
                    return CommonResponse.error((String)"\u4ed3\u5e93\u76d8\u70b9\u5ba1\u6279\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u751f\u6210\u5165\u5e93\u5355\u7f16\u7801\u5931\u8d25\uff01");
                }
                instoreEntity.setBillCode((String)billCodeResp.getData());
                instoreEntity.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                instoreEntity.setInstoreDate(e.getCheckDate());
                instoreEntity.setInstoreMaterialList(inStoreList);
                instoreEntity.setInstoreType(MaterialStoreType.INVENTORY_PROFIT_IN_STORE.getCode());
                instoreEntity.setOrgId(e.getOrgId());
                instoreEntity.setOrgName(e.getOrgName());
                instoreEntity.setMaterialName(StringUtils.join(materialNames, (String)","));
                instoreEntity.setContractType("noContract");
                instoreEntity.setStoreId(e.getStoreId());
                instoreEntity.setStoreName(e.getStoreName());
                instoreEntity.setTaxRate(new BigDecimal(0));
                instoreEntity.setTotalAmount(totalAmt);
                instoreEntity.setTotalAmountNoTax(totalAmt);
                instoreEntity.setTotalCount(totalCount);
                instoreEntity.setNote(MaterialStoreType.INVENTORY_PROFIT_IN_STORE.getDescription());
                instoreEntity.setPurpose(MaterialStoreType.INVENTORY_PROFIT_IN_STORE.getDescription());
            }
            if (CollectionUtils.isNotEmpty(outStoreList)) {
                ArrayList<String> outMaterialNames = new ArrayList<String>();
                BigDecimal outTotalAmt = BigDecimal.ZERO.setScale(8);
                BigDecimal outTotalCount = BigDecimal.ZERO.setScale(8);
                for (InstoreMaterialEntity item : inStoreList) {
                    outMaterialNames.add(item.getMaterialName());
                    outTotalAmt = outTotalAmt.add(item.getAmount());
                    outTotalCount = outTotalCount.add(item.getInstoreNumber());
                }
                outStoreEntity = new OutStoreEntity();
                billCodeResp = this.billCodeApi.getCodeBatchByRuleCode(OUT_STORE_BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCodeResp.isSuccess()) {
                    return CommonResponse.error((String)"\u4ed3\u5e93\u76d8\u70b9\u5ba1\u6279\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u751f\u6210\u5165\u5e93\u5355\u7f16\u7801\u5931\u8d25\uff01");
                }
                outStoreEntity.setBillCode((String)billCodeResp.getData());
                outStoreEntity.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                outStoreEntity.setOutDate(e.getCheckDate());
                outStoreEntity.setOutStoreSubEntities(outStoreList);
                outStoreEntity.setStoreType(MaterialStoreType.INVENTORY_LOSSES_OUT_STORE.getCode());
                outStoreEntity.setOrgId(e.getOrgId());
                outStoreEntity.setOrgName(e.getOrgName());
                outStoreEntity.setMaterialNames(StringUtils.join(outMaterialNames, (String)","));
                outStoreEntity.setProjectFlag("0");
                outStoreEntity.setStoreId(e.getStoreId());
                outStoreEntity.setStoreName(e.getStoreName());
                outStoreEntity.setOutMoney(outTotalAmt);
                outStoreEntity.setOutMoneyNoTax(outTotalAmt);
                outStoreEntity.setOutNum(outTotalCount);
                outStoreEntity.setUseFor(MaterialStoreType.INVENTORY_LOSSES_OUT_STORE.getDescription());
                outStoreEntity.setMemo(MaterialStoreType.INVENTORY_LOSSES_OUT_STORE.getDescription());
                outStoreEntity.setTaxRate(BigDecimal.ZERO.setScale(8));
            }
        }
        if (null != instoreEntity) {
            this.instoreService.saveOrUpdate((Object)instoreEntity, false);
            e.setRelationInStoreId(instoreEntity.getId());
        } else {
            e.setRelationInStoreId(null);
        }
        if (null != outStoreEntity) {
            this.outStoreService.saveOrUpdate((Object)outStoreEntity, false);
            e.setRelationOutStoreId(outStoreEntity.getId());
        } else {
            e.setRelationOutStoreId(null);
        }
        this.storeCheckService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4ed3\u5e93\u76d8\u70b9\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private InstoreMaterialEntity generateInStoreBill(StoreCheckSubEntity materialEntity, StoreCheckEntity e) {
        InstoreMaterialEntity resp = new InstoreMaterialEntity();
        BigDecimal instorNumber = new BigDecimal(null != materialEntity.getInventory() ? materialEntity.getInventory().toString() : "0");
        resp.setInstoreDate(e.getCheckDate());
        resp.setAmount(null != materialEntity.getPrice() ? materialEntity.getPrice().multiply(instorNumber) : BigDecimal.ZERO.setScale(8));
        resp.setStoreId(e.getStoreId());
        resp.setInstoreNumber(instorNumber);
        resp.setStoreState(3);
        resp.setMaterialName(materialEntity.getMaterialName());
        resp.setMaterialId(materialEntity.getMaterialId());
        resp.setMaterialCategoryId(materialEntity.getMaterialCategoryId());
        resp.setMaterialCategoryName(materialEntity.getMaterialCategoryName());
        resp.setMaterialSpec(materialEntity.getSpec());
        resp.setMaterialUnit(materialEntity.getUnit());
        resp.setUnitPrice(materialEntity.getPrice());
        resp.setRemark(materialEntity.getRemark());
        resp.setTaxRate(BigDecimal.ZERO.setScale(8));
        resp.setInstoreType(MaterialStoreType.INVENTORY_PROFIT_IN_STORE.getCode());
        resp.setSourceId(materialEntity.getId());
        resp.setSourceType(MaterialStoreType.INVENTORY_PROFIT_IN_STORE.getDescription());
        resp.setSourceMainId(e.getId().toString());
        resp.setSectionId(materialEntity.getSectionId());
        resp.setSectionName(materialEntity.getSectionName());
        return resp;
    }

    private void generateOutStoreBill(StoreCheckSubEntity materialEntity, StoreCheckEntity e, List<OutStoreSubEntity> outStoreList) {
        List<InstoreMaterialVO> usableMaterialList = this.instoreMaterialService.querySubMaterialStoreInfo(e.getStoreId(), e.getCheckDate(), materialEntity.getMaterialId(), Math.abs(materialEntity.getInventory()));
        BigDecimal outNum = new BigDecimal(Math.abs(materialEntity.getInventory()));
        OutStoreSubEntity resp = new OutStoreSubEntity();
        resp.setStoreId(e.getStoreId());
        resp.setStoreState(1);
        resp.setStoreType(MaterialStoreType.INVENTORY_LOSSES_OUT_STORE.getCode());
        resp.setOutDate(e.getCheckDate());
        resp.setMaterialName(materialEntity.getMaterialName());
        resp.setMaterialId(materialEntity.getMaterialId());
        resp.setMaterialCategoryId(materialEntity.getMaterialCategoryId());
        resp.setMaterialCategoryName(materialEntity.getMaterialCategoryName());
        resp.setMaterialSpec(materialEntity.getSpec());
        resp.setMaterialUnit(materialEntity.getUnit());
        resp.setRemark(materialEntity.getRemark());
        resp.setTaxRate(BigDecimal.ZERO.setScale(8));
        resp.setUnitPrice(materialEntity.getPrice());
        int compareResult = 0;
        OutStoreSubEntity tmp = null;
        for (InstoreMaterialVO instoreMaterialVO : usableMaterialList) {
            if (null == instoreMaterialVO.getSectionId() || null == materialEntity.getSectionId() || instoreMaterialVO.getSectionId() != materialEntity.getSectionId()) continue;
            compareResult = instoreMaterialVO.getInstoreNumber().compareTo(outNum);
            tmp = (OutStoreSubEntity)((Object)BeanMapper.map((Object)((Object)resp), OutStoreSubEntity.class));
            tmp.setInStoreMoney(instoreMaterialVO.getStoreAmount());
            tmp.setInStorePrice(instoreMaterialVO.getUnitPrice());
            tmp.setCheckSubId(materialEntity.getId());
            tmp.setCheckMainId(e.getId());
            tmp.setSectionId(materialEntity.getSectionId());
            tmp.setSectionName(materialEntity.getSectionName());
            tmp.setSourceMainId(instoreMaterialVO.getInstoreId());
            tmp.setSourceSubId(instoreMaterialVO.getId());
            switch (compareResult) {
                case -1: {
                    tmp.setOutStoreNumber(instoreMaterialVO.getInstoreNumber());
                    tmp.setAmount(null != instoreMaterialVO.getUnitPrice() ? instoreMaterialVO.getInstoreNumber().multiply(instoreMaterialVO.getUnitPrice()) : BigDecimal.ZERO.setScale(8));
                    outNum = outNum.subtract(instoreMaterialVO.getInstoreNumber());
                    break;
                }
                case 0: 
                case 1: {
                    tmp.setOutStoreNumber(outNum);
                    tmp.setAmount(null != instoreMaterialVO.getUnitPrice() ? outNum.multiply(instoreMaterialVO.getUnitPrice()) : BigDecimal.ZERO.setScale(8));
                    outNum = BigDecimal.ZERO.setScale(8);
                }
            }
            outStoreList.add(tmp);
            if (outNum.compareTo(BigDecimal.ZERO.setScale(8)) != 0) continue;
            break;
        }
        if (outNum.compareTo(BigDecimal.ZERO.setScale(8)) < 0) {
            this.logger.error("\u76d8\u70b9\u7269\u8d44-{}\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u5e93\u5b58\u6570\u91cf", (Object)JSONObject.toJSONString((Object)((Object)materialEntity)));
            throw new BusinessException("\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u7269\u8d44\u5e93\u5b58\u603b\u6570\u91cf\uff01");
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.delCheckRecords(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp;
        StoreCheckEntity e = (StoreCheckEntity)((Object)this.storeCheckService.selectById(billId));
        this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010{}\u3011\u64a4\u56de\u524d\u6821\u9a8c", (Object)JSONObject.toJSONString((Object)((Object)e)));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"store_id", (Object)e.getStoreId());
        query.gt((Object)"check_date", (Object)e.getCheckDate());
        List entityList = this.storeCheckService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u5728\u8be5\u76d8\u70b9\u5355\u636e\u4e4b\u540e\u5b58\u5728\u65b0\u7684\u76d8\u70b9\u5355\u636e!");
        }
        if (null != e.getRelationInStoreId() && !(resp = this.billTypeApi.checkQuote(IN_STORE_BILL_TYPE_CODE, e.getRelationInStoreId())).isSuccess()) {
            this.logger.info("\u76d8\u70b9\u5355\u636e\u3010billId-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)billId, (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u524d\u6821\u9a8c\u901a\u8fc7\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.delCheckRecords(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    CommonResponse<String> delCheckRecords(Long billId, Integer state, String billTypeCode) {
        StoreCheckEntity e = (StoreCheckEntity)((Object)this.storeCheckService.selectById(billId));
        this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010{}\u3011\u6267\u884c\u64a4\u56de\u903b\u8f91", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if (null != e.getRelationInStoreId()) {
            this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010ID: {}\u3011\u64a4\u56de\uff0c\u5220\u9664\u5bf9\u5e94\u5165\u5e93\u5355\u636e-\u3010ID\uff1a{}\u3011", (Object)e.getId(), (Object)e.getRelationInStoreId());
            this.instoreService.removeById(e.getRelationInStoreId(), false);
        }
        if (null != e.getRelationOutStoreId()) {
            this.logger.info("\u76d8\u70b9\u5355\u636e-\u3010ID: {}\u3011\u64a4\u56de\uff0c\u5220\u9664\u5bf9\u5e94\u51fa\u5e93\u5355\u636e-\u3010ID\uff1a{}\u3011", (Object)e.getId(), (Object)e.getRelationOutStoreId());
            this.outStoreService.removeById(e.getRelationOutStoreId(), false);
        }
        return CommonResponse.success((String)"\u6267\u884c\u76d8\u70b9\u5355\u636e\u64a4\u56de\u903b\u8f91\u6210\u529f\uff01");
    }
}

