package com.ejianc.business.dataModel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.dataModel.consts.DataModelEnum;
import com.ejianc.business.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @versin 1.0
 * @description: 数据模型-材料执行情况
 * @date 2022/6/16
 */
@Service("materialDataModelService")
public class MaterialDataModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MaterialContractMapper contractMapper;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;


    public List<MaterialDataModelVO> queryList(Long projectId, Long contractId, QueryWrapper<T> queryWrapper) {
        return contractMapper.queryMaterialDataModelList(projectId, contractId, queryWrapper);
    }

    /**
     * 根据材料分类id查询合同大类数量
     *
     * @param projectId    项目id
     * @param contractId   合同id
     * @param queryWrapper 查询条件
     * @return 查询结果
     */
    public List<MaterialDataModelVO> queryContractByMaterialTypeIdList(Long projectId, Long contractId,
                                                                       QueryWrapper<T> queryWrapper) {
        return contractMapper.queryContractByMaterialTypeIdList(projectId, contractId, queryWrapper);
    }

    /**
     * 根据项目查询数据模型
     *
     * @param param 查询参数
     * @return 查询结果
     */
    public List<MaterialDataModelVO> queryListByProjectId(JSONObject param) {
        logger.info("项目材料情况入参 : {}", param);
        Map<String, List<Long>> listMap = processData(param);
        logger.info("listMap：{}", JSONObject.toJSONString(listMap));
        Long projectId = param.getLong("projectId");
        String billTypeCode = param.getString("billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        List<Long> materialTypeIds;
        // 如果只能选择小类，则需要获取全部分类id，需要查询合同对应的分类数据
        if (!isTypeFlag) {
            materialTypeIds = listMap.get("allMaterialTypeIds");
        }
        else {
            materialTypeIds = listMap.get("materialTypeIds");
        }
        List<Long> materialIds = listMap.get("materialIds");
//        QueryWrapper<T> queryWrapper = new QueryWrapper();
//        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), "material_id", materialIds);
//        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
//            queryWrapper.or(wrapper -> wrapper.in("material_type_id", materialTypeIds).isNull("material_id"));
//        }
        logger.info("isTypeFlag:{}",isTypeFlag);
        logger.info("materialTypeIds:{}",JSONObject.toJSONString(materialTypeIds));
        logger.info("materialIds:{}",JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
            materialDataModelVOs = this.queryMaterialDataList(projectId, null, materialIds, materialTypeIds);
        }
        materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs);
        if (CollectionUtils.isNotEmpty(materialDataModelVOs)) {
            CommonResponse<Map<Long, BigDecimal>> mapCommonResponse = budgetProjectProApi.getBudgetProjectProQuantityByProjectId(projectId);
            logger.info("查询预算总量结果：{}", JSONObject.toJSONString(mapCommonResponse));
            if (mapCommonResponse.isSuccess()) {
                Map<Long, BigDecimal> materialTypeMap = mapCommonResponse.getData();
                for (MaterialDataModelVO materialDataModelVO : materialDataModelVOs) {
                    if (materialTypeMap != null) {
                        BigDecimal budgetNum = materialTypeMap.get(materialDataModelVO.getMaterialId());
                        if (budgetNum == null) {
                            budgetNum = BigDecimal.ZERO;
                        }
                        materialDataModelVO.setBudgetNum(budgetNum);
                    }
                }
            }
            materialDataModelVOs = materialDataModelVOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getMaterialId()))), ArrayList::new));
        }
        return materialDataModelVOs;
    }

    /**
     * 根据合同id查询数据模型
     *
     * @param param 查询参数
     * @return 查询结果
     */
    public List<MaterialDataModelVO> queryListByContractId(JSONObject param) {
        logger.info("合同材料情况入参 : {}", param);
        Map<String, List<Long>> listMap = processData(param);
        Object bill = param.get("bill");
        JSONObject content = new JSONObject((HashMap) bill);
        String billTypeCode = (String) param.get("billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        Long contractId = null;
        if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode)) {
            contractId = content.getLong("id");
        }
        else {
            if (content.get("contractId") != null) {
                JSONObject contract = new JSONObject((HashMap) content.get("contractId"));
                contractId = contract.getLong("id");
            }
        }

        List<Long> materialTypeIds;
        // 如果只能选择小类，则需要获取全部分类id，需要查询合同对应的分类数据
        if (!isTypeFlag) {
            materialTypeIds = listMap.get("allMaterialTypeIds");
        }
        else {
            materialTypeIds = listMap.get("materialTypeIds");
        }
        List<Long> materialIds = listMap.get("materialIds");
//        QueryWrapper<T> queryWrapper = new QueryWrapper();
//        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), "material_id", materialIds);
//        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
//            queryWrapper.or(wrapper -> wrapper.in("material_type_id", materialTypeIds).isNull("material_id"));
//        }
        logger.info("isTypeFlag:{}",isTypeFlag);
        logger.info("materialTypeIds:{}",JSONObject.toJSONString(materialTypeIds));
        logger.info("materialIds:{}",JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<>();
        if (contractId != null) {
            if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
//                materialDataModelVOs = materialDataModelService.queryList(null, contractId, queryWrapper);
                materialDataModelVOs = this.queryMaterialDataList(null, contractId, materialIds, materialTypeIds);
            }
        }
        materialDataModelVOs = getChildrenData(param, materialDataModelVOs);
        materialDataModelVOs = materialDataModelVOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getMaterialId()))), ArrayList::new));
        return materialDataModelVOs;
    }

    public List<MaterialDataModelVO> queryListByContractId4Type(JSONObject param) {
        logger.info("合同材料情况入参 : {}", param);
        Map<String, List<Long>> listMap = processData(param);
        Object bill = param.get("bill");
        JSONObject content = new JSONObject((HashMap) bill);
        String billTypeCode = (String) param.get("billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        Long contractId = null;
        if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode)) {
            contractId = content.getLong("id");
        }
        else {
            if (content.get("contractId") != null) {
                JSONObject contract = new JSONObject((HashMap) content.get("contractId"));
                contractId = contract.getLong("id");
            }
        }

        List<Long> materialTypeIds;
        // 如果只能选择小类，则需要获取全部分类id，需要查询合同对应的分类数据
        if (!isTypeFlag) {
            materialTypeIds = listMap.get("allMaterialTypeIds");
        }
        else {
            materialTypeIds = listMap.get("materialTypeIds");
        }
//        List<Long> materialIds = listMap.get("materialIds");
//        QueryWrapper<T> queryWrapper = new QueryWrapper();
//        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), "material_id", materialIds);
//        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
//            queryWrapper.or(wrapper -> wrapper.in("material_type_id", materialTypeIds).isNull("material_id"));
//        }
        logger.info("isTypeFlag:{}",isTypeFlag);
        logger.info("materialTypeIds:{}",JSONObject.toJSONString(materialTypeIds));
//        logger.info("materialIds:{}",JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<>();
        if (contractId != null) {
            //if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
//                materialDataModelVOs = materialDataModelService.queryList(null, contractId, queryWrapper);
                materialDataModelVOs = this.queryMaterialDataList4Type(contractId);
           // }
        }
        materialDataModelVOs = getChildrenData(param, materialDataModelVOs);
        materialDataModelVOs = materialDataModelVOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getMaterialTypeId()))), ArrayList::new));
        return materialDataModelVOs;
    }

    /**
     * 查询材料分类数据及材料数据合集
     *
     * @param projectId          项目id
     * @param contractId         合同id
     * @param materialIdList     材料id
     * @param materialTypeIdList 材料分类id
     * @return
     */
    private List<MaterialDataModelVO> queryMaterialDataList(Long projectId, Long contractId,
                                                            List<Long> materialIdList, List<Long> materialTypeIdList) {
        logger.info("查询数据模型参数：projectId:{},contractId:{}", projectId, contractId);
        logger.info("materialIdList：{}", JSONObject.toJSONString(materialIdList));
        logger.info("materialTypeIdList：{}", JSONObject.toJSONString(materialTypeIdList));
        List<MaterialDataModelVO> rtnList = new ArrayList<>();
        // 查询明细数据
        QueryWrapper<T> materialWrapper = new QueryWrapper<>();
        materialWrapper.in(CollectionUtils.isNotEmpty(materialIdList), "material_id", materialIdList);
        List<MaterialDataModelVO> materialModelList = contractMapper
                .queryListByMaterialId(projectId, contractId, materialWrapper);
        rtnList.addAll(materialModelList);
        // 查询大类数据
       /* QueryWrapper<T> materialTypeWrapper = new QueryWrapper<>();
        materialTypeWrapper.in(CollectionUtils.isNotEmpty(materialTypeIdList), "material_type_id", materialTypeIdList)
                .and(wer -> wer.notIn(CollectionUtils.isNotEmpty(materialIdList),"material_id", materialIdList)
                        .or(wor -> wor.isNull("material_id")));
        List<MaterialDataModelVO> materialTypeModelList = contractMapper
                .queryListByMaterialTypeId(projectId, contractId, materialTypeWrapper);
        rtnList.addAll(materialTypeModelList);*/
        logger.info("查询数据模型结果：{}", JSONObject.toJSONString(rtnList));
        return rtnList;
    }

    private List<MaterialDataModelVO> queryMaterialDataList4Type( Long contractId
                                                         ) {

        List<MaterialDataModelVO> rtnList = new ArrayList<>();
        // 查询明细数据
//        QueryWrapper<T> materialWrapper = new QueryWrapper<>();
//        materialWrapper.in(CollectionUtils.isNotEmpty(materialIdList), "material_id", materialIdList);
        List<MaterialDataModelVO> materialModelList = contractMapper
                .queryListByMaterialTypeId2(contractId);
        rtnList.addAll(materialModelList);
        // 查询大类数据
       /* QueryWrapper<T> materialTypeWrapper = new QueryWrapper<>();
        materialTypeWrapper.in(CollectionUtils.isNotEmpty(materialTypeIdList), "material_type_id", materialTypeIdList)
                .and(wer -> wer.notIn(CollectionUtils.isNotEmpty(materialIdList),"material_id", materialIdList)
                        .or(wor -> wor.isNull("material_id")));
        List<MaterialDataModelVO> materialTypeModelList = contractMapper
                .queryListByMaterialTypeId(projectId, contractId, materialTypeWrapper);
        rtnList.addAll(materialTypeModelList);*/
        logger.info("查询数据模型结果：{}", JSONObject.toJSONString(rtnList));
        return rtnList;
    }


    private Map<String, List<Long>> processData(JSONObject param) {
        Map<String, List<Long>> map = new HashMap<>();
        String materialTypeId = "materialTypeId";
        List<Long> materialIds = new ArrayList<>();
        List<Long> materialTypeIds = new ArrayList<>();
        List<Long> allMaterialTypeIds = new ArrayList<>();
        String billTypeCode = (String) param.get("billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get("bill");
        JSONObject content = new JSONObject((HashMap) bill);
        if (content.get(subTableName) != null) {
            JSONArray jsonArray = content.getJSONArray(subTableName);
            if (jsonArray != null) {
                if (DataModelEnum.物资总计划.getCode().equals(billTypeCode)
                        || DataModelEnum.物资总计划变更.getCode().equals(billTypeCode)) {
                    materialTypeId = "materialCategoryId";
                }
                for (Object o : jsonArray) {
                    JSONObject subContent = new JSONObject((HashMap) o);
                    if (subContent.get("materialId") != null) {
                        String materialId = (String) subContent.get("materialId");
                        materialIds.add(Long.parseLong(materialId));
                    }
                    else {
                        String materialCategoryId = (String) subContent.get(materialTypeId);
                        materialTypeIds.add(Long.parseLong(materialCategoryId));
                    }
                    if (subContent.get(materialTypeId) != null) {
                        allMaterialTypeIds.add(Long.parseLong(subContent.getString(materialTypeId)));
                    }

                }
            }
        }
        map.put("materialTypeIds", materialTypeIds);
        map.put("materialIds", materialIds);
        map.put("allMaterialTypeIds", allMaterialTypeIds);
        return map;
    }

    private List<MaterialDataModelVO> getChildrenData(JSONObject param,
                                                      List<MaterialDataModelVO> materialDataModelVOs) {
        logger.info("数据模型处理返回数据：param:{}", param);
        logger.info("materialDataModelVOs:{}", JSONObject.toJSONString(materialDataModelVOs));
        List<MaterialDataModelVO> list = new ArrayList<>();
        Long projectId = param.getLong("projectId");
        String materialTypeId = "materialTypeId";
        String materialTypeName = "materialTypeName";
        String space = "space";
        String unit = "unit";
        String billTypeCode = (String) param.get("billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get("bill");
        JSONObject content = new JSONObject((HashMap) bill);
        Map<Long, MaterialDataModelVO> materialMap =
                materialDataModelVOs.stream().filter(s -> s.getMaterialId() != null).collect(Collectors
                        .toMap(MaterialDataModelVO::getMaterialId, Function.identity(),(key1, key2) -> key2));
        logger.info("根据materialId组装map结果:materialMap:{}", JSONObject.toJSONString(materialMap));
        Map<Long, MaterialDataModelVO> materialTypeMap =
                materialDataModelVOs.stream().filter(s -> s.getMaterialId() == null)
                        .collect(Collectors.toMap(MaterialDataModelVO::getMaterialTypeId, Function.identity(),
                                (key1, key2) -> key2));
        logger.info("根据materialTypeId组装map结果:materialTypeMap:{}", JSONObject.toJSONString(materialTypeMap));
        if (content.get(subTableName) != null) {
            JSONArray jsonArray = content.getJSONArray(subTableName);
            if (jsonArray != null) {
                if (DataModelEnum.物资总计划.getCode().equals(billTypeCode) || DataModelEnum.物资总计划变更.getCode()
                        .equals(billTypeCode) || DataModelEnum.收料入库单.getCode().equals(billTypeCode) ||
                        DataModelEnum.直入直出单.getCode().equals(billTypeCode)) {
                    materialTypeName = "materialCategoryName";
                    materialTypeId = "materialCategoryId";
                }
                if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode) || DataModelEnum.物资采购合同变更.getCode()
                        .equals(billTypeCode)) {
                    unit = "measureUnit";
                }
                if(DataModelEnum.收料入库单.getCode().equals(billTypeCode) || DataModelEnum.直入直出单.getCode().equals(billTypeCode)){
                    unit = "materialUnit";
                    space = "materialSpec";
                }
                if(DataModelEnum.物资合同结算单.getCode().equals(billTypeCode) || DataModelEnum.物资总计划变更.getCode().equals(billTypeCode)||
                    DataModelEnum.项目用料申请.getCode().equals(billTypeCode)){
                    space = "model";
                }
                for (Object o : jsonArray) {
                    JSONObject subContent = new JSONObject((HashMap) o);
                    MaterialDataModelVO materialDataModelVO = new MaterialDataModelVO();
                    long materialType = Long.parseLong(subContent.get(materialTypeId).toString());
                    long materialId = Long.parseLong(subContent.get("materialId") != null ? subContent.get("materialId")
                            .toString() : Long.toString(0));
                    logger.info("循环处理，materialId:{},materialTypeId:{}", materialId, materialType);
                    if (materialMap.containsKey(materialId)) {
                        materialDataModelVO = materialMap.get(materialId);
                        if (BigDecimal.ZERO.compareTo(materialDataModelVO.getContractNum()) == 0) {
                            MaterialDataModelVO typeModel = materialTypeMap.get(materialType);
                            logger.info("根据材料查询合同量为0，取分类量：{}", JSONObject.toJSONString(typeModel));
                            materialDataModelVO.setContractNum(typeModel == null ? BigDecimal.ZERO : typeModel.getContractNum());
                        }
                        logger.info("从materialMap中取值，此时materialDataModelVO={}", JSONObject.toJSONString(materialDataModelVO));
                    }
                    if (materialTypeMap.containsKey(materialType)) {
                        materialDataModelVO = materialTypeMap.get(materialType);
                        logger.info("从materialTypeMap中取值，此时materialDataModelVO={}", JSONObject.toJSONString(materialDataModelVO));
                    }
                    if (!materialTypeMap.containsKey(materialType) && !materialMap.containsKey(materialId)) {
                        materialDataModelVO.setProjectId(projectId);
                        materialDataModelVO
                                .setProjectName(content.get("projectName") != null ? content.get("projectName")
                                        .toString() : "");
                        materialDataModelVO.setMaterialTypeId(materialType);
                        materialDataModelVO.setMaterialTypeName(subContent.get(materialTypeName).toString());
                        materialDataModelVO
                                .setMaterialName(subContent.get("materialName") != null ? subContent.get("materialName")
                                        .toString() : "");
                        if (subContent.get("materialId") != null) {
                            materialDataModelVO.setMaterialId(Long.parseLong(subContent.get("materialId").toString()));
                        }
                        //materialDataModelVO.setSpec(subContent.get("spec") != null ? subContent.get("spec").toString() : "");
                        String unitName = subContent.get(unit) != null ? subContent.get(unit).toString() : "";
                        String spaceName = subContent.get(space) != null ? subContent.get(space).toString() : "";
                        materialDataModelVO.setUnitName(unitName);
                        materialDataModelVO.setSpec(spaceName);
                        materialDataModelVO.setContractNum(BigDecimal.ZERO);
                        materialDataModelVO.setContractNumAll(BigDecimal.ZERO);
                        materialDataModelVO.setBudgetNum(BigDecimal.ZERO);
                        materialDataModelVO.setPlanNum(BigDecimal.ZERO);
                        materialDataModelVO.setApplyNum(BigDecimal.ZERO);
                        materialDataModelVO.setApplyNumAll(BigDecimal.ZERO);
                        materialDataModelVO.setInstoreNum(BigDecimal.ZERO);
                        materialDataModelVO.setInstoreNumAll(BigDecimal.ZERO);
                        materialDataModelVO.setSettlementNum(BigDecimal.ZERO);
                        logger.info("从其他中取值，此时materialDataModelVO={}", JSONObject.toJSONString(materialDataModelVO));
                    }
                    list.add(materialDataModelVO);
                }
            }
        }
        logger.info("数据模型处理返回数据,最后组装结果:{}", JSONObject.toJSONString(list));
        return list;
    }

    /**
     * 单据是否有可能选择大类
     *
     * @param billTypeCode 单据编码
     * @return true 有可能选择大类
     */
    private boolean isMaterialTypeFlag(String billTypeCode) {
        if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode)
                || DataModelEnum.物资采购合同变更.getCode().equals(billTypeCode)
                || DataModelEnum.物资总计划.getCode().equals(billTypeCode)
                || DataModelEnum.物资总计划变更.getCode().equals(billTypeCode)) {
            return true;
        }
        return false;
    }
}
