package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料实量登记
 *
 * @author generator
 *
 */
@TableName("ejc_material_measure_check")
public class MeasureCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "bill_date")
    private Date billDate; // 单据日期
    @TableField(value = "bill_code")
    private String billCode; // 申请单号
    @TableField(value = "org_id")
    private Long orgId; // 所属项目部
    @TableField(value = "org_name")
    private String orgName; // 所属项目部名称
    @TableField(value = "project_id")
    private Long projectId; // 项目名称参照
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 劳务队伍
    @TableField(value = "supplier_name")
    private String supplierName; // 劳务队伍
    @TableField(value = "part_name")
    private String partName; // 工程部位
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "dept_id")
    private Long deptId; // 部门
    @TableField(value = "dept_name")
    private String deptName; // 部门
    @TableField(value = "remark")
    private String remark; // 备注


    @TableField(exist = false)
    @SubEntity(serviceName = "measureCheckDetailService", pidName = "measureCheckId")
    private List<MeasureCheckDetailEntity> measureCheckDetailList = new ArrayList<>(); // 材料实量登记明细


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    public List<MeasureCheckDetailEntity> getMeasureCheckDetailList() {
        return measureCheckDetailList;
    }

    public void setMeasureCheckDetailList(List<MeasureCheckDetailEntity> measureCheckDetailList) {
        this.measureCheckDetailList = measureCheckDetailList;
    }
}
