package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/12  出库子表
 * @Description OutStoreSubEntity
 */

@TableName("ejc_material_out_store_sub")
public class OutStoreSubEntity extends BaseEntity {

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 仓库id
     */
    @TableField(value = "store_id")
    private Long storeId;

    /**
     * 出库物资占用库存状态，根据主表billState状态判断
     * 已提交和已通过的，状态为扣减库存态：1
     * 新增和审批中的均为库存占用态：0
     * 参见com.ejianc.business.material.pub.MaterialStoreState.java
     */
    @TableField(value = "store_state")
    private Integer storeState;

    /**
     * 出库类型,参见
     * com.ejianc.business.material.pub.MaterialStoreType.java 出库类型
     */
    @TableField(value = "store_type")
    private Integer storeType;


    /**
     * 出库日期
     */
    @TableField(value = "out_date")
    private Date outDate;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_category_name")
    private String materialCategoryName;

    /**
     * 物资分类id
     */
    @TableField(value = "material_category_id")
    private Long materialCategoryId;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 规格型号
     */
    @TableField(value = "material_spec")
    private String materialSpec;

    /**
     * 计量单位
     */
    @TableField(value = "material_unit")
    private String materialUnit;

    /**
     * 出库数量
     */
    @TableField(value = "out_store_number")
    private BigDecimal outStoreNumber;

    /**
     * 单价
     */
    @TableField(value = "unit_price")
    private BigDecimal unitPrice;
    @TableField(value="section_id")
    private Long sectionId; // 标段id
    @TableField(value="section_name")
    private String sectionName; // 标段名称
    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 品牌
     */
    @TableField(value = "material_supplier_name")
    private String materialSupplierName;
    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 数据来源主表入库单id
     */
    @TableField(value = "source_main_id")
    private Long sourceMainId;

    /**
     * 数据来源出库单子表id
     */
    @TableField(value = "source_sub_id")
    private Long sourceSubId;

    /**
     * 退货金额差
     */
    @TableField(value = "money_disparity")
    private BigDecimal moneyDisparity;

    /**
     * 入库单价
     */
    @TableField(value = "in_store_price")
    private BigDecimal inStorePrice;

    /**
     * 入库金额
     */
    @TableField(value = "in_store_money")
    private BigDecimal inStoreMoney;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField(value = "subject_name")
    private String subjectName;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

    /**
     * 盘亏单id
     */
    @TableField(value = "check_main_id")
    private Long checkMainId;

    /**
     * 盘亏单子表id
     */
    @TableField(value = "check_sub_id")
    private Long checkSubId;

    @TableField(value = "part_id")
    private Long partId;
    @TableField(value = "part_name")
    private String partName;
    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getCheckMainId() {
        return checkMainId;
    }

    public void setCheckMainId(Long checkMainId) {
        this.checkMainId = checkMainId;
    }

    public Long getCheckSubId() {
        return checkSubId;
    }

    public void setCheckSubId(Long checkSubId) {
        this.checkSubId = checkSubId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Integer getStoreState() {
        return storeState;
    }

    public void setStoreState(Integer storeState) {
        this.storeState = storeState;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public String getMaterialSupplierName() {
        return materialSupplierName;
    }

    public void setMaterialSupplierName(String materialSupplierName) {
        this.materialSupplierName = materialSupplierName;
    }

    public Long getSectionId() {
        return sectionId;
    }

    public void setSectionId(Long sectionId) {
        this.sectionId = sectionId;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }

    public BigDecimal getOutStoreNumber() {
        return outStoreNumber;
    }

    public void setOutStoreNumber(BigDecimal outStoreNumber) {
        this.outStoreNumber = outStoreNumber;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public Long getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(Long sourceSubId) {
        this.sourceSubId = sourceSubId;
    }

    public BigDecimal getMoneyDisparity() {
        return moneyDisparity;
    }

    public void setMoneyDisparity(BigDecimal moneyDisparity) {
        this.moneyDisparity = moneyDisparity;
    }

    public BigDecimal getInStorePrice() {
        return inStorePrice;
    }

    public void setInStorePrice(BigDecimal inStorePrice) {
        this.inStorePrice = inStorePrice;
    }

    public BigDecimal getInStoreMoney() {
        return inStoreMoney;
    }

    public void setInStoreMoney(BigDecimal inStoreMoney) {
        this.inStoreMoney = inStoreMoney;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getPartId() {
        return partId;
    }

    public void setPartId(Long partId) {
        this.partId = partId;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }
}
