package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.service.IStoreTopService;
import com.ejianc.business.material.vo.ConstructionStoreVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/storeTop/")
public class StoreTopContract {
    @Autowired
    private IStoreTopService storageTopService;

    /**
     * 消耗材top10物料价格趋势
     * 入参：
     *      orgId：项目id
     *      dateIn：
     *      projectStatus：
     *      materialId：物资id
     *
     * @param constructionStoreVo
     * @return
     * JSONObject{
     *      materialTop10：
     *      projectTop5
     *      storeTopCompany
     *
     *  }
     */
    @RequestMapping(value = "constructionStoreTop", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> constructionStoreTop(@RequestBody ConstructionStoreVo constructionStoreVo) {
        return storageTopService.storeTop(constructionStoreVo);
    }

    /**
     * 在建项目物资消耗实况
     * @param constructionStoreVo
     * @return
     */
    @RequestMapping(value = "storeData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> storeData(@RequestBody ConstructionStoreVo constructionStoreVo) {
        return storageTopService.storeData(constructionStoreVo);
    }

}
