package com.ejianc.business.material.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.vo.MaterialCostVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

public interface IStatisticsService {
    IPage<JSONObject> queryInStoreDetailsPageList(QueryParam param);

    IPage<JSONObject> queryOutStoreDetailsPageList(QueryParam param);

    IPage<JSONObject> queryInOutStorePageList(QueryParam param);
    IPage<JSONObject> queryInOutStoreMaterialList(QueryParam param);


    IPage<JSONObject> queryPlanInOutStorePageList(QueryParam param);
    JSONObject queryPlanInOutStorePageListSum(QueryParam param);
    /**
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目查询物资看板
     * @Description queryMaterialViewBoardByProjectId
     * @Param [projectId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    CommonResponse<JSONObject> queryMaterialViewBoardByProjectId(Long projectId);

    CommonResponse<MaterialCostVO> queryMaterialCostByProjectId(Long projectId);
}
