package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IUseApplyService extends IBaseService<UseApplyEntity> {

    IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs);

    ParamsCheckVO checkAllParams(UseApplyVO vo);

    CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo);

    /**
     * @param queryParam
     * @description: 查询项目用料, 物资已完成状态, 施工计划 使用
     * 世纪阳光专业分包模式使用
     * @return: java.util.List<com.ejianc.business.material.vo.UseApplySubVO>
     * @author songlx
     * @date: 2021/9/28
     */
    List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam);

    /**
     * 根据项目 物资 统计总计划量
     * @param projectId
     * @param materialIds
     * @return
     */
    List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds);

    /**
     * @description: 查询用料申请参照合计版
     *
     * @param pageData
     * @param queryParam
     * @param projectId
     * @return {@link java.util.List<com.ejianc.business.material.bean.UseApplySubEntity>}
     * @author songlx
     * @date: 2022/11/29
     */
    List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId);

    List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam);

    List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId);

    List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam);

    List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam);

    List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId);

    void updatePurchaseFlag(Long id, Integer purchaseFlag);
}
