package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class OutStoreService extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-72Q53Y26";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;

    // 劳务队伍领料限额量控制材料出库量
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";

    @Autowired
    private IPickRegisterService pickRegisterService;


    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<OutStoreVO> voPage = null;
        IPage<OutStoreEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0; i < entity.getOutStoreSubEntities().size(); i++) {
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = sub.getTaxRate() == null ? (new BigDecimal("1.00")) : new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getOutDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode(entity.getStoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode(entity.getStoreType()) + "_DETAIL");

                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate outDate = entity.getOutDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                c.setPeriod(outDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                c.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                c.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                if (Objects.equals(MaterialStoreType.PICKING_OUT_STORE.getCode(), sub.getStoreType())) {
                    c.setSourceBillName(MaterialStoreType.PICKING_OUT_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickingOut/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                c.setNum(sub.getOutStoreNumber() == null ? BigDecimal.ZERO : sub.getOutStoreNumber()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                c.setMaterialId(sub.getMaterialId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                c.setMaterialName(sub.getMaterialName()); // 物资名称
                c.setMaterialTypeId(sub.getMaterialCategoryId()); // 物资类别
                c.setMaterialTypeName(sub.getMaterialCategoryName()); // 物资类别名称
                c.setUnit(sub.getMaterialUnit()); // 单位名称
                // c.setUnitId(); // 单位主键
                c.setSpec(sub.getMaterialSpec()); // 规格型号

                list.add(c);
            }
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本" + MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType()) + "结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
            // if(canPush){
            //     CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            //     logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("1");
            // }else {
            //     CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            //     logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("0");
            // }
        } else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    /**
     * @param topN
     * @param type
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.beginOfYear(new Date()));
        startDate = "'" + startDate + "'";
//        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCostTopN(topN,type,startDate,orgIds);
        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        List<JSONObject> result = new ArrayList<>();
        logger.info("查询物资开累年累消耗top n outStoreSubEntities 数量：" + (ListUtil.isNotEmpty(outStoreSubEntities) ? outStoreSubEntities.size() : "空") + " 当前orgId：" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
//                object.put("materialName",en.getMaterialName());
//                object.put("materialSpec",en.getMaterialSpec());
//                object.put("materialUnit",en.getMaterialUnit());
                object.put("materialCategoryName", en.getMaterialCategoryName());
                object.put("outStoreNumber", en.getOutStoreNumber());
                object.put("amount", en.getAmount());
                object.put("weight", ComputeUtil.safeMultiply(en.getUnitPrice(), new BigDecimal("100")).setScale(0, BigDecimal.ROUND_HALF_UP) + "%");
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);

        List<MaterialPriceVO> detailList = vo.getDetail();
        Integer instoreType = vo.getInstoreType();
        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            //当前表单同类物资合计
            Map<Long, MaterialPriceVO> thisMap = new HashMap<>();
            detailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    MaterialPriceVO materialPriceVO = thisMap.get(item.getMaterialId());
                    materialPriceVO.setNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(materialPriceVO.getNum(), item.getNum())));
                } else {
                    thisMap.put(item.getMaterialId(), item);
                }
            });

            List<Long> materialIds = new ArrayList<>(thisMap.keySet());
            Long projectId = vo.getProjectId();
            Long supplierId = vo.getLabourArmyId();
            // 领料出库
            if (instoreType != null && instoreType.intValue() == 5 && supplierId != null) {
                // 劳务队伍领料限额量控制材料出库量
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("劳务队伍领料限额量控制材料出库量，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    // 根据项目和劳务队获取限量登记
                    Map<Long, BigDecimal> planMap = pickRegisterService.queryLaborLimitMaterialCount(projectId, supplierId, materialIds);

                    //获取已生效的量
                    List<MaterialPriceVO> vos = baseMapper.queryLaborMaterialCount(vo.getId(), projectId, supplierId, materialIds);
                    Map<Long, BigDecimal> numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap<>() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            thisMap.forEach((k, d) -> {
                                BigDecimal num = d.getNum();
                                BigDecimal applyNum = ComputeUtil.nullToZero(planMap.get(d.getMaterialId()));
                                BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                                BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                //百分比数量
                                BigDecimal _applyNum = applyNum.multiply(divide);
                                if (allNum.compareTo(_applyNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "outStoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("劳务队伍领料出库量大于领料限额量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该材料本次出库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，含本次累计出库数量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，领料限额数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            });
                        }
                    }
                }
            }

        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper,
                                                          Long projectId, Long supplierId) {
        return baseMapper.queryPickDeductList(page, wrapper, projectId, supplierId);
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        check.getParams().put("bill_code", new Parameter(QueryParam.EQ, code));
        check.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OutStoreEntity> entityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(entityList)) {
            return false;
        }
        return true;
    }

    @Override
    public List<MaterialPriceVO> queryLaborMaterialCount(Long id, Long projectId, Long supplierId, List<Long> materialIds) {
        return baseMapper.queryLaborMaterialCount(id, projectId, supplierId, materialIds);
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> queryMaterialNumTopN(Integer topN, List<Long> orgIdList, List<Long> sectionIds) {
        List<Map<String, Object>> outStoreSubEntities = outStoreSubMapper.queryMaterialNumTopN(topN, orgIdList, sectionIds);
        return CommonResponse.success(outStoreSubEntities);
    }
}
