package com.ejianc.business.plan.controller;

import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/9 20:24
 */
@RestController
@RequestMapping(value = "/planChangeHis/")
public class PlanChangeHisController {

    @Autowired
    private IPlanChangeHisService planChangeHisService;

    @GetMapping("queryDetail")
    public CommonResponse<PlanChangeHisVO> queryDetail(@RequestParam(value = "id") Long id) {
        PlanChangeHisVO vo = null;
        PlanChangeHisEntity dbEntity = planChangeHisService.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, PlanChangeHisVO.class);
        }

        return CommonResponse.success("查询物资总计划变更详情成功！", vo);
    }

}
