package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.SectionPlanChangeHisEntity;
import com.ejianc.business.plan.bean.SectionPlanEntity;
import com.ejianc.business.plan.bean.SectionPlanSubEntity;
import com.ejianc.business.plan.service.ISectionPlanChangeHisService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.business.plan.service.ISectionPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.SectionPlanChangeHisVO;
import com.ejianc.business.plan.vo.SectionPlanSubVO;
import com.ejianc.business.plan.vo.SectionPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标段计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sectionPlan")
public class SectionPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISectionPlanChangeHisService planChangeHisService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SECTION_PLAN_CODE";

    @Autowired
    private ISectionPlanService service;

    @Autowired
    private ISectionPlanSubService planSubService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ArchivesUtil archivesUtil;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SectionPlanVO> saveOrUpdate(@RequestBody SectionPlanVO sectionPlanVO) {
        //校验项目是否已有总计划
        LambdaQueryWrapper<SectionPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SectionPlanEntity::getProjectId, sectionPlanVO.getProjectId());
        queryWrapper.eq(SectionPlanEntity::getSectionId, sectionPlanVO.getSectionId());
        queryWrapper.ne(sectionPlanVO.getId() != null, SectionPlanEntity::getId, sectionPlanVO.getId());
        int c = service.count(queryWrapper);
        if (c > 0) {
            return CommonResponse.error("该项目在该标段已存在计划！");
        }

        String planCode = sectionPlanVO.getPlanCode();
        if (StringUtils.isNotBlank(planCode)) {
            //编码重复校验
            QueryWrapper<SectionPlanEntity> query = new QueryWrapper<>();
            query.eq("plan_code", planCode);
            query.eq("tenant_id", InvocationInfoProxy.getTenantid());
            query.ne(sectionPlanVO.getId() != null, "id", sectionPlanVO.getId());
            int count = service.count(query);
            if (count > 0) {
                return CommonResponse.error("保存失败，编码重复！");
            }
        } else {
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            sectionPlanVO.setPlanCode(codeResp.getData());
        }

        UserContext userContext = sessionManager.getUserContext();
        SectionPlanEntity saveEntity = null;
        if (null == sectionPlanVO.getId()) {
            saveEntity = BeanMapper.map(sectionPlanVO, SectionPlanEntity.class);
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
        } else {
            saveEntity = service.getById(sectionPlanVO.getId());
            saveEntity.setProjectId(sectionPlanVO.getProjectId());
            saveEntity.setProjectName(sectionPlanVO.getProjectName());
            saveEntity.setOrgId(sectionPlanVO.getOrgId());
            saveEntity.setOrgName(sectionPlanVO.getOrgName());
            saveEntity.setRemark(sectionPlanVO.getRemark());
            saveEntity.setPlanCode(sectionPlanVO.getPlanCode());
            saveEntity.setTotalPlanAmt(sectionPlanVO.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());

            saveEntity.setMaterialSubList(BeanMapper.mapList(sectionPlanVO.getMaterialSubList(), SectionPlanSubEntity.class));
        }

        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        List<SectionPlanSubVO> materialSubList = sectionPlanVO.getMaterialSubList();
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            for (SectionPlanSubVO materialMasterPlanSubVO : materialSubList) {
                String onlykey = materialMasterPlanSubVO.getMaterialCategoryName() + materialMasterPlanSubVO.getMaterialName() + materialMasterPlanSubVO.getUnit() + materialMasterPlanSubVO.getSpec() + materialMasterPlanSubVO.getMaterialCode();
                materialMasterPlanSubVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = archivesUtil.batchSaveArchive(materialSubList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<SectionPlanSubVO> list = JSONObject.parseArray(sourceList, SectionPlanSubVO.class);
            List<SectionPlanSubEntity> materialMasterPlanSubEntities = BeanMapper.mapList(list, SectionPlanSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }

        service.saveOrUpdateNoES(saveEntity);
        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, SectionPlanVO.class));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SectionPlanVO> queryDetail(Long id) {
        SectionPlanVO vo = null;
        SectionPlanEntity entity = service.selectById(id);
        if (null != entity) {
            vo = BeanMapper.map(entity, SectionPlanVO.class);
            if (MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED == vo.getChangeState()) {
                List<SectionPlanChangeHisVO> changeHisList = loadChangeHisList(vo.getId());
                vo.setPlanChangeHisList(changeHisList);
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    private List<SectionPlanChangeHisVO> loadChangeHisList(Long planId) {
        List<SectionPlanChangeHisVO> resp = new ArrayList<>();
        QueryWrapper<SectionPlanChangeHisEntity> hisQuery = new QueryWrapper<>();
        hisQuery.eq("source_plan_id", planId);
        hisQuery.orderByDesc("create_time");
        List<SectionPlanChangeHisEntity> list = planChangeHisService.list(hisQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SectionPlanChangeHisVO.class);
        }
        return resp;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SectionPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SectionPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SectionPlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SectionPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("planCode");
        fuzzyFields.add("createUserName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SectionPlanEntity> page = service.queryPage(param, false);
        IPage<SectionPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SectionPlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("planCode");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SectionPlanEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("SectionPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSectionPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SectionPlanVO>> refSectionPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SectionPlanEntity> page = service.queryPage(param, false);
        IPage<SectionPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SectionPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /***
     * @description: 参数校验
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody SectionPlanVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                               @RequestParam String condition
    ) {
        if (StringUtils.isEmpty(condition) || !condition.contains("projectId")) {
            throw new BusinessException("查询参数不正确！请传入projectId");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");

        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));

        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<SectionPlanEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (SectionPlanEntity entity : dataList) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getPlanCode() + "标段计划-" + entity.getSectionName());
            map.put("code", entity.getPlanCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }


    @RequestMapping(value = "/refSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SectionPlanSubVO>> refdata(@RequestParam Integer pageNumber,
                                                           @RequestParam Integer pageSize,
                                                           String relyCondition,
                                                           @RequestParam(required = false) String condition,
                                                           String relyNode,
                                                           String searchText,
                                                           @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        Map<String, Parameter> param = queryParam.getParams();
        Boolean queryAllFlag = Boolean.FALSE;
        if (!StringUtils.isEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("materialMasterPlanId", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }

        HashMap<Long, SectionPlanEntity> planMap = new HashMap<>();
        if (queryAllFlag) {
            if (StringUtils.isEmpty(condition) || !condition.contains("projectId")) {
                throw new BusinessException("查询参数不正确！请传入projectId");
            }
            JSONObject conditionJson = JSONObject.parseObject(condition);
            Long projectId = conditionJson.getLong("projectId");
            LambdaQueryWrapper<SectionPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SectionPlanEntity::getProjectId, projectId);
            queryWrapper.in(SectionPlanEntity::getBillState,  Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            List<SectionPlanEntity> list = service.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)){
                List<Long> ids = new ArrayList<>();
                for (SectionPlanEntity sectionPlanEntity : list) {
                    planMap.put(sectionPlanEntity.getId(), sectionPlanEntity);
                    ids.add(sectionPlanEntity.getId());
                }
                param.put("materialMasterPlanId", new Parameter(QueryParam.IN, ids));
            } else {
                param.put("materialMasterPlanId", new Parameter(QueryParam.EQ, 1L));
            }
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }
        IPage<SectionPlanSubVO> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<SectionPlanSubVO> list = planSubService.queryPageSubList(pageData, queryParam);;
        pageData.setRecords(list);
        return CommonResponse.success("查询数表参照成功", pageData);
    }
}
