package com.ejianc.business.plan.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:11
 */
public interface IMaterialMasterPlanSubService extends IBaseService<MaterialMasterPlanSubEntity> {
    /**
     * 根据Id删除列表数据
     *
     * @param delDetailIds 总计划物料Id列表
     * @param planId 总计划Id
     */
    void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId);

    /**
     * 分页查询总计划明细，供参照使用
     * @param page
     * @param wrapper
     * @return
     */
    List<MaterialMasterPlanSubVO> queryPlanSubList(IPage<MaterialMasterPlanSubVO> page, QueryWrapper wrapper);
}
