package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:10
 */
@Service(value = "materialMasterPlanService")
public class MaterialMasterPlanServiceImpl extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity> implements IMaterialMasterPlanService {

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;

    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741"; // 【预算材料费总金额】 控 【物资总计划金额】
    private static final String PARAM_NUM = "P-uFOcn644"; // 预算材料清单量控
    private static final String PARAM_TAX_MNY = "P-14dTg745"; // 预算材料清单金额控
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if (null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        //更新子表信息
        if (null != saveEntity.getId()) {
            materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate(saveEntity, false);
        return saveEntity;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    /**
     * 参数控制
     *
     * @param vo 物资总计划vo
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        // 【预算材料费总金额】 控 【物资总计划金额】
        // 预算材料费总金额
        BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
        paramControlVO.setProjectId(vo.getProjectId());
        paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
        if (!res.isSuccess()) {
            throw new BusinessException("预算材料费总金额，查询项目预算信息失败，失败原因：" + res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO = res.getData();
            BigDecimal budgetTaxMny = proQuantityAndMnyVO.getMaterialTaxMny() == null ? BigDecimal.ZERO : proQuantityAndMnyVO.getMaterialTaxMny();

            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【预算材料费总金额】 控 【物资总计划金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);

                        // 一个项目只能有一个总计划，所以历史累计物资总计划金额为0
                        BigDecimal lastTotalPlanAmt = BigDecimal.ZERO;

                        // 本期物资总计划金额
                        BigDecimal totalPlanAmt = vo.getTotalPlanAmt() == null ? BigDecimal.ZERO : vo.getTotalPlanAmt();
                        // 物资总计划金额 = 历史累计物资总计划金额 + 本期物资总计划金额
                        BigDecimal planAmt = totalPlanAmt.add(lastTotalPlanAmt);

                        // 物资总计划金额 和 预算材料费总金额比较
                        if (planAmt.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 物资总计划金额 - 预算材料费总金额 * X%
                            BigDecimal over = planAmt.subtract(budgetTaxMnyResult);

                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(vo.getPlanId(), "totalPlanAmt");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("物资总计划金额超预算材料费总金额");
                            paramsCheckDsVO.setWarnName("物资总计划金额大于预算材料费总金额 * " + roleValue + "%");

                            // 物资总计划金额：XX元，预算材料费总金额 * X%：XX元，超出金额：XX元。
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目物资总计划金额：")
                                    .append(planAmt.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算材料费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        // 预算材料清单量控、预算材料清单金额控
        List<PlanControlSubVO> materialSubList = vo.getPlanControlSubVOList();
        // 物资总计划没有物资明细，不控制直接返回
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            // 没有预算清单不控制
            List<Long> subIds = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
            // 预算材料清单量
            BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
            paramControlVO1.setProjectId(vo.getProjectId());
            paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
            paramControlVO1.setIds(subIds);
            CommonResponse<BudgetProjectProQuantityAndMnyVO> res1 = budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
            if (!res1.isSuccess()) {
                throw new BusinessException("预算材料清单量，查询项目预算信息失败，失败原因：" + res1.getMsg());
            }
            if (null != res1.getData()) {
                BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO = res1.getData();
                Map<Long, BudgetProjectDetailProVO> detailProMap = proQuantityAndMnyVO.getDetailProMap();
                if (!detailProMap.isEmpty()) {
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("预算材料清单量控，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();

                    // 控制参数不为空才控制
                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        // 本期物资总计划材料清单量
                        Map<Long, PlanControlSubVO> currentSubMap = new HashMap<>();
                        for (PlanControlSubVO masterPlanSubVO : materialSubList) {
                            if (currentSubMap.containsKey(masterPlanSubVO.getMaterialId())) {
                                PlanControlSubVO materialMasterPlanSubVO = currentSubMap.get(masterPlanSubVO.getMaterialId());
                                materialMasterPlanSubVO.setNum(Double.sum(materialMasterPlanSubVO.getNum(), masterPlanSubVO.getNum()));
                            } else {
                                currentSubMap.put(masterPlanSubVO.getMaterialId(), masterPlanSubVO);
                            }
                        }

                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal num = detailProVO.getNum() == null ? BigDecimal.ZERO : detailProVO.getNum();
                                    budgetProjectDetailProVO.setNum(num.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, PlanControlSubVO> entry : currentSubMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    PlanControlSubVO planSubVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 物资总计划工程量 和 预算材料工程量
                                        BigDecimal cNum = BigDecimal.valueOf(planSubVO.getNum());
                                        BigDecimal dNum = detailProVO.getNum();
                                        if (cNum.compareTo(dNum) > 0) {
                                            // 超出量 = 物资总计划材料清单量 - 预算材料清单量 * X%
                                            BigDecimal over = cNum.subtract(dNum);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "num");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(planSubVO.getMaterialName() + "-" + planSubVO.getUnit() + "-" + planSubVO.getSpec());
                                            paramsCheckDsVO.setWarnName("物资总计划材料清单量大于预算材料清单量 * " + roleValue + "%");

                                            // 档案累计数量：XX，预算材料清单量 * X%：XX，超出量：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("档案累计数量：")
                                                    .append(cNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单量 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出量：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId);
                    if (!response1.isSuccess()) {
                        throw new BusinessException("预算材料清单金额控，获取控制参数失败，失败原因：" + response1.getMsg());
                    }
                    List<BillParamVO> billParamVOS1 = response1.getData();

                    // 控制参数不为空才控制
                    if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                        // 本期物资总计划材料清单量
                        Map<Long, PlanControlSubVO> currentSubMap = new HashMap<>();
                        for (PlanControlSubVO masterPlanSubVO : materialSubList) {
                            if (currentSubMap.containsKey(masterPlanSubVO.getMaterialId())) {
                                PlanControlSubVO materialMasterPlanSubVO = currentSubMap.get(masterPlanSubVO.getMaterialId());
                                materialMasterPlanSubVO.setAmount(materialMasterPlanSubVO.getAmount().add(masterPlanSubVO.getAmount()));
                            } else {
                                currentSubMap.put(masterPlanSubVO.getMaterialId(), masterPlanSubVO);
                            }
                        }

                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                                    budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, PlanControlSubVO> entry : currentSubMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    PlanControlSubVO planSubVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 物资总计划材料清单金额 和 预算材料清单金额
                                        BigDecimal cAmount = planSubVO.getAmount();
                                        BigDecimal dMaterialTaxMnyCost = detailProVO.getMaterialTaxMnyCost();
                                        if (cAmount.compareTo(dMaterialTaxMnyCost) > 0) {
                                            // 超出量 = 物资总计划材料清单金额 - 预算材料清单金额 * X%
                                            BigDecimal over = cAmount.subtract(dMaterialTaxMnyCost);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "amount");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(planSubVO.getMaterialName() + "-" + planSubVO.getUnit() + "-" + planSubVO.getSpec());
                                            paramsCheckDsVO.setWarnName("物资总计划材料清单金额大于预算材料清单金额 * " + roleValue + "%");

                                            // 档案累计金额：XX，预算材料清单金额 * X%：XX，超出金额：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append(" 档案累计金额：")
                                                    .append(cAmount.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单金额 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出金额：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

}
