package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PlanChangeThread implements Runnable {

    private Logger logger;

    private Long billId;

    private Integer state;

    private IPlanChangeService planChangeService;

    private IPlanChangeSubService planChangeSubService;

    private IPlanChangeHisService planChangeHisService;

    private IMaterialMasterPlanService materialMasterPlanService;

    private IMaterialMasterPlanSubService materialMasterPlanSubService;

    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setPlanChangeService(IPlanChangeService planChangeService) {
        this.planChangeService = planChangeService;
    }

    public void setPlanChangeSubService(IPlanChangeSubService planChangeSubService) {
        this.planChangeSubService = planChangeSubService;
    }

    public void setPlanChangeHisService(IPlanChangeHisService planChangeHisService) {
        this.planChangeHisService = planChangeHisService;
    }

    public void setMaterialMasterPlanService(IMaterialMasterPlanService materialMasterPlanService) {
        this.materialMasterPlanService = materialMasterPlanService;
    }

    public void setMaterialMasterPlanSubService(IMaterialMasterPlanSubService materialMasterPlanSubService) {
        this.materialMasterPlanSubService = materialMasterPlanSubService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            doSomething();
        }catch (Exception e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw,true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
    }

    public void doSomething(){
        logger.info("线程开始----------------");
        //PlanChangeEntity planChange = planChangeService.selectById(billId);
        PlanChangeEntity planChange = planChangeService.getById(billId);
        QueryWrapper<PlanChangeSubEntity> qw = new QueryWrapper<>();
        qw.eq("material_master_plan_id",planChange.getId());
        qw.eq("dr",0);
        planChange.setMaterialSubList(planChangeSubService.list(qw));

        MaterialMasterPlanEntity newPlanEntity = null;
        //MaterialMasterPlanEntity oldPlan = materialMasterPlanService.selectById(planChange.getSourcePlanId());
        MaterialMasterPlanEntity oldPlan = materialMasterPlanService.getById(planChange.getSourcePlanId());
        QueryWrapper<MaterialMasterPlanSubEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("material_master_plan_id",oldPlan.getId());
        wrapper.eq("dr",0);
        oldPlan.setMaterialSubList(materialMasterPlanSubService.list(wrapper));

        if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            //直审时记录
            //设置提交人信息
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userCode);
            planChange.setCommitUserName(userName);
        }
        //设置总计划变更单据生效时间
        planChange.setEffectiveDate(new Date());

        //1、复制合同信息到合同记录
        PlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, PlanChangeHisEntity.class);
        //logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));
        logger.info("总计划变更审批正在回调");

        //设置总计划Id
        recordEntity.setSourcePlanId(oldPlan.getId());
        //Id置为空
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getMaterialSubList())) {
            recordEntity.getMaterialSubList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }

        //设置编制人等信息
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());

        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(oldPlan.getCurChangingPlanId());

        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if(null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if(null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if(recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0d);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
        }

        //总计划变更记录保存
        planChangeHisService.saveOrUpdate(recordEntity, false);

        planChangeService.saveOrUpdate(planChange, false);

        //修改总计划字段
        newPlanEntity = BeanMapper.map(planChange, MaterialMasterPlanEntity.class);
        //变更状态-已变更
        newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED);

        //清空当前变更计划id
        newPlanEntity.setCurChangingPlanId(null);
        //合同初始创建信息
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        //单据状态不应该被变更单覆盖，因为总计划可能没有审批流是提交生态的，变更单是有审批流的
        newPlanEntity.setBillState(oldPlan.getBillState());

        //子表信息设置
        List<Long> delDetailIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
            List<MaterialMasterPlanSubEntity> list = new ArrayList<>();
            MaterialMasterPlanSubEntity tmp = null;
            Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(MaterialMasterPlanSubEntity::getId, MaterialMasterPlanSubEntity::getVersion));

            for(PlanChangeSubEntity detail : planChange.getMaterialSubList()) {
                tmp = BeanMapper.map(detail, MaterialMasterPlanSubEntity.class);
                if(null != detail.getTargetId()) {
                    tmp.setId(detail.getTargetId());
                    tmp.setVersion(map.get(detail.getTargetId()));
                    if(PlanChangeSubVO.CHANGE_TYPE_DEL.equals(detail.getChangeType())) {
                        //终止项删除
                        delDetailIds.add(detail.getTargetId());
                    } else {
                        tmp.setRowState("update");
                        list.add(tmp);
                    }
                } else {
                    tmp.setRowState("add");
                    list.add(tmp);
                }
            }

            newPlanEntity.setMaterialSubList(list);
        }

        //删除已有子表
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            materialMasterPlanSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
        }

        if(materialMasterPlanService.saveOrUpdate(newPlanEntity, false)) {
            logger.info("回调业务处理成功！");
        }else{
            logger.info("回调业务处理失败！");
        }
    }
}
