package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.SectionPlanChangeEntity;
import com.ejianc.business.plan.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("sectionPlanChange")
public class SectionPlanChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISectionPlanChangeService changeService;
    @Autowired
    private ISectionPlanChangeHisService changeHisService;
    @Autowired
    private ISectionPlanService planService;
    @Autowired
    private ISectionPlanSubService planSubService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //设置提交人信息
        UserContext userContext = sessionManager.getUserContext();
        LambdaUpdateWrapper<SectionPlanChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SectionPlanChangeEntity::getId, billId);
        updateWrapper.set(SectionPlanChangeEntity::getCommitDate, new Date());
        updateWrapper.set(SectionPlanChangeEntity::getCommitUserCode, userContext.getUserCode());
        updateWrapper.set(SectionPlanChangeEntity::getCommitUserCode, userContext.getUserName());
        changeService.update(updateWrapper);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }


    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }



    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("标段计划变更审批完成回调处理----------------：billId: {}, state: {}", billId, state);
        SectionPlanChangeThread myThread = new SectionPlanChangeThread();
        UserContext userContext = sessionManager.getUserContext();
        myThread.setBillId(billId);
        myThread.setState(state);
        myThread.setLogger(logger);
        myThread.setChangeService(changeService);
        myThread.setPlanService(planService);
        myThread.setPlanSubService(planSubService);
        myThread.setChangeHisService(changeHisService);
        myThread.setUserCode(userContext.getUserCode());
        myThread.setUserName(userContext.getUserName());
        Thread thread = new Thread(myThread);
        thread.start();
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("该单据不支持弃审！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
