package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SectionPlanChangeThread implements Runnable {

    private Logger logger;

    private Long billId;

    private Integer state;

    private ISectionPlanChangeService changeService;

    private ISectionPlanChangeHisService changeHisService;

    private ISectionPlanService planService;

    private ISectionPlanSubService planSubService;

    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setChangeService(ISectionPlanChangeService changeService) {
        this.changeService = changeService;
    }


    public void setChangeHisService(ISectionPlanChangeHisService changeHisService) {
        this.changeHisService = changeHisService;
    }

    public void setPlanService(ISectionPlanService planService) {
        this.planService = planService;
    }

    public void setPlanSubService(ISectionPlanSubService planSubService) {
        this.planSubService = planSubService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            doSomething();
        }catch (Exception e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw,true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
    }

    public void doSomething(){
        logger.info("线程开始----------------");
        SectionPlanChangeEntity planChange = changeService.selectById(billId);
        SectionPlanEntity newPlanEntity = null;
        SectionPlanEntity oldPlan = planService.selectById(planChange.getSourcePlanId());

        if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            //直审时记录
            //设置提交人信息
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userCode);
            planChange.setCommitUserName(userName);
        }
        //设置总计划变更单据生效时间
        planChange.setEffectiveDate(new Date());

        //1、复制合同信息到合同记录
        SectionPlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, SectionPlanChangeHisEntity.class);
        logger.info("总计划变更审批正在回调");

        //设置总计划Id
        recordEntity.setSourcePlanId(oldPlan.getId());
        //Id置为空
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getMaterialSubList())) {
            recordEntity.getMaterialSubList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }

        //设置编制人等信息
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());

        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(oldPlan.getCurChangingPlanId());

        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if(null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if(null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if(recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0d);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
        }

        //总计划变更记录保存
        changeHisService.saveOrUpdate(recordEntity, false);

        changeService.saveOrUpdate(planChange, false);

        //修改总计划字段
        newPlanEntity = BeanMapper.map(planChange, SectionPlanEntity.class);
        //变更状态-已变更
        newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED);

        //清空当前变更计划id
        newPlanEntity.setCurChangingPlanId(null);
        //合同初始创建信息
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        //单据状态不应该被变更单覆盖，因为总计划可能没有审批流是提交生态的，变更单是有审批流的
        newPlanEntity.setBillState(oldPlan.getBillState());

        //子表信息设置
        List<Long> delDetailIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
            List<SectionPlanSubEntity> list = new ArrayList<>();
            SectionPlanSubEntity tmp = null;
            Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(SectionPlanSubEntity::getId, SectionPlanSubEntity::getVersion));

            for(SectionPlanChangeSubEntity detail : planChange.getMaterialSubList()) {
                tmp = BeanMapper.map(detail, SectionPlanSubEntity.class);
                if(null != detail.getTargetId()) {
                    tmp.setId(detail.getTargetId());
                    tmp.setVersion(map.get(detail.getTargetId()));
                    if(PlanChangeSubVO.CHANGE_TYPE_DEL.equals(detail.getChangeType())) {
                        //终止项删除
                        delDetailIds.add(detail.getTargetId());
                    } else {
                        tmp.setRowState("update");
                        list.add(tmp);
                    }
                } else {
                    tmp.setRowState("add");
                    list.add(tmp);
                }
            }

            newPlanEntity.setMaterialSubList(list);
        }

        //删除已有子表
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            planSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
        }

        if(planService.saveOrUpdate(newPlanEntity, false)) {
            logger.info("回调业务处理成功！");
        }else{
            logger.info("回调业务处理失败！");
        }
    }
}
