package com.ejianc.foundation.bulidMaterialMdm.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.hystrix.BulidMaterialUserHystrix;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.mdm.hystrix.MdmHystrix;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.param.InsertParam;
import com.ejianc.foundation.mdm.param.ListByIdsParam;
import com.ejianc.foundation.mdm.param.ListParam;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 *
 * 
 * @author
 *
 */
@FeignClient(name= "ejc-mdm-web", url="${common.env.feign-client-url}", path="ejc-mdm-web", fallback = BulidMaterialUserHystrix.class)
public interface IBulidMaterialUserApi {

	/**
	 *
	 */
	@RequestMapping(value = "/user/performHandover", method=RequestMethod.GET)
	 CommonResponse<String> performHandover(@RequestParam("targetUserId") Integer targetUserId,
												  @RequestParam("userId") Integer userId);

	/**
	 *
	 */
	@RequestMapping(value = "/user/getUserInfoByMdmId", method=RequestMethod.GET)
	CommonResponse<UserVO> getUserInfoByMdmId(@RequestParam("mdmId")  Long mdmId);
}
