/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.MdmUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmManage"})
public class MdmManageController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Autowired
    private IDataModelService dataModelService;
    @Autowired
    private IDataModelItemService dataModelItemService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody Map<String, Object> param) {
        if (param.get("modelCode") == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6a21\u578b\u7f16\u7801\u53c2\u6570");
        }
        if (param.get("pageIndex") == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9875\u6570");
        }
        if (param.get("pageSize") == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6761\u6570");
        }
        Long pageIndex = param.get("pageIndex") != null ? Long.parseLong(param.get("pageIndex").toString()) : 1L;
        Long pageSize = param.get("pageSize") != null ? Long.parseLong(param.get("pageSize").toString()) : 10L;
        JSONObject responseData = new JSONObject();
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", param.get("modelCode"));
        List masterDataModelEntities = this.dataModelService.list((Wrapper)masterDataModelWrapper);
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)masterDataModelEntities.get(0));
        QueryWrapper masterDataModelItemWrapper = new QueryWrapper();
        masterDataModelItemWrapper.eq((Object)"data_model_id", (Object)masterDataModelEntity.getId());
        masterDataModelItemWrapper.orderByAsc((Object)"sequence");
        List dataModelItemEntities = this.dataModelItemService.list((Wrapper)masterDataModelItemWrapper);
        HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
        long startLine = (pageIndex == null ? 0L : pageIndex - 1L) * pageSize;
        modelItemMap.put("pageIndex", startLine);
        modelItemMap.put("pageSize", pageSize);
        String searchSql = "";
        modelItemMap.put("lastUpdateTimeDesc", "desc");
        if (param.get("params") != null) {
            JSONObject params = JSONObject.parseObject((String)param.get("params").toString());
            for (String key : params.keySet()) {
                if (searchSql.length() > 0) {
                    searchSql = searchSql + " and " + key + " like '%" + params.getString(key) + "%'";
                    continue;
                }
                searchSql = searchSql + " " + key + " like '%" + params.getString(key) + "%'";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchSql)) {
            modelItemMap.put("searchSql", searchSql);
        }
        modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
        List<JSONObject> resultDataList = this.dataModelItemService.queryMdmDataList(modelItemMap);
        Long dataTotal = this.dataModelItemService.queryMdmDataCount(modelItemMap);
        MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
        if (resultDataList != null && resultDataList.size() > 0) {
            QueryWrapper childDataModelWrapper = new QueryWrapper();
            childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
            List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
            if (childDataModelList != null && childDataModelList.size() > 0) {
                for (DataModelEntity childModel : childDataModelList) {
                    QueryWrapper childDataModelItemWrapper = new QueryWrapper();
                    childDataModelItemWrapper.eq((Object)"data_model_id", (Object)childModel.getId());
                    List childDataModelItemEntities = this.dataModelItemService.list((Wrapper)childDataModelItemWrapper);
                    for (JSONObject masterData : resultDataList) {
                        HashMap<String, Object> childParamMap = new HashMap<String, Object>();
                        childParamMap.put("parentId", masterData.get((Object)"_master_data_id").toString());
                        childParamMap.put("tableName", childModel.getModelCode());
                        List<JSONObject> childDataList = this.dataModelItemService.queryMdmChildDataList(childParamMap);
                        MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
                        masterData.put(childModel.getModelCode(), childDataList);
                    }
                }
            }
        }
        responseData.put("current", (Object)pageIndex);
        responseData.put("size", (Object)pageSize);
        responseData.put("total", (Object)dataTotal);
        responseData.put("records", resultDataList);
        responseData.put("modelItems", (Object)dataModelItemEntities);
        return CommonResponse.success((Object)responseData);
    }

    @RequestMapping(value={"/deleteMdmData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteMdmData(@RequestBody DeleteParam deleteParam, HttpServletRequest request) {
        QueryWrapper masterDataModelWrapper = new QueryWrapper();
        masterDataModelWrapper.eq((Object)"model_code", (Object)deleteParam.getDataModelCode());
        List masterDataModelEntities = this.dataModelService.list((Wrapper)masterDataModelWrapper);
        DataModelEntity masterDataModelEntity = (DataModelEntity)((Object)masterDataModelEntities.get(0));
        List mdmIds = deleteParam.getMdmIds();
        String mdmIdStr = "";
        List<JSONObject> resultDataList = null;
        if (mdmIds != null && mdmIds.size() > 0) {
            for (String mdmId : mdmIds) {
                mdmIdStr = mdmIdStr + "'" + mdmId + "',";
            }
            if (StringUtils.isNotBlank((CharSequence)mdmIdStr)) {
                mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length() - 1);
            }
            HashMap<String, Object> modelItemMap = new HashMap<String, Object>();
            modelItemMap.put("mdmIdStr", mdmIdStr);
            modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
            modelItemMap.put("pageIndex", -1);
            resultDataList = this.dataModelItemService.queryMdmDataList(modelItemMap);
            if (resultDataList != null && resultDataList.size() > 0) {
                QueryWrapper childDataModelWrapper = new QueryWrapper();
                childDataModelWrapper.eq((Object)"parent_id", (Object)masterDataModelEntity.getId());
                List childDataModelList = this.dataModelService.list((Wrapper)childDataModelWrapper);
                if (childDataModelList != null && childDataModelList.size() > 0) {
                    for (DataModelEntity childModel : childDataModelList) {
                        for (JSONObject masterData : resultDataList) {
                            HashMap<String, Object> childParamMap = new HashMap<String, Object>();
                            childParamMap.put("parentId", masterData.get((Object)"id").toString());
                            childParamMap.put("tableName", childModel.getModelCode());
                            this.dataModelItemService.deleteChildMdmData(childParamMap);
                        }
                    }
                }
            }
            this.dataModelItemService.deleteMasterMdmData(modelItemMap);
            return CommonResponse.success();
        }
        throw new BusinessException("\u4e3b\u6570\u636eids\u4e0d\u6b63\u786e");
    }
}

