package com.ejianc.foundation.mdm.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.mapper.DataTransferLogMapper;
import com.ejianc.foundation.mdm.service.IDataTransferLogService;
import com.ejianc.foundation.mdm.vo.DataTransferLogVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DataTransferLogServiceImpl extends BaseServiceImpl<DataTransferLogMapper, DataTransferLogEntity> implements IDataTransferLogService {
	
	@Autowired
	private DataTransferLogMapper dataTransferLogMapper;
	
	@Override
	public IPage<DataTransferLogVO> queryDataTransferLogPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());	
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		
		List<DataTransferLogVO> records = dataTransferLogMapper.queryDataTransferLogList(condition);
		Long count = dataTransferLogMapper.queryDataTransferLogCount(condition);
		
		IPage<DataTransferLogVO> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

}
