package com.ejianc.foundation.mdm.bean;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 数据模型分类表
 * 
 * @author guoming
 *
 */
@TableName("ejc_mdm_datamodel_category")
public class DataModelCategoryEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "parent_id")
	private Long parentId;

	/**
	 * 分类编码
	 */
	@TableField(value = "category_code")
	private String categoryCode;

	/**
	 * 分类名称
	 */
	@TableField(value = "category_name")
	private String categoryName;

	/**
	 * 内码
	 */
	@TableField(value = "inner_code")
	private String innerCode;

	/**
	 * 分类排序
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	@TableField(exist = false)
	private List<DataModelCategoryEntity> children = new ArrayList<DataModelCategoryEntity>();

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public List<DataModelCategoryEntity> getChildren() {
		return children;
	}

	public void setChildren(List<DataModelCategoryEntity> children) {
		this.children = children;
	}

}
