package com.ejianc.foundation.mdm.controller.sync;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.api.IProManageApi;
import com.ejianc.business.dataexchange.vo.ProManageVO;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjJobResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjJobVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjOrgVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUpdateVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserResponseVO;
import com.ejianc.foundation.mdm.controller.sync.vo.ZzyjUserVO;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.HttpTookitZzyj;
import com.ejianc.foundation.mdm.utils.ZzyjSyncConfig;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("/zzyj/sync")
public class ZzyjSyncController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1L;


	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;
	@Autowired
	private IProManageApi proManageApi;


	@Value("${common.env.base-host}")
	private String baseHost;


	public String getDateTime() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return format.format(new Date());
	}
	
	public ZzyjSyncConfig initZzyjSyncConfig() {
		String hrHost = "http://hr.zzyjjt.com";
		String sysFlag = "EJC";
		String sysEtoken = "3C5012D3B13488C7DA823C9574234FBB";
		String sys = "ejc";
		if(baseHost.contains("csqlh")){
			//测试环境
			sysFlag = "EJCCS";
			sysEtoken = "36A208CBD13488C8E51AB0E954D8EF23";
			sys = "ejccs";
		}
		ZzyjSyncConfig zzyjSyncConfig = new ZzyjSyncConfig(hrHost, sysFlag, sysEtoken, sys);
		return zzyjSyncConfig;
	}

	/**
	 * 组织+部门
	 * 
	 * @return
	 */
	@RequestMapping(value = "/orgs")
	@ResponseBody
	public CommonResponse<String> syncOrgs(HttpServletRequest request) {
		ZzyjSyncConfig zzyjSyncConfig = initZzyjSyncConfig();
		logger.info(">>>>{}>>>>郑州一建宏景HR同步组织数据start...", getDateTime());
		try {
			String resp = HttpTookitZzyj.get(zzyjSyncConfig.getOrgUrl(), request);
			logger.info("resp======="+resp);
			ZzyjOrgResponseVO zzyjOrgResponseVO = JSONObject.parseObject(resp, ZzyjOrgResponseVO.class);

			if (zzyjOrgResponseVO.isSuccess()) {
				logger.info(">>>>{}>>>>接收到郑州一建宏景HR组织数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData()) ? zzyjOrgResponseVO.getData().size() : 0);
				if (CollectionUtils.isNotEmpty(zzyjOrgResponseVO.getData())) {
					List<ZzyjOrgVO> orgData = zzyjOrgResponseVO.getData();
					List<String> delOrgSourceIds = new ArrayList<>();
					List<String> delDeptSourceIds = new ArrayList<>();
					List<ZzyjUpdateVO> updateVOS = new ArrayList<>();
					if (CollectionUtils.isNotEmpty(orgData)) {
						// 组织、部门排序，先保存组织，再保存部门
						Collections.sort(orgData, (o1, o2) -> {
							int a1 = StringUtils.isNotEmpty(o1.getGrade()) ? Integer.parseInt(o1.getGrade()) : 0;
							int a2 = StringUtils.isNotEmpty(o2.getGrade()) ? Integer.parseInt(o2.getGrade()) : 0;
							return a1 - a2;
						});

						for (ZzyjOrgVO zzyjOrgVO : orgData) {
//							JSONObject jo = BeanMapper.map(zzyjOrgVO, JSONObject.class);
//							logger.info(jo.toJSONString());
//							if("UM".equals(zzyjOrgVO.getCodesetid())&&"项目".equals(zzyjOrgVO.getB010a())){
//								System.out.print(zzyjOrgVO.getUnique_id()+",");
//							}
//							if("UM".equals(zzyjOrgVO.getCodesetid())&&!"项目".equals(zzyjOrgVO.getB010a())&&!"部门".equals(zzyjOrgVO.getB010a())&&!"机关".equals(zzyjOrgVO.getB010a())){
//								System.out.println(zzyjOrgVO.getCodeitemdesc()+"【"+zzyjOrgVO.getB0110_0()+"】,");
//							}
							boolean success = false;
							// 公司
							if ("UN".equals(zzyjOrgVO.getCodesetid())) {
								success = this.syncOrgVO(zzyjOrgVO, delOrgSourceIds);
							} else if("UM".equals(zzyjOrgVO.getCodesetid())&&("22".equals(zzyjOrgVO.getB010a())||"32".equals(zzyjOrgVO.getB010a())||"42".equals(zzyjOrgVO.getB010a())||StringUtils.isBlank(zzyjOrgVO.getB010a()))){
								//处理项目数据（为空时默认魏项目部数据）
								success = this.syncOrgVO(zzyjOrgVO, delOrgSourceIds);
							}
							// 部门UM
							else {
								success = this.syncDeptVO(zzyjOrgVO, delDeptSourceIds);
							}
							
							if(baseHost.contains("csqlh")){
								updateVOS.add(zzyjOrgVO.toUpdateVO(success));
							}else{
								updateVOS.add(zzyjOrgVO.toEjcUpdateVO(success));
							}
						}
						// 删除公司
						if (CollectionUtils.isNotEmpty(delOrgSourceIds)) {
							String delOrgSourceIdStr = "";
							for(String delOrgSourceId:delOrgSourceIds) {
								delOrgSourceIdStr += "'"+delOrgSourceId+"',";
							}
							delOrgSourceIdStr = delOrgSourceIdStr.substring(0, delOrgSourceIdStr.length()-1);
							dataModelItemService.deleteMdmDataBySourceIds("orgmodel", delOrgSourceIdStr);
						}
						// 删除部门
						if (CollectionUtils.isNotEmpty(delDeptSourceIds)) {
							String delDeptSourceIdStr = "";
							for(String delDeptSourceId:delOrgSourceIds) {
								delDeptSourceIdStr += "'"+delDeptSourceId+"',";
							}
							delDeptSourceIdStr = delDeptSourceIdStr.substring(0, delDeptSourceIdStr.length()-1);
							dataModelItemService.deleteMdmDataBySourceIds("deptmodel", delDeptSourceIdStr);
						}

						// 回写一建同步成功标志
						CommonResponse<ZzyjResponseVO> zzyjResponseVOCommonResponse = this.callBackUpdateInfo(ZzyjSyncConfig.ORG, updateVOS);
						if (!zzyjResponseVOCommonResponse.isSuccess()) {
							logger.info("郑州一建同步组织更新返回ERRORERRORERRORERRORERRORERROR:{}", zzyjResponseVOCommonResponse.getMsg());
							return CommonResponse.error(zzyjResponseVOCommonResponse.getMsg());
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统组织执行完毕!");
	}

	/**
	 * 人员同步
	 * 
	 * @return
	 */
	@RequestMapping(value = "/users")
	@ResponseBody
	public CommonResponse<String> syncUsers(HttpServletRequest request) {
		ZzyjSyncConfig zzyjSyncConfig = initZzyjSyncConfig();
		logger.info(">>>>{}>>>>郑州一建宏景HR同步人员数据start...", getDateTime());
		try {
			String resp = HttpTookitZzyj.get(zzyjSyncConfig.getUserUrl(), request);
			ZzyjUserResponseVO zzyjUserResponseVO = JSONObject.parseObject(resp, ZzyjUserResponseVO.class);

			if (zzyjUserResponseVO.isSuccess()) {
				logger.info(">>>>{}>>>>接收到郑州一建宏景HR人员数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData()) ? zzyjUserResponseVO.getData().size() : 0);
				if (CollectionUtils.isNotEmpty(zzyjUserResponseVO.getData())) {
					List<String> delUserSourceIds = new ArrayList<>();
			        List<ZzyjUpdateVO> updateVOS = new ArrayList<>();
			        
			        QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
					masterDataModelWrapper.eq("model_code", "employeemodel");
					DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
					// 主模型字段
					QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
					masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
					List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
					Map<String, JSONObject> postMap = new HashMap<>();
					
			        for (ZzyjUserVO syncVO : zzyjUserResponseVO.getData()) {
//			        	if("胡二永".equals(syncVO.getA0101())||"张忠祥".equals(syncVO.getA0101())){
//				        	JSONObject employeeJson = syncVO.toEmployeeVO();
//				        	logger.info(employeeJson.toJSONString());
				    		String type = "";
				    		if(baseHost.contains("csqlh")){
				    			//测试环境
				    			type = syncVO.getEjccs();
				    		}else{
				    			type = syncVO.getEjc();
				    		}
				    		if ("3".equals(type)) {
				                delUserSourceIds.add(syncVO.getUnique_id());
								if(baseHost.contains("csqlh")){
									updateVOS.add(syncVO.toUpdateVO(true));
								}else{
									updateVOS.add(syncVO.toEjcUpdateVO(true));
								}
				                continue;
				            }
				        	
				        	//查询所属组织
				        	JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+syncVO.getB0110_0()+"'");
							//查询所属部门
							JSONObject deptEntity = dataModelItemService.getObjectBySqlCondition("deptmodel", " and code='"+syncVO.getE0122_0()+"'");
				        	if(deptEntity != null) {
				        		if(orgEntity == null) {
				        			orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and _master_data_id='"+deptEntity.getString("orgId")+"'");
				        		}
				        	}else{
								//查询所属部门---为项目部的时候，查询组织
								JSONObject projectEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+syncVO.getE0122_0()+"'");
								if(projectEntity != null) {
									orgEntity = projectEntity;
								}
							}

				        	
				        	JSONObject employeeJson = syncVO.toEmployeeVO();
				        	JSONObject employeeObj = dataModelItemService.queryDataBySourceId("employeemodel", employeeJson.getString("sourceId"));
				        	String executeSql = "";
				        	
				        	String postName = employeeJson.getString("postName");
				        	JSONObject postEntity = null;
				        	//岗位信息
				        	if(StringUtils.isNotBlank(postName)){
				        		//查库
				        		if(postMap.get(postName) != null) {
				        			postEntity = postMap.get(postName);
				        		}else{
				        			postEntity = dataModelItemService.getObjectBySqlCondition("postmodel", " and name='"+postName+"'");
				        			if(postEntity!=null){
				        				postMap.put(postEntity.getString("name"), postEntity);
				        			}
				        		}
				        	}
				        	
				        	if(employeeObj != null) { //修改
				        		String empOrgId = employeeObj.getString("orgId");
				        		String empDeptId = employeeObj.getString("deptId");

								employeeObj.put("userPassword", employeeJson.getString("userPassword"));
								employeeObj.put("userCode", employeeJson.getString("userCode"));
				        		employeeObj.put("mobilePhone", employeeJson.getString("mobilePhone"));
				        		employeeObj.put("employeeCode", employeeJson.getString("employeeCode"));
				        		employeeObj.put("employeeName", employeeJson.getString("employeeName"));
				        		if(orgEntity != null && orgEntity.getString("_master_data_id")!=null){
				        			employeeObj.put("orgId", orgEntity.getString("_master_data_id"));
				        		}
				        		employeeObj.put("orgCode", employeeJson.getString("orgCode"));
				        		employeeObj.put("orgName", employeeJson.getString("orgName"));
				        		if(deptEntity!=null&&deptEntity.get("_master_data_id")!=null){
				        			employeeObj.put("deptId", deptEntity.getString("_master_data_id"));
				        		}else{
				        			employeeObj.put("deptId", "");
				        		}
				        		employeeObj.put("deptCode", employeeJson.getString("deptCode"));
				        		employeeObj.put("deptName", employeeJson.getString("deptName"));
				        		employeeObj.put("sex", employeeJson.getString("sex"));
				        		employeeObj.put("email", employeeJson.getString("email"));
				        		employeeObj.put("idCard", employeeJson.getString("idCard"));
				        		employeeObj.put("telephone", employeeJson.getString("telephone"));
				        		employeeObj.put("sequence", employeeJson.getString("sequence"));
				        		employeeObj.put("weixineeId", employeeJson.getString("weixineeId"));
				        		employeeObj.put("empState", employeeJson.getString("empState"));
				        		if(postEntity!=null&&postEntity.get("_master_data_id")!=null){
				        			employeeObj.put("postId", postEntity.getString("_master_data_id"));
				        		}else{
				        			employeeObj.put("postId", "");
				        		}
				        		
				        		executeSql += "update employeemodel set _last_update_time = now(),_data_type=2,";
								for (DataModelItemEntity modelItem : dataModelItemEntities) {
									if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
										continue;
									}
									if(StringUtils.isNotBlank(employeeObj.getString(modelItem.getItemCode()))) {
										executeSql += "`" + modelItem.getItemCode() + "`='" + employeeObj.getString(modelItem.getItemCode()) + "',";
									}else{
										executeSql += "`" + modelItem.getItemCode() + "`=null,";
									}
								}
								executeSql = executeSql.substring(0, executeSql.length() - 1);
								executeSql += " where _source_id='" + employeeJson.getString("sourceId") + "'";
	
								dataModelItemService.executeUpdateSql(executeSql);
								
								//查询该人的主职信息
								boolean isMoveJob = false;
								if(StringUtils.isNotBlank(empOrgId) && !empOrgId.equals(orgEntity.getString("_master_data_id"))) {
									isMoveJob = true;
								}else{
									if(StringUtils.isNotBlank(empDeptId) && deptEntity!=null && !empDeptId.equals(deptEntity.getString("_master_data_id"))){
										isMoveJob = true;
									}else if(StringUtils.isNotBlank(empDeptId) && deptEntity==null){
										isMoveJob = true;
									}else if(StringUtils.isBlank(empDeptId) && deptEntity!=null){
										isMoveJob = true;
									}
	//								if(StringUtils.isNotBlank(empDeptId) && !empDeptId.equals(deptEntity.getString("_master_data_id"))) {
	//									isMoveJob = true;
	//								}
								}
								if(isMoveJob) {
									//更改之前的任职状态为调出
									String updatePreJobState = "update jobmodel set curState = 1,jobStartEndTime=now(),_last_update_time=now(),_data_type=2 where _parent_id='"+employeeObj.getString("_master_data_id")+"' and property = 1 and curState = 0 and orgId = '" +empOrgId+"'";
									dataModelItemService.executeUpdateSql(updatePreJobState);
									//新增的心得任职
									String pkId = IdWorker.getId()+"";
									String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,orgId,orgCode,orgName,deptId,deptCode,deptName,postId,postCode,postName,jobStartTime,curState,property) values";
									insertNewJobSql+= "("+pkId+",now(),1,"+pkId+",'"+employeeObj.getString("_master_data_id")+"','"+orgEntity.getString("_master_data_id")+"','"+orgEntity.getString("code")+"','"+orgEntity.getString("name")+"','"+(deptEntity!=null?deptEntity.getString("_master_data_id"):"")+"','"+(deptEntity!=null?deptEntity.getString("code"):"")+"','"+(deptEntity!=null?deptEntity.getString("name"):"")+"','"+(postEntity!=null?postEntity.getString("_master_data_id"):"")+"','"+(postEntity!=null?postEntity.getString("code"):"")+"','"+(postEntity!=null?postEntity.getString("name"):"")+"',now(),0,1)";
									dataModelItemService.executeInsertSql(insertNewJobSql);
								}else{
									String postId = employeeObj.getString("postId");
									if(StringUtils.isNotBlank(postId)) {
										String updatedjobPost = "update jobmodel set postId='"+postId+"',postCode='"+postEntity.getString("code")+"',postName='"+postEntity.getString("name")+"' where _parent_id='"+employeeObj.getString("_master_data_id")+"' and property = 1 and curState = 0 and orgId = '" +empOrgId+"'";
										dataModelItemService.executeUpdateSql(updatedjobPost);
									}
								}
				        	}
				        	if(StringUtils.isBlank(executeSql)) {
				        		if(orgEntity != null) {
				        			employeeJson.put("orgId", orgEntity.getString("_master_data_id"));
				        		}else{
				        			continue;
				        		}
				        		if(deptEntity != null) {
				        			employeeJson.put("deptId", deptEntity.getString("_master_data_id"));
				        		}
				        		if(postEntity != null) {
				        			employeeJson.put("postId", postEntity.getString("_master_data_id"));
				        		}
				        		Long employeeId = IdWorker.getId();
				        		executeSql = "insert into employeemodel";
								String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,";
								String valueSql = " values(" + employeeId + ",now(),1,'" + employeeJson.getString("sourceId") + "',";
								for (DataModelItemEntity modelItem : dataModelItemEntities) {
									if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
										continue;
									}
									String itemCode = modelItem.getItemCode();
									fieldSql += "`" + itemCode + "`,";
									if(StringUtils.isNotBlank(employeeJson.getString(itemCode))) {
										valueSql += "'" + employeeJson.getString(itemCode) + "',";
									}else{
										valueSql += "null,";
									}
								}
								fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
								valueSql = valueSql.substring(0, valueSql.length() - 1);
								fieldSql = fieldSql + ")";
								valueSql = valueSql + ")";
	
								executeSql = executeSql + fieldSql + valueSql;
								dataModelItemService.executeInsertSql(executeSql);
								
								String pkId = IdWorker.getId()+"";
								String insertNewJobSql = "insert into jobmodel(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,orgId,orgCode,orgName,deptId,deptCode,deptName,postId,postCode,postName,jobStartTime,curState,property) values";
								insertNewJobSql+= "("+pkId+",now(),1,"+pkId+","+employeeId+",'"+orgEntity.getString("_master_data_id")+"','"+orgEntity.getString("code")+"','"+orgEntity.getString("name")+"','"+(deptEntity!=null?deptEntity.getString("_master_data_id"):"")+"','"+(deptEntity!=null?deptEntity.getString("code"):"")+"','"+(deptEntity!=null?deptEntity.getString("name"):"")+"','"+(postEntity!=null?postEntity.getString("_master_data_id"):"")+"','"+(postEntity!=null?postEntity.getString("code"):"")+"','"+(postEntity!=null?postEntity.getString("name"):"")+"',now(),0,1)";
								dataModelItemService.executeInsertSql(insertNewJobSql);
				        	}
				        	
							if(baseHost.contains("csqlh")){
								updateVOS.add(syncVO.toUpdateVO(true));
							}else{
								updateVOS.add(syncVO.toEjcUpdateVO(true));
							}
//						}

		        	}
			       // 删除人员
					if (CollectionUtils.isNotEmpty(delUserSourceIds)) {
						String delUserSourceIdStr = "";
						for(String delUserSourceId:delUserSourceIds) {
							delUserSourceIdStr += "'"+delUserSourceId+"',";
						}
						delUserSourceIdStr = delUserSourceIdStr.substring(0, delUserSourceIdStr.length()-1);
						dataModelItemService.deleteMdmDataBySourceIds("employeemodel", delUserSourceIdStr);
					}

					// 回写一建同步成功标志
					CommonResponse<ZzyjResponseVO> zzyjResponseVOCommonResponse = this.callBackUpdateInfo(ZzyjSyncConfig.HR, updateVOS);
					if (!zzyjResponseVOCommonResponse.isSuccess()) {
						logger.info("郑州一建同步人员更新返回ERRORERRORERRORERRORERRORERROR:{}", zzyjResponseVOCommonResponse.getMsg());
						return CommonResponse.error(zzyjResponseVOCommonResponse.getMsg());
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("郑州一建同步宏景HR系统人员报错：{}",e);
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统人员执行完毕!");
	}
	
	/**
	 * 兼职同步
	 * 
	 * @return
	 */
	@RequestMapping(value = "/jobs")
	@ResponseBody
	public CommonResponse<String> syncJobs(HttpServletRequest request) {
		ZzyjSyncConfig zzyjSyncConfig = initZzyjSyncConfig();
		logger.info(">>>>{}>>>>郑州一建宏景HR同步兼职数据start...", getDateTime());
		try {
			Integer pageIndex = 1;
			//1清空数据临时表数据
			dataModelItemService.executeUpdateSql("delete from jobmodel_temporary");
			//2将查询到的数据插入临时表
			Map<String,JSONObject> employeeMap = new HashMap<>();
			Map<String,JSONObject> orgMap = new HashMap<>();
			Map<String,JSONObject> orgIdMap = new HashMap<>();
			Map<String,JSONObject> deptMap = new HashMap<>();
			Map<String,JSONObject> postMap = new HashMap<>();

			Integer orgnum = 0;
			Integer deptnum = 0;
			Integer postnum = 0;
			Integer jobnum = 0;
			boolean flag = true;
			while(true) {
				String resp = HttpTookitZzyj.get(zzyjSyncConfig.getJobUrl()+"&pageNo="+pageIndex+"&pageSize=1000", request);

				ZzyjJobResponseVO zzyjJobResponseVO = JSONObject.parseObject(resp, ZzyjJobResponseVO.class);
				if (zzyjJobResponseVO.isSuccess()) {
					logger.info(">>>>{}>>>>接收到郑州一建宏景HR兼职数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(zzyjJobResponseVO.getData()) ? zzyjJobResponseVO.getData().size() : 0);
					if (CollectionUtils.isNotEmpty(zzyjJobResponseVO.getData())) {
						
				        for (ZzyjJobVO syncVO : zzyjJobResponseVO.getData()) {
				        	String orgCode = syncVO.getE0911(); //兼职单位
				        	String deptCode = syncVO.getE0902(); //兼职部门
				        	String postCode = syncVO.getA0902(); //兼职所属岗位序列
				        	String useridCard = syncVO.getUserid(); //人员身份证号
				        	String jobStartTime = syncVO.getE0907(); //兼职时间
				        	String createtime = syncVO.getCreatetime(); //创建时间
				        	if(StringUtils.isBlank(orgCode)){
				        		orgnum++;
//				    			logger.info("e0911:{},e0902:{},a0902:{},userid:{},e0907:{}",orgCode,deptCode,postCode,useridCard,jobStartTime);
//				    			continue;
				        	}
				        	if(StringUtils.isBlank(deptCode)){
				        		deptnum++;
//				    			logger.info("e0911:{},e0902:{},a0902:{},userid:{},e0907:{}",orgCode,deptCode,postCode,useridCard,jobStartTime);
//				    			continue;
				        	}
				        	if(StringUtils.isBlank(postCode)){
				        		postnum++;
//				    			logger.info("e0911:{},e0902:{},a0902:{},userid:{},e0907:{}",orgCode,deptCode,postCode,useridCard,jobStartTime);
//				    			continue;
				        	}
				        	if(StringUtils.isBlank(jobStartTime)){
				        		jobnum++;
//				    			logger.info("e0911:{},e0902:{},a0902:{},userid:{},e0907:{}",orgCode,deptCode,postCode,useridCard,jobStartTime);
//				    			continue;
				        	}
							
				        	String orgId = "";
				        	String orgName = "";
				        	String deptId = "";
				        	String deptName = "";
				        	String postId = "";
				        	String postName = "";
				        	String userId = "";
				        	//查询所属组织--根据部门code先查询组织表,组织存在,则为组织(无部门);部门存在则为部门带出部门组织信息;部门组织都不存在,则根据组织查询组织信息
				        	if(StringUtils.isNotBlank(deptCode)){
					        	if(orgMap.get(deptCode)!=null){
					        		orgId = orgMap.get(deptCode).getString("_master_data_id");
					        		orgName = orgMap.get(deptCode).getString("name");
					        		orgCode = deptCode;
					        		deptCode = "";
					        	}else if(deptMap.get(deptCode)!=null){
					        		deptId = deptMap.get(deptCode).getString("_master_data_id");
					        		deptName = deptMap.get(deptCode).getString("name");
					        		orgId = deptMap.get(deptCode).getString("orgId");
					        		if(orgIdMap.get(orgId)!=null){
						        		orgCode = orgIdMap.get(orgId).getString("code");
						        		orgName = orgIdMap.get(orgId).getString("name");
					        		}else{
					        			//根据组织查询信息
							        	JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and _master_data_id='"+orgId+"'");
							        	if(orgEntity!=null){
							        		orgMap.put(orgEntity.getString("code"), orgEntity);
							        		orgIdMap.put(orgEntity.getString("_master_data_id"), orgEntity);
							        		orgCode = orgEntity.getString("code");
							        		orgName = orgEntity.getString("name");
							        	}
					        		}
					        	}
				        	}
				        	if(StringUtils.isBlank(orgId)&&StringUtils.isNotBlank(deptCode)){
				        		//查库
					        	JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+deptCode+"'");
					        	if(orgEntity!=null){
					        		orgMap.put(orgEntity.getString("code"), orgEntity);
					        		orgIdMap.put(orgEntity.getString("_master_data_id"), orgEntity);
					        		orgId = orgEntity.getString("_master_data_id");
					        		orgCode = deptCode;
					        		orgName = orgEntity.getString("name");
					        		deptCode = "";
					        	}else{
						        	//查询所属部门
						        	JSONObject deptEntity = dataModelItemService.getObjectBySqlCondition("deptmodel", " and code='"+deptCode+"'");
						        	if(deptEntity != null) {
						        		deptMap.put(deptEntity.getString("code"), deptEntity);
						        		deptId = deptEntity.getString("_master_data_id");
						        		deptName = deptEntity.getString("name");
						        		orgId = deptEntity.getString("orgId");
						        		if(orgIdMap.get(orgId)!=null){
							        		orgCode = orgIdMap.get(orgId).getString("code");
							        		orgName = orgIdMap.get(orgId).getString("name");
						        		}else{
						        			//根据组织查询信息
								        	JSONObject org1Entity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and _master_data_id='"+orgId+"'");
								        	if(org1Entity!=null){
								        		orgMap.put(org1Entity.getString("code"), org1Entity);
								        		orgIdMap.put(org1Entity.getString("_master_data_id"), org1Entity);
								        		orgId = org1Entity.getString("_master_data_id");
								        		orgCode = org1Entity.getString("code");
								        		orgName = org1Entity.getString("name");
								        	}
						        		}
						        	}
					        	}
				        	}
				        	if(StringUtils.isBlank(orgId)&&StringUtils.isNotBlank(orgCode)){
					        	JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+orgCode+"'");
					        	if(orgEntity!=null){
					        		orgMap.put(orgEntity.getString("code"), orgEntity);
					        		orgIdMap.put(orgEntity.getString("_master_data_id"), orgEntity);
					        		orgId = orgEntity.getString("_master_data_id");
					        		orgCode = orgEntity.getString("code");
					        		orgName = orgEntity.getString("name");
					        	}
				        	}
				        	if(StringUtils.isBlank(orgId)){
				        		logger.info("根据组织{},部门{},未获取到相应的组织信息",orgCode,deptCode);
				        		continue;
				        	}
				        	//人员信息
				        	if(StringUtils.isNotBlank(useridCard)){
					        	if(employeeMap.get(useridCard)!=null){
					        		userId = employeeMap.get(useridCard).getString("_master_data_id");
					        	}else{
					        		//查库
						        	JSONObject employeeEntity = dataModelItemService.getObjectBySqlCondition("employeemodel", " and idCard='"+useridCard+"'");
						        	if(employeeEntity!=null){
						        		employeeMap.put(employeeEntity.getString("idCard"), employeeEntity);
						        		userId = employeeEntity.getString("_master_data_id");
						        	}
					        	}
				        	}
				        	if(StringUtils.isBlank(userId)){
				        		logger.info("根据人员{},未获取到相应的人员信息",useridCard);
				        		continue;
				        	}
				        	//岗位信息
				        	if(StringUtils.isNotBlank(postCode)){
				        		//查库
				        		if(postMap.get(postCode) != null) {
				        			postId = postMap.get(postCode).getString("_master_data_id");
				        			postName = postMap.get(postCode).getString("name");
				        		}else{
				        			JSONObject postEntity = dataModelItemService.getObjectBySqlCondition("postmodel", " and code='"+postCode+"'");
				        			if(postEntity!=null){
				        				postMap.put(postEntity.getString("code"), postEntity);
				        				postId = postEntity.getString("_master_data_id");
				        				postName = postEntity.getString("name");
				        			}
				        		}
				        	}
				        	String masterDataId = IdWorker.getId() + "";
							String insertSql = "insert into jobmodel_temporary";
							String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,orgId,orgCode,orgName,deptId,deptCode,deptName,postId,postCode,postName,jobStartTime,curState,property) ";
							String valueSql = " values(" + masterDataId + ",now(),1,'" + masterDataId + "','"+userId+"','" + orgId + "','" + orgCode + "','" + orgName + "','"
									+ deptId + "','" + deptCode + "','" + deptName + "','"
									+ postId + "','" + postCode + "','" + postName + "','"
									+ (StringUtils.isNotBlank(jobStartTime)?jobStartTime:(StringUtils.isNotBlank(createtime)?createtime:null)) + "',0,0)";
							dataModelItemService.executeInsertSql(insertSql+fieldSql+valueSql);
				        }
					}
				}else{
					flag = false;
					logger.error("接收到郑州一建宏景HR兼职数据接口失败,pageIndex:{}----",pageIndex);
					break;
				}

				if(zzyjJobResponseVO.getData().size()<1000){
					break;
				}
				pageIndex = pageIndex + 1000;
			}
			if(flag){
				//将两个表中的orgId,deptId,postId为空的设置默认值
				dataModelItemService.executeUpdateSql("update jobmodel_temporary set orgId='111111' where orgId is null;");
				dataModelItemService.executeUpdateSql("update jobmodel_temporary set deptId='222222' where deptId is null;");
				dataModelItemService.executeUpdateSql("update jobmodel_temporary set postId='333333' where postId is null;");
				dataModelItemService.executeUpdateSql("update jobmodel set orgId='111111' where orgId is null;");
				dataModelItemService.executeUpdateSql("update jobmodel set deptId='222222' where deptId is null;");
				dataModelItemService.executeUpdateSql("update jobmodel set postId='333333' where postId is null;");
				//3原先表中存在而临时表不存在的数据跟新为任职结束
				//任职结束的需要更新人员的最新时间及人员的更新状态改为修改
				dataModelItemService.executeUpdateSql("update employeemodel e set e._last_update_time = now(),e._data_type = '2'  where e._master_data_id in ("
						+" SELECT t._parent_id  from jobmodel t where t._master_data_id not in  (SELECT j._parent_id from jobmodel j "
						+" INNER JOIN jobmodel_temporary a on j._parent_id = a._parent_id and j.orgId = a.orgId and a.deptId = j.deptId and a.postId = j.postId) and property = 0) ");
				        
				dataModelItemService.executeUpdateSql("update jobmodel t set t.jobStartEndTime = now(),t._data_type = '3',t.curState = '1' where t._master_data_id not in ("
				+"	SELECT d._master_data_id from (select j.* from jobmodel j "
				+" INNER JOIN jobmodel_temporary a on j._parent_id = a._parent_id and j.orgId = a.orgId and a.deptId = j.deptId and a.postId = j.postId) d ) and t.property = 0 ");
		        
				//4删除临时表中一致的数据
				dataModelItemService.executeUpdateSql("delete from jobmodel_temporary where _master_data_id in ("
				+"	SELECT d._master_data_id from (select a.* from jobmodel j "
				+" INNER JOIN jobmodel_temporary a on j._parent_id = a._parent_id and j.orgId = a.orgId and a.deptId = j.deptId and a.postId = j.postId) d) ");
		        
				//5将临时表中的数据导入数据表
				dataModelItemService.executeUpdateSql("update employeemodel e set e._last_update_time = now(),e._data_type = '2'  where e._master_data_id in ("
						+" SELECT j._parent_id from jobmodel_temporary j )");
				
				dataModelItemService.executeInsertSql("insert into jobmodel select * from jobmodel_temporary ");
				
				//还原设置默认值的数据
				dataModelItemService.executeUpdateSql("update jobmodel set orgId=null where orgId = '111111';");
				dataModelItemService.executeUpdateSql("update jobmodel set deptId=null where deptId ='222222';");
				dataModelItemService.executeUpdateSql("update jobmodel set postId=null where postId ='333333';");
			}

			logger.info("共{}条,组织为空{}条,部门为空{}条,岗位为空{}条,任职开始时间为空{}条",pageIndex,orgnum,deptnum,postnum,jobnum);
		} catch (Exception e) {
			e.printStackTrace();
			dataModelItemService.executeUpdateSql("update jobmodel set orgId=null where orgId = '111111';");
			dataModelItemService.executeUpdateSql("update jobmodel set deptId=null where deptId ='222222';");
			dataModelItemService.executeUpdateSql("update jobmodel set postId=null where postId ='333333';");
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统兼职执行完毕!");
	}

	// 会写郑州一建
	private CommonResponse<ZzyjResponseVO> callBackUpdateInfo(String type, List<ZzyjUpdateVO> zzyjUpdateVOS) {
		ZzyjSyncConfig zzyjSyncConfig = initZzyjSyncConfig();
		String jsonString = JSONObject.toJSONString(zzyjUpdateVOS);
		try {
			String updStr = HttpTookitZzyj.postParameters(zzyjSyncConfig.getUpdateUrl(), zzyjSyncConfig.getUpdateParam(type, jsonString));
			ZzyjResponseVO zzyjResponseVO = JSONObject.parseObject(updStr, ZzyjResponseVO.class);
			if (!zzyjResponseVO.isSuccess()) {
				logger.info(">>>>>>回写郑州一建更新标识失败:" + zzyjResponseVO.getMsg());
				return CommonResponse.error(zzyjResponseVO.getMsg());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info(">>>>>>回写郑州一建" + type + "信息完毕!");
		return CommonResponse.success(">>>>>>回写郑州一建" + type + "信息完毕!");
	}

	private boolean syncOrgVO(ZzyjOrgVO zzyjOrgVO, List<String> delOrgSourceIds) {
		JSONObject orgJson = zzyjOrgVO.toOrgVO();
		String type = "";
		if(baseHost.contains("csqlh")){
			//测试环境
			type = zzyjOrgVO.getEjccs();
		}else{
			type = zzyjOrgVO.getEjc();
		}
		if ("3".equals(type)) {
			delOrgSourceIds.add(zzyjOrgVO.getUnique_id());
			return true;
		} else {
			JSONObject orgObj = dataModelItemService.queryDataBySourceId("orgmodel", orgJson.getString("sourceId"));
			String masterDataId = "";
			if (orgObj == null) {
				masterDataId = IdWorker.getId() + "";
			} else {
				masterDataId = orgObj.getString("_master_data_id");
			}

			String innerCode = "";
			String parentId = "";
			if (StringUtils.isNotEmpty(zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
				JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("orgmodel", "and code='" + zzyjOrgVO.getParentid()+"'");
				if (orgEntity != null) {
					innerCode = orgEntity.getString("innerCode") + "|" + masterDataId;
					parentId = orgEntity.getString("_master_data_id");
				} else {
					innerCode = masterDataId;
				}
			} else {
				innerCode = masterDataId;
			}
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", "orgmodel");
			DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			// 主模型字段
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

			String executeSql = "";
			if (orgObj != null) {
				orgObj.put("name", orgJson.getString("name"));
				orgObj.put("shortName", orgJson.getString("shortName"));
				orgObj.put("orgType", orgJson.getString("orgType"));
				orgObj.put("innerCode", innerCode);
				orgObj.put("parentId", parentId);
				orgObj.put("code", orgJson.getString("code"));
				orgObj.put("sequence", orgJson.getString("sequence"));
				orgObj.put("telephone", orgJson.getString("telephone"));
				orgObj.put("enabled", orgJson.getString("state"));

				executeSql += "update orgmodel set _last_update_time = now(),_data_type=2,";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(orgObj.getString(modelItem.getItemCode()))) {
						executeSql += "`" + modelItem.getItemCode() + "`='" + (orgObj.getString(modelItem.getItemCode())!=null?orgObj.getString(modelItem.getItemCode()):"") + "',";
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + orgJson.getString("sourceId") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}

			if (StringUtils.isBlank(executeSql)) {
				orgJson.put("innerCode", innerCode);
				orgJson.put("parentId", parentId);

				executeSql = "insert into orgmodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,enabled, ";
				String valueSql = " values(" + masterDataId + ",now(),1,'" + orgJson.getString("sourceId") + "','" + orgJson.getString("state") + "', ";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode()) || "enabled".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(orgJson.getString(itemCode))) {
						valueSql += "'" + (orgJson.getString(itemCode)!=null?orgJson.getString(itemCode):"") + "',";
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
			return true;
		}
	}

	private boolean syncDeptVO(ZzyjOrgVO zzyjOrgVO, List<String> delDeptSourceIds) {
		JSONObject deptJson = zzyjOrgVO.toDeptVO();
		String type = "";
		if(baseHost.contains("csqlh")){
			//测试环境
			type = zzyjOrgVO.getEjccs();
		}else{
			type = zzyjOrgVO.getEjc();
		}
		if ("3".equals(type)) {
			delDeptSourceIds.add(zzyjOrgVO.getUnique_id());
            return true;
		}else{
			JSONObject deptObj = dataModelItemService.queryDataBySourceId("deptmodel", deptJson.getString("sourceId"));
			String masterDataId = "";
			if (deptObj == null) {
				masterDataId = IdWorker.getId() + "";
			} else {
				masterDataId = deptObj.getString("_master_data_id");
			}

			String innerCode = "";
			String parentId = "";
			if (StringUtils.isNotEmpty(zzyjOrgVO.getParentid()) && !zzyjOrgVO.getParentid().equals(zzyjOrgVO.getB0110_0())) {
				JSONObject deptEntity = dataModelItemService.getObjectBySqlCondition("deptmodel", "and code='" + zzyjOrgVO.getParentid()+"'");
				if (deptEntity != null) {
					innerCode = deptEntity.getString("innerCode") + "|" + masterDataId;
					parentId = deptEntity.getString("_master_data_id");
				} else {
					innerCode = masterDataId;
				}
			} else {
				innerCode = masterDataId;
			}
			QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
			masterDataModelWrapper.eq("model_code", "deptmodel");
			DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
			// 主模型字段
			QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
			masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
			List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

			String executeSql = "";
			if (deptObj != null) {
				deptObj.put("name", deptJson.getString("name"));
				deptObj.put("code", deptJson.getString("code"));
				deptObj.put("shortName", deptJson.getString("shortName"));
				deptObj.put("sequence", deptJson.getString("sequence"));
				deptObj.put("telephone", deptJson.getString("telephone"));
				deptObj.put("enabled", deptJson.getString("state"));

	        	//查询所属组织
	        	JSONObject orgObj = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+deptJson.getString("parentid")+"'");
				if(orgObj!=null){
					deptObj.put("orgId", orgObj.getString("_master_data_id"));
				}
				executeSql += "update deptmodel set _last_update_time = now(),_data_type=2,";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(deptObj.getString(modelItem.getItemCode()))) {
						executeSql += "`" + modelItem.getItemCode() + "`='" + (deptObj.getString(modelItem.getItemCode())!=null?deptObj.getString(modelItem.getItemCode()):"") + "',";
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + deptJson.getString("sourceId") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}

			if (StringUtils.isBlank(executeSql)) {
				deptJson.put("innerCode", innerCode);
				deptJson.put("parentId", parentId);

	        	//查询所属组织
	        	JSONObject orgObj = dataModelItemService.getObjectBySqlCondition("orgmodel", " and code='"+deptJson.getString("parentid")+"'");
				if(orgObj!=null){
					deptJson.put("orgId", orgObj.getString("_master_data_id"));
				}
				executeSql = "insert into deptmodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id,enabled,";
				String valueSql = " values(" + masterDataId + ",now(),1,'" + deptJson.getString("sourceId") + "','"+deptJson.getString("state")+"',";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode()) || "enabled".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(deptJson.getString(itemCode))) {
						valueSql += "'" + (deptJson.getString(itemCode)!=null?deptJson.getString(itemCode):"") + "',";
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
			return true;
		}
	}

	/**
	 * 岗位
	 * 
	 * @return
	 */
	@RequestMapping(value = "/posts")
	@ResponseBody
	public CommonResponse<String> syncPosts(HttpServletRequest request) {
		logger.info(">>>>{}>>>>郑州一建宏景HR同步人员数据start...", getDateTime());
		try {
			CommonResponse<List<ProManageVO>> postResponse = proManageApi.queryProManageInfo();
			if (postResponse.isSuccess()) {
				logger.info(">>>>{}>>>>接收到郑州一建宏景HR岗位数据条数:{},开始解析并进行入库操作...", getDateTime(), CollectionUtils.isNotEmpty(postResponse.getData()) ? postResponse.getData().size() : 0);
				if (CollectionUtils.isNotEmpty(postResponse.getData())) {
					List<String> delPostSourceIds = new ArrayList<>();
//			        List<ZzyjUpdateVO> updateVOS = new ArrayList<>();
			        
			        QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
					masterDataModelWrapper.eq("model_code", "postmodel");
					DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
					// 主模型字段
					QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
					masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
					List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
					
			        for (ProManageVO syncVO : postResponse.getData()) {
//			        	SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			        	if(syncVO.getEndDate()==null){
			        		//为空--默认删除
			        		delPostSourceIds.add(syncVO.getCodeitemid());
			                continue;
			        	}
			        	if(syncVO.getEndDate().getTime()<new Date().getTime()){
			        		//结束时间小于当前时间，则说明已删除
			        		delPostSourceIds.add(syncVO.getCodeitemid());
			                continue;
			        	}

						JSONObject postObj = dataModelItemService.queryDataBySourceId("postmodel", syncVO.getCodeitemid());
						String masterDataId = "";
						if (postObj == null) {
							masterDataId = IdWorker.getId() + "";
						} else {
							masterDataId = postObj.getString("_master_data_id");
						}

						String innerCode = "";
						String parentId = "";
						if (StringUtils.isNotEmpty(syncVO.getParentid()) && !syncVO.getParentid().equals(syncVO.getCodeitemid())) {
							JSONObject orgEntity = dataModelItemService.getObjectBySqlCondition("postmodel", "and code='" + syncVO.getParentid()+"'");
							if (orgEntity != null) {
								innerCode = orgEntity.getString("innerCode") + "|" + masterDataId;
								parentId = orgEntity.getString("_master_data_id");
							} else {
								innerCode = masterDataId;
							}
						} else {
							innerCode = masterDataId;
						}

						String executeSql = "";
						if (postObj != null) {
							postObj.put("name", syncVO.getCodeitemdesc());
							postObj.put("code", syncVO.getCodeitemid());
							postObj.put("innerCode", innerCode);
							postObj.put("parentId", parentId);
							postObj.put("sequence", syncVO.getA0000());
//							postObj.put("enabled", orgJson.getString("telephone"));

							executeSql += "update postmodel set _last_update_time = now(),_data_type=2,";
							for (DataModelItemEntity modelItem : dataModelItemEntities) {
								if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
									continue;
								}
								if(StringUtils.isNotBlank(postObj.getString(modelItem.getItemCode()))) {
									executeSql += "`" + modelItem.getItemCode() + "`='" + (postObj.getString(modelItem.getItemCode())!=null?postObj.getString(modelItem.getItemCode()):"") + "',";
								}else{
									executeSql += "`" + modelItem.getItemCode() + "`=null,";
								}
							}
							executeSql = executeSql.substring(0, executeSql.length() - 1);
							executeSql += " where _source_id='" + syncVO.getCodeitemid() + "'";

							dataModelItemService.executeUpdateSql(executeSql);
						}
//			        	updateVOS.add(syncVO.toUpdateVO(true));

						if (StringUtils.isBlank(executeSql)) {
							postObj = new JSONObject();
							postObj.put("name", syncVO.getCodeitemdesc());
							postObj.put("code", syncVO.getCodeitemid());
							postObj.put("innerCode", innerCode);
							postObj.put("parentId", parentId);
							postObj.put("sequence", syncVO.getA0000());
//							postObj.put("enabled", orgJson.getString("telephone"));

							executeSql = "insert into postmodel";
							String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
							String valueSql = " values(" + masterDataId + ",now(),1,'" + syncVO.getCodeitemid() + "', ";
							for (DataModelItemEntity modelItem : dataModelItemEntities) {
								if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
									continue;
								}
								String itemCode = modelItem.getItemCode();
								fieldSql += "`" + itemCode + "`,";
								if(StringUtils.isNotBlank(postObj.getString(itemCode))) {
									valueSql += "'" + (postObj.getString(itemCode)!=null?postObj.getString(itemCode):"") + "',";
								}else{
									valueSql += "null,";
								}
							}
							fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
							valueSql = valueSql.substring(0, valueSql.length() - 1);
							fieldSql = fieldSql + ")";
							valueSql = valueSql + ")";

							executeSql = executeSql + fieldSql + valueSql;
							dataModelItemService.executeInsertSql(executeSql);
						}
					}
			        
			       // 删除岗位
					if (CollectionUtils.isNotEmpty(delPostSourceIds)) {
						String delPostSourceIdStr = "";
						for(String delPostSourceId:delPostSourceIds) {
							delPostSourceIdStr += "'"+delPostSourceId+"',";
						}
						delPostSourceIdStr = delPostSourceIdStr.substring(0, delPostSourceIdStr.length()-1);
						dataModelItemService.deleteMdmDataBySourceIds("postmodel", delPostSourceIdStr);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(">>>>郑州一建同步宏景HR系统岗位报错---------",e);
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步宏景HR系统岗位执行完毕!");
	}


	/**
	 * 项目
	 *
	 * @return
	 */
	@RequestMapping(value = "/project")
	@ResponseBody
	public CommonResponse<String> syncProject(HttpServletRequest request) {
		logger.info(">>>>{}>>>>郑州一建 同步项目数据start...", getDateTime());
		String syncMode = request.getParameter("syncMode"); //full or increment
		String syncUrl = baseHost+"ejc-share-web/zzyj/mdm/project/sync";
		if(StringUtils.isNotBlank(syncMode)) {
			syncUrl += "?syncMode="+syncMode;
		}else{
			syncUrl += "?syncMode=increment";
		}
		try {
			QueryParam param = new QueryParam();
			boolean has = true;
			int pageSize = 500;
			int pageNum = 1;
			while (has){
				param.setPageSize(pageSize);
				param.setPageIndex(pageNum);
				String resp = HttpTookitZzyj.postJson(syncUrl, JSONObject.toJSONString(param));
//				logger.info(">>>>>>>>郑州一建 同步项目数据 "+pageNum+" >>>{}", resp);
				if(StringUtils.isNotEmpty(resp)){
					JSONObject r = JSONObject.parseObject(resp);
					if(r.getInteger("code") == 0 && r.get("data")!=null && r.getJSONArray("data").size()>0){
						JSONArray projectList = r.getJSONArray("data");
						saveOrUpdateProject(projectList);
						pageNum ++;
					}else {
						has = false;
					}
				}else {
					has = false;
				}
			}

		}catch (Exception e){
			e.printStackTrace();
			logger.error(">>>>郑州一建同步 项目报错---------",e);
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步 项目执行完毕!");
	}

	private void saveOrUpdateProject(JSONArray projectList){
		QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
		masterDataModelWrapper.eq("model_code", "projectmodel");
		DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
		// 主模型字段
		QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
		masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
		List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

		for (int i = 0; i < projectList.size(); i++) {
			JSONObject project = projectList.getJSONObject(i);
			JSONObject proObj = dataModelItemService.queryDataBySourceId("projectmodel", project.getString("id"));
			if(proObj == null && project.getInteger("dr") == 1) {
				continue;
			}
			String executeSql = "";
			if(proObj!=null){//修改
				executeSql += "update projectmodel set _last_update_time = now(),";
				if(project.getInteger("dr") == 1){
					executeSql +="_data_type=3,";
				}else {
					executeSql +="_data_type=2,";
				}
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(project.getString(modelItem.getItemCode()))) {
						if("planStartDate".equals(modelItem.getItemCode()) || "planEndDate".equals(modelItem.getItemCode()) ){
							SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
							executeSql += "`" + modelItem.getItemCode() + "`='" + format.format(project.getDate(modelItem.getItemCode())) + "',";
						}else {
							executeSql += "`" + modelItem.getItemCode() + "`='" + (project.getString(modelItem.getItemCode())!=null?project.getString(modelItem.getItemCode()):"") + "',";
						}
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + project.getString("id") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}else {//新增
				executeSql = "insert into projectmodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
				String valueSql = " values(" + project.getString("id") + ",now()," ;
				if(project.getInteger("dr") == 1){
					valueSql +="3";
				}else {
					valueSql +="1";
				}
				valueSql +=",'" + project.getString("id") + "', ";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(project.getString(itemCode))) {
						if("planStartDate".equals(modelItem.getItemCode()) || "planEndDate".equals(modelItem.getItemCode()) ){
							SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
							valueSql += "'" + format.format(project.getDate(modelItem.getItemCode()))  + "',";
						}else {
							valueSql += "'" + (project.getString(itemCode)!=null?project.getString(itemCode):"") + "',";
						}
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
		}
	}


	/**
	 * 供应商
	 *
	 * @return
	 */
	@RequestMapping(value = "/supplier")
	@ResponseBody
	public CommonResponse<String> syncSupplier(HttpServletRequest request) {
		String syncMode = request.getParameter("syncMode"); //full or increment
		logger.info(">>>>{}>>>>郑州一建 同步供应商数据start...syncMode = {}", getDateTime(),syncMode);
		String syncUrl = baseHost+"ejc-share-web/zzyj/mdm/supplier/sync";
		if(StringUtils.isNotBlank(syncMode)) {
			syncUrl += "?syncMode="+syncMode;
		}else{
			syncUrl += "?syncMode=increment";
		}
		try {
			QueryParam param = new QueryParam();
			boolean has = true;
			int pageSize = 500;
			int pageNum = 1;
			while (has){
				param.setPageSize(pageSize);
				param.setPageIndex(pageNum);
				String resp = HttpTookitZzyj.postJson(syncUrl, JSONObject.toJSONString(param));
				logger.info(">>>>{}>>>>郑州一建 同步供应商数据pageNum={}...syncUrl = {}", getDateTime(),pageNum,syncUrl);
				if(StringUtils.isNotEmpty(resp)){
					JSONObject r = JSONObject.parseObject(resp);
					if(r.getInteger("code") == 0 && r.get("data")!=null && r.getJSONArray("data").size()>0){
						JSONArray supplierList = r.getJSONArray("data");
						saveOrUpdateSupplier(supplierList);
						pageNum ++;
					}else {
						has = false;
					}
				}else {
					has = false;
				}
			}

		}catch (Exception e){
			e.printStackTrace();
			logger.error(">>>>郑州一建同步 供应商报错---------",e);
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步 供应商执行完毕!");
	}

	private void saveOrUpdateSupplier(JSONArray supplierList){
		QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
		masterDataModelWrapper.eq("model_code", "suppliermodel");
		DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
		// 主模型字段
		QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
		masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
		List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

		for (int i = 0; i < supplierList.size(); i++) {
			JSONObject project = supplierList.getJSONObject(i);
			JSONObject proObj = dataModelItemService.queryDataBySourceId("suppliermodel", project.getString("id"));
			if(proObj == null && project.getInteger("dr") == 1) {
				continue;
			}
			String executeSql = "";
			if(proObj!=null){//修改
				executeSql += "update suppliermodel set _last_update_time = now(),";
				if(project.getInteger("dr") == 1){
					executeSql +="_data_type=3,";
				}else {
					executeSql +="_data_type=2,";
				}
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(StringUtils.isNotBlank(project.getString(modelItem.getItemCode()))) {
						if("registTime".equals(modelItem.getItemCode()) || "blTime".equals(modelItem.getItemCode()) ){
							SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
							executeSql += "`" + modelItem.getItemCode() + "`='" + format.format(project.getDate(modelItem.getItemCode())) + "',";
						}else if("insideOrg".equals(modelItem.getItemCode())){
							executeSql += "`" + modelItem.getItemCode() + "`='" + (project.getBoolean("insideOrg")?"内部单位":"外部单位") + "',";
						}else if("grade".equals(modelItem.getItemCode())){
							executeSql += "`" + modelItem.getItemCode() + "`='" + project.getString("gradeName") + "',";
						}else if("supplierFlag".equals(modelItem.getItemCode())) {
							String supplierFlag = project.getString("supplierFlag");
							if("1".equals(supplierFlag)) {
								executeSql += "`" + modelItem.getItemCode() + "`='供应商',";
							}else if("2".equals(supplierFlag)) {
								executeSql += "`" + modelItem.getItemCode() + "`='客户',";
							}else if("3".equals(supplierFlag)) {
								executeSql += "`" + modelItem.getItemCode() + "`='客商',";
							}
						}else {
							executeSql += "`" + modelItem.getItemCode() + "`='" + (project.getString(modelItem.getItemCode())!=null?project.getString(modelItem.getItemCode()):"") + "',";
						}
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + project.getString("id") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}else {//新增
				executeSql = "insert into suppliermodel";
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
				String valueSql = " values(" + project.getString("id") + ",now()," ;
				if(project.getInteger("dr") == 1){
					valueSql +="3";
				}else {
					valueSql +="1";
				}
				valueSql +=",'" + project.getString("id") + "', ";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";
					if(StringUtils.isNotBlank(project.getString(itemCode))) {
						if("registTime".equals(modelItem.getItemCode()) || "blTime".equals(modelItem.getItemCode()) ){
							SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
							valueSql += "'" + format.format(project.getDate(modelItem.getItemCode()))  + "',";
						}else if("insideOrg".equals(modelItem.getItemCode())){
							valueSql += "'" + (project.getBoolean("insideOrg")?"内部单位":"外部单位")  + "',";
						}else if("grade".equals(modelItem.getItemCode())){
							valueSql += "'" + project.getString("gradeName")  + "',";
						}else if("supplierFlag".equals(modelItem.getItemCode())) {
							String supplierFlag = project.getString("supplierFlag");
							if("1".equals(supplierFlag)) {
								valueSql += "'供应商',";
							}else if("2".equals(supplierFlag)) {
								valueSql += "'客户',";
							}else if("3".equals(supplierFlag)) {
								valueSql += "'客商',";
							}
						}else {
							valueSql += "'" + (project.getString(itemCode)!=null?project.getString(itemCode):"") + "',";
						}
					}else{
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
		}
	}


	/**
	 * 客户
	 *
	 * @return
	 */
	@RequestMapping(value = "/customer")
	@ResponseBody
	public CommonResponse<String> syncCustomer(HttpServletRequest request) {
		logger.info(">>>>{}>>>>郑州一建 同步客户数据start...", getDateTime());
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步 客户执行完毕!");
	}
	
	private Boolean isUpdate(JSONObject currentObj, JSONObject uniqueBean) {
		boolean updateFlag = false;
		if(StringUtils.isNotBlank(currentObj.getString("supplierCode")) && !currentObj.getString("supplierCode").equals(uniqueBean.getString("supplierCode"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("supplierName")) && !currentObj.getString("supplierName").equals(uniqueBean.getString("supplierName"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("customerCode")) && !currentObj.getString("customerCode").equals(uniqueBean.getString("customerCode"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("customerName")) && !currentObj.getString("customerName").equals(uniqueBean.getString("customerName"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("socialCreditCode")) && !currentObj.getString("socialCreditCode").equals(uniqueBean.getString("socialCreditCode"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("bankAccount")) && !currentObj.getString("bankAccount").equals(uniqueBean.getString("bankAccount"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("bankName")) && !currentObj.getString("bankName").equals(uniqueBean.getString("bankName"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("openBankCode")) && !currentObj.getString("openBankCode").equals(uniqueBean.getString("openBankCode"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("openBankName")) && !currentObj.getString("openBankName").equals(uniqueBean.getString("openBankName"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("bankTypeCode")) && !currentObj.getString("bankTypeCode").equals(uniqueBean.getString("bankTypeCode"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("bankTypeName")) && !currentObj.getString("bankTypeName").equals(uniqueBean.getString("bankTypeName"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("address")) && !currentObj.getString("address").equals(uniqueBean.getString("address"))) {
			updateFlag = true;
		}
		if(!updateFlag && StringUtils.isNotBlank(currentObj.getString("defaultFlag")) && !currentObj.getString("defaultFlag").equals(uniqueBean.getString("defaultFlag"))) {
			updateFlag = true;
		}
		return updateFlag;
	}
	
	@RequestMapping(value = "/bankInfos")
	@ResponseBody
	public CommonResponse<String> syncbankInfos(HttpServletRequest request) {
		String syncMode = request.getParameter("syncMode"); //full or increment
		logger.info(">>>>{}>>>>郑州一建 同步银行数据start...syncMode={}", getDateTime(),syncMode);
		String syncUrl = baseHost+"ejc-share-web/zzyj/mdm/bank/sync";
		if(StringUtils.isNotBlank(syncMode)) {
			syncUrl += "?syncMode="+syncMode;
		}else{
			syncUrl += "?syncMode=increment";
		}
		try {
			String resp = ReferHttpClientUtils.postByJson(syncUrl, null);
			logger.info(">>>>>>>>银行档案 >>>{}", resp);
			if(StringUtils.isNotEmpty(resp)){
				JSONObject r = JSONObject.parseObject(resp);
				if(r.getInteger("code") == 0 && r.get("data")!=null && r.getJSONArray("data").size()>0){
					JSONArray bankList = r.getJSONArray("data");
					if(bankList != null && bankList.size() > 0) {
						for(int i=0;i<bankList.size();i++) {
							JSONObject bankObj = bankList.getJSONObject(i);
							String sourceId = bankObj.getString("id");
							JSONObject uniqueBean = dataModelItemService.queryDataBySourceId("bankmodel", sourceId);
							if(uniqueBean ==null && "del".equals(bankObj.getString("dataState"))) {
								continue;
							}
							if(uniqueBean != null) { //修改或删除
								if("del".equals(bankObj.getString("dataState"))) {
									String delSql = " update bankmodel set _last_update_time=now(), _data_type=3 where  _source_id = '"+sourceId+"'";
									dataModelItemService.executeUpdateSql(delSql);
								}else{
									//判断是不是当前是不是需要修改
									if(isUpdate(bankObj, uniqueBean)) {
										String updateSql = "update bankmodel set _last_update_time=now(),_data_type=2,"
												+ "supplierCode='"+(StringUtils.isNotBlank(bankObj.getString("supplierCode"))?bankObj.getString("supplierCode"):"")+"',"
												+ "supplierName='"+(StringUtils.isNotBlank(bankObj.getString("supplierName"))?bankObj.getString("supplierName"):"")+"',"
												+ "customerCode='"+(StringUtils.isNotBlank(bankObj.getString("customerCode"))?bankObj.getString("customerCode"):"")+"',"
												+ "customerName='"+(StringUtils.isNotBlank(bankObj.getString("customerName"))?bankObj.getString("customerName"):"")+"',"
												+ "socialCreditCode='"+(StringUtils.isNotBlank(bankObj.getString("socialCreditCode"))?bankObj.getString("socialCreditCode"):"")+"',"
												+ "bankAccount='"+(StringUtils.isNotBlank(bankObj.getString("bankAccount"))?bankObj.getString("bankAccount"):"")+"',"
												+ "bankName='"+(StringUtils.isNotBlank(bankObj.getString("bankName"))?bankObj.getString("bankName"):"")+"',"
												+ "openBankCode='"+(StringUtils.isNotBlank(bankObj.getString("openBankCode"))?bankObj.getString("openBankCode"):"")+"',"
												+ "openBankName='"+(StringUtils.isNotBlank(bankObj.getString("openBankName"))?bankObj.getString("openBankName"):"")+"',"
												+ "bankTypeCode='"+(StringUtils.isNotBlank(bankObj.getString("bankTypeCode"))?bankObj.getString("bankTypeCode"):"")+"',"
												+ "bankTypeName='"+(StringUtils.isNotBlank(bankObj.getString("bankTypeName"))?bankObj.getString("bankTypeName"):"")+"',"
												+ "address='"+(StringUtils.isNotBlank(bankObj.getString("address"))?bankObj.getString("address"):"")+"',"
												+ "defaultFlag='"+(StringUtils.isNotBlank(bankObj.getString("defaultFlag"))?bankObj.getString("defaultFlag"):"")+"'";
										updateSql += " where _source_id='"+sourceId+"'";
										dataModelItemService.executeUpdateSql(updateSql);
									}
								}
							}else{ //新增
								String supplierId = bankObj.getString("supplierId");
								String customerId = bankObj.getString("customerId");
								
								Long parentId = 0l;
								if(StringUtils.isNotBlank(supplierId)) {
									JSONObject supplierObj = dataModelItemService.queryDataBySourceId("suppliermodel", supplierId);
									if(supplierObj != null) {
										parentId = supplierObj.getLong("_master_data_id");
									}
								}
								if(parentId == 0l) {
									if(StringUtils.isNotBlank(customerId)) {
										JSONObject customerObj = dataModelItemService.queryDataBySourceId("suppliermodel", supplierId);
										if(customerObj != null) {
											parentId = customerObj.getLong("_master_data_id");
										}
									}
								}
								String insertSql = "insert into bankmodel(_master_data_id,_last_update_time,_data_type,_source_id,_parent_id,"
										+ "supplierId,customerId,supplierCode,"
										+ " supplierName,customerCode,customerName,socialCreditCode,bankAccount,"
										+ " bankName,openBankCode,openBankName,bankTypeCode,bankTypeName,address,defaultFlag) values ";
								insertSql += "("+bankObj.getString("id")+",now(),1,"+bankObj.getString("id")+","+parentId+
										","+(StringUtils.isNotBlank(bankObj.getString("supplierId"))?bankObj.getString("supplierId"):null)+
										","+(StringUtils.isNotBlank(bankObj.getString("customerId"))?bankObj.getString("customerId"):null)+
										",'"+(StringUtils.isNotBlank(bankObj.getString("supplierCode"))?bankObj.getString("supplierCode"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("supplierName"))?bankObj.getString("supplierName"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("customerCode"))?bankObj.getString("customerCode"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("customerName"))?bankObj.getString("customerName"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("socialCreditCode"))?bankObj.getString("socialCreditCode"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("bankAccount"))?bankObj.getString("bankAccount"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("bankName"))?bankObj.getString("bankName"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("openBankCode"))?bankObj.getString("openBankCode"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("openBankName"))?bankObj.getString("openBankName"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("bankTypeCode"))?bankObj.getString("bankTypeCode"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("bankTypeName"))?bankObj.getString("bankTypeName"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("address"))?bankObj.getString("address"):"")+
										"','"+(StringUtils.isNotBlank(bankObj.getString("defaultFlag"))?bankObj.getString("defaultFlag"):"")+"')";
								
								dataModelItemService.executeInsertSql(insertSql);
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info(">>>>" + getDateTime() + ">>>>郑州一建同步 银行账户 执行完毕!");
		return CommonResponse.success();
	}

	/**
	 * 收入合同
	 *
	 * @return
	 */
	@RequestMapping(value = "/inContract")
	@ResponseBody
	public CommonResponse<String> inContract(HttpServletRequest request) {
		return  syncContract(request,1,"收入合同");//1---收入
	}

	/**
	 * 支出合同
	 *
	 * @return
	 */
	@RequestMapping(value = "/outContract")
	@ResponseBody
	public CommonResponse<String> outContract(HttpServletRequest request) {
		return  syncContract(request,0,"支出合同");//0---支出
	}


	public synchronized CommonResponse<String> syncContract(HttpServletRequest request,int type,String name) {
		logger.info(">>>>{}>>>>郑州一建 同步"+name+"数据start...", getDateTime());
		try {

			String syncMode = request.getParameter("syncMode"); //full or increment
			String syncUrl = baseHost+"ejc-contractbase-web/contractPool/queryListJson";
			if(StringUtils.isNotBlank(syncMode)) {
				syncUrl += "?syncMode="+syncMode;
			}else{
				syncUrl += "?syncMode=increment";
			}

			QueryParam param = new QueryParam();
			param.getParams().put("contractProperty",new Parameter(QueryParam.EQ,type));
			boolean has = true;
			int pageSize = 500;
			int pageNum = 1;
			while (has){
				param.setPageSize(pageSize);
				param.setPageIndex(pageNum);
				String resp = ReferHttpClientUtils.postByJson(syncUrl, JSONObject.toJSONString(param));
				logger.info(">>>>>>>>郑州一建 同步"+name+"数据 "+pageNum+" >>>{}", resp);
				if(StringUtils.isNotEmpty(resp)){
					JSONObject r = JSONObject.parseObject(resp);
					if(r.getInteger("code") == 0 && r.get("data")!=null && r.getJSONObject("data").getJSONArray("records")!=null && r.getJSONObject("data").getJSONArray("records").size()>0){
						JSONArray contractList = r.getJSONObject("data").getJSONArray("records");
						saveOrUpdateContract(contractList,type==1?"incontractmodel":"outcontractmodel");
						pageNum ++;
					}else {
						has = false;
					}
				}else {
					has = false;
				}
			}
		}catch (Exception e){
			e.printStackTrace();
			logger.error(">>>>郑州一建同步 "+name+"报错---------",e);
		}
		return CommonResponse.success(">>>>" + getDateTime() + ">>>>郑州一建同步 "+name+"执行完毕!");
	}


	private void saveOrUpdateContract(JSONArray contractList,String type){
		QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
		masterDataModelWrapper.eq("model_code", type);
		DataModelEntity dataModelEntity = dataModelService.getOne(masterDataModelWrapper);
		// 主模型字段
		QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
		masterDataModelItemWrapper.eq("data_model_id", dataModelEntity.getId());
		List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);

		for (int i = 0; i < contractList.size(); i++) {
			JSONObject contract = contractList.getJSONObject(i);
			JSONObject contractObj = dataModelItemService.queryDataBySourceId(type, contract.getString("id"));
			if(contractObj == null && contract.getInteger("dr") == 1) {
				/** 过滤掉那些删除的并且没有在主数据出现过的*/
				continue;
			}
			String executeSql = "";
			if(contractObj!=null){//修改
				executeSql += "update "+type+" set _last_update_time = now(),";

				if(contract.getInteger("dr") == 1){
					executeSql +="_data_type=3,";
				}else {
					executeSql +="_data_type=2,";
				}
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					if(contract.getString(modelItem.getItemCode())!=null){
						executeSql += ("`" + modelItem.getItemCode() + "`='" + contract.getString(modelItem.getItemCode()) + "',");
					}else{
						executeSql += "`" + modelItem.getItemCode() + "`=null,";
					}
				}
				executeSql = executeSql.substring(0, executeSql.length() - 1);
				executeSql += " where _source_id='" + contract.getString("id") + "'";

				dataModelItemService.executeUpdateSql(executeSql);
			}else {//新增
				executeSql = "insert into "+type;
				String fieldSql = "(_master_data_id,_last_update_time,_data_type,_source_id, ";
				String valueSql = " values(" + contract.getString("id") + ",now(),1,'" + contract.getString("id") + "', ";
				for (DataModelItemEntity modelItem : dataModelItemEntities) {
					if ("_parent_id".equals(modelItem.getItemCode()) || "_master_data_id".equals(modelItem.getItemCode())) {
						continue;
					}
					String itemCode = modelItem.getItemCode();
					fieldSql += "`" + itemCode + "`,";

					if(contract.getString(modelItem.getItemCode())!=null){
						valueSql += "'" + contract.getString(itemCode) + "',";
					} else {
						valueSql += "null,";
					}
				}
				fieldSql = fieldSql.substring(0, fieldSql.length() - 1);
				valueSql = valueSql.substring(0, valueSql.length() - 1);
				fieldSql = fieldSql + ")";
				valueSql = valueSql + ")";

				executeSql = executeSql + fieldSql + valueSql;
				dataModelItemService.executeInsertSql(executeSql);
			}
		}
	}
}
