package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.foundation.mdm.bean.DataTransferLogEntity;
import com.ejianc.foundation.mdm.service.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataSubscribeEntity;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.utils.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("/datasub/")
public class DataSubscribeController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = -4419083871191610565L;
	
	@Autowired
	private IDataSubscribeService dataSubscribeService;
	@Autowired
	private IThirdSystemService thirdSystemService;
	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;
	@Autowired
	private IDataTransferLogService dataTransferLogService;

	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<DataSubscribeEntity>> pageList(@RequestBody QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		IPage<DataSubscribeEntity> pageData = dataSubscribeService.queryPage(queryParam);
		return CommonResponse.success(pageData);
	}
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody DataSubscribeEntity saveData) {
		QueryWrapper<DataSubscribeEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("subscribe_code", saveData.getSubscribeCode());
		DataSubscribeEntity dataSubscribeEntity = dataSubscribeService.getOne(queryWrapper);
		
		QueryWrapper<DataSubscribeEntity> dataSubWrapper = new QueryWrapper<>();
		dataSubWrapper.eq("data_model_id", saveData.getDataModelId());
		dataSubWrapper.eq("third_system_id", saveData.getThirdSystemId());
		List<DataSubscribeEntity> existDataSubList = dataSubscribeService.list(dataSubWrapper);
		
		if(saveData.getId() != null && saveData.getId()  > 0) {
			if(dataSubscribeEntity != null && !dataSubscribeEntity.getId().equals(saveData.getId())) {
				return CommonResponse.error("编码与【"+dataSubscribeEntity.getSubscribeName()+"】重复!");
			}
			DataSubscribeEntity uniqueBean = dataSubscribeService.getById(saveData.getId());
				
			if(!uniqueBean.getDataModelId().equals(saveData.getDataModelId()) && (existDataSubList != null && existDataSubList.size() > 0)) {
				return CommonResponse.error("系统【"+saveData.getThirdSystemName()+"】下该数据模型已经创建了， 不允许创建!");
			}
			
			uniqueBean.setDataModelId(saveData.getDataModelId());
			uniqueBean.setDataModelName(saveData.getDataModelName());
			uniqueBean.setSubscribeCode(saveData.getSubscribeCode());
			uniqueBean.setSubscribeName(saveData.getSubscribeName());
			uniqueBean.setEnableFlag(saveData.getEnableFlag());
			
			dataSubscribeService.saveOrUpdate(uniqueBean);
			
			return CommonResponse.success("修改成功");
		}else{
			if(dataSubscribeEntity != null) {
				return CommonResponse.error("编码与【"+dataSubscribeEntity.getSubscribeName()+"】重复!");
			}
			if(existDataSubList != null && existDataSubList.size() > 0) {
				return CommonResponse.error("系统【"+saveData.getThirdSystemName()+"】下该数据模型已经创建了， 不允许创建!");
			}
			saveData.setId(IdWorker.getId());
			dataSubscribeService.saveOrUpdate(saveData);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DataSubscribeEntity> queryDetail(@RequestParam Long id) {
		DataSubscribeEntity uniqueBean = dataSubscribeService.getById(id);
		return CommonResponse.success(uniqueBean);
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		dataSubscribeService.removeById(id);
		return CommonResponse.success();
	}
	
	public String getDateTime() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return format.format(new Date());
	}
	
	@RequestMapping(value = "/sync/pushdata")
	@ResponseBody
	public CommonResponse<String> pushDataToTargetSystem() {
		logger.info(">>>>{}>>>>主数据系统定时推送数据start...", getDateTime());
		
		//1. 先查出所有消费系统
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.in("system_type", "2,3");
		List<ThirdSystemEntity> thirdSystemEntities = thirdSystemService.list(thirdSystemWrapper);
		if(thirdSystemEntities != null && thirdSystemEntities.size() > 0) {
			for(ThirdSystemEntity thirdSystemEntity:thirdSystemEntities) {
				String pushDataUrl = thirdSystemEntity.getServiceUrl();
				if(StringUtils.isNotBlank(pushDataUrl)) {
					//2. 查出所有消费系统订阅功能
					QueryWrapper<DataSubscribeEntity> dataSubWrapper = new QueryWrapper<>();
					dataSubWrapper.eq("third_system_id", thirdSystemEntity.getId());
					dataSubWrapper.eq("enable_flag", 1);
					List<DataSubscribeEntity> dataSubEntities = dataSubscribeService.list(dataSubWrapper);
					if(dataSubEntities != null && dataSubEntities.size() > 0) {
						if(StringUtils.isNotBlank(pushDataUrl)) {
							for(DataSubscribeEntity dataSubscribeEntity:dataSubEntities) {
								Long dataModelId = dataSubscribeEntity.getDataModelId();
								
								DataModelEntity dataModelEntity = dataModelService.getById(dataModelId);
								
								Map<String, Object> modelItemMap = new HashMap<String, Object>();
								modelItemMap.put("tableName", dataModelEntity.getModelCode());
								modelItemMap.put("dataState", 0);

								Long resultDataListCount = dataModelItemService.queryMdmDataCount(modelItemMap);
								for(Integer i=0; i <= (resultDataListCount/500); i++){
									Integer pageIndex = i * 500;
									Integer pageSize = (i+1) * 500;
									modelItemMap.put("pageIndex", pageIndex);
									modelItemMap.put("pageSize", pageSize);
									List<JSONObject> resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
									pushAAndDealData(resultDataList, dataModelEntity.getModelCode(), pushDataUrl, thirdSystemEntity.getId());
								}
							}
						}
					}
				}
			}
		}
		return CommonResponse.success();
		
	}

	//具体推送数据+处理返回数据的状态+更新数据日志
	private void pushAAndDealData (List<JSONObject> resultDataList, String modelCode, String pushDataUrl, Long thirdSystemId){
		if(resultDataList != null && resultDataList.size() > 0) {
			JSONObject paramJsonObject = new JSONObject();
			paramJsonObject.put(modelCode, resultDataList);

			String responseStr = "";
			try {
				DataTransferLogEntity entity = new DataTransferLogEntity();
				entity.setThirdSystemId(thirdSystemId);
				entity.setCallType("pushdata");
				entity.setReqTime(new Date());
				entity.setReqParams(JSONObject.toJSONString(paramJsonObject));
				entity.setCallResp(responseStr);
				entity.setRespState("failed");
				entity.setId(IdWorker.getId());
				dataTransferLogService.saveOrUpdate(entity, false);

				logger.error("---------主数据推送数据调用第三方接口开始---------");
				logger.error("url:{}",pushDataUrl);
				logger.error("参数:{}",paramJsonObject);
				responseStr = HttpTookit.postJson(pushDataUrl, JSONObject.toJSONString(paramJsonObject));
				logger.error("---------主数据推送数据调用第三方接口结果：{}",responseStr);
				entity.setCallResp(responseStr);
				entity.setRespState("ok");
				dataTransferLogService.saveOrUpdate(entity, false);
				if(StringUtils.isNotBlank(responseStr)) {
					JSONObject backJsonObject = JSONObject.parseObject(responseStr);
					if("0".equals(backJsonObject.getString("code"))) {
						JSONArray backDataArr = backJsonObject.getJSONArray("data");

						StringBuffer dataItemSucPkIdBf = new StringBuffer();
						if(backDataArr != null && backDataArr.size() > 0) {
							for(int i=0;i<backDataArr.size();i++) {
								JSONObject backDataObj = backDataArr.getJSONObject(i);
								if("1".equals(backDataObj.getString("state"))) {
									dataItemSucPkIdBf.append(backDataObj.getString("mastDataId")).append(",");
								}
							}

							if(StringUtils.isNotBlank(dataItemSucPkIdBf)) {
								String dataItemSucPkIdStr = dataItemSucPkIdBf.substring(0, dataItemSucPkIdBf.length()-1);

								Map<String, Object> updateStateMap = new HashMap<>();
								updateStateMap.put("tableName", modelCode);
								updateStateMap.put("dataItemSucPkIdStr", dataItemSucPkIdStr);
								dataModelItemService.updateDataItemState(updateStateMap);
							}
						}
					}
				}

			} catch (Exception e) {
				logger.error("主数据推送数据失败，错误:{}",e);
				logger.error("主数据推送数据失败,地址：{},数据内容：{}",pushDataUrl,responseStr);
			}
		}
	}
}
