/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bulidMaterialMdm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadProjectEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadRecordEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialProjectEntity;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.mapper.ProjectMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IProjectService;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.vo.ProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectService")
public class ProjectService
implements IProjectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemRequestService requestService;
    @Autowired
    private ProjectMapper mapper;
    @Autowired
    private OrgMapper orgMapper;

    @Override
    public JSONObject insertProjectInfo(ProjectVO projectVO) {
        if (projectVO.getDescription() == null) {
            throw new BusinessException("\u9879\u76ee\u63cf\u8ff0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        if (projectVO.getName() == null) {
            throw new BusinessException("\u9879\u76ee\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectVO));
        String responseBody = this.requestService.sendPostRequest("project/add", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getInteger("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public JSONObject updateProjectInfo(ProjectVO projectVO) {
        if (projectVO.getDescription() == null) {
            throw new BusinessException("\u9879\u76ee\u63cf\u8ff0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        if (projectVO.getName() == null) {
            throw new BusinessException("\u9879\u76ee\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        if (projectVO.getProjectId() == null) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectVO));
        String responseBody = this.requestService.sendPostRequest("project/update", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getInteger("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public List<ProjectVO> selectProjectInfo() {
        String url = "project/list";
        JSONObject param = new JSONObject();
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        List orgVO = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        this.logger.info(jsonObject.getString("object"));
        orgVO = JSONObject.parseArray((String)jsonObject.getString("object"), ProjectVO.class);
        return orgVO;
    }

    @Override
    public ProjectVO selectProjectInfoById(Integer departmentId) {
        String url = "project/getProject";
        JSONObject param = new JSONObject();
        if (departmentId != null) {
            param.put("projectId", (Object)departmentId);
        }
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        ProjectVO orgVO = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        orgVO = (ProjectVO)JSONObject.parseObject((String)jsonObject.getString("object"), ProjectVO.class);
        return orgVO;
    }

    @Override
    public JSONObject deleteProjectInfo(Integer departmentId) {
        if (departmentId == null) {
            throw new BusinessException("\u90e8\u95e8id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        if (departmentId != null) {
            param.put("departmentId", (Object)departmentId);
        }
        String responseBody = this.requestService.sendPostRequest("department/delete/", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        message = code == 0 ? jsonObject.getString("object") + "" : jsonObject.getString("message");
        return jsonObject;
    }

    @Override
    public String projectInfoSyncFirst() {
        this.logger.info("\u7b51\u6750\u7f51\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5f00\u59cb---------------->");
        int page = 0;
        boolean flag = true;
        while (flag) {
            List<MadProjectEntity> todayUpdateData = this.mapper.selectWithPage(page * 100);
            this.logger.info("\u672c\u6b21\u540c\u6b65\u9879\u76ee\u5171{}\u4e2a---------------->", (Object)todayUpdateData.size());
            if (todayUpdateData != null && todayUpdateData.size() > 0) {
                for (MadProjectEntity todayUpdateDatum : todayUpdateData) {
                    Integer materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getProjectDepartmentId());
                    if (materialIdByMdmId != null) {
                        MadRecordEntity entity;
                        ProjectVO projectVO = new ProjectVO();
                        projectVO.setDescription(todayUpdateDatum.getName());
                        projectVO.setName(todayUpdateDatum.getName());
                        projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                        projectVO.setAddress(Arrays.asList("\u6cb3\u5357", "\u90d1\u5dde\u5e02", "\u5c1a\u8d24\u8857"));
                        JSONObject jsonObject = this.insertProjectInfo(projectVO);
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {
                            this.logger.info("\u7b51\u6750\u7f51\u65b0\u589e\u6210\u529f\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            Integer materialId = jsonObject.getInteger("object");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u9879\u76ee", 1, "");
                            this.mapper.insertSendRecord(entity);
                            MaterialProjectEntity materialOrgEntity = new MaterialProjectEntity();
                            materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                            materialOrgEntity.setProjectId(materialId);
                            materialOrgEntity.setDataType(1);
                            materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                            materialOrgEntity.setAddressStr("");
                            materialOrgEntity.setDescription(todayUpdateDatum.getName());
                            materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                            materialOrgEntity.setLastUpdateTime(new Date());
                            this.mapper.insertOrgInfo(materialOrgEntity);
                        } else {
                            String message = jsonObject.getString("message");
                            this.logger.info("\u7b51\u6750\u7f51\u65b0\u589e\u5931\u8d25\uff0cmessage\uff1a{}", (Object)message);
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u9879\u76ee", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    } else {
                        this.logger.error("\u7b51\u6750\u7f51\u9879\u76ee\u65b0\u589e\u7236\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0\uff1a{},\u9879\u76ee\u4e3b\u6570\u636eid:{}", (Object)todayUpdateDatum.getOrgname(), (Object)todayUpdateDatum.getMasterDataId());
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                flag = false;
            }
            ++page;
        }
        return "\u540c\u6b65\u6210\u529f\uff01";
    }

    @Override
    public String projectInfoSync() {
        this.logger.info("\u7b51\u6750\u7f51\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5f00\u59cb---------------->");
        List<MadProjectEntity> todayUpdateData = this.mapper.getTodayUpdateData();
        this.logger.info("\u672c\u6b21\u540c\u6b65\u9879\u76ee\u5171{}\u4e2a---------------->", (Object)todayUpdateData.size());
        if (todayUpdateData != null) {
            for (MadProjectEntity todayUpdateDatum : todayUpdateData) {
                MaterialProjectEntity materialOrgEntity;
                MadRecordEntity entity;
                Integer materialIdByMdmId;
                if (todayUpdateDatum.getDataType() == 1) {
                    materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getProjectDepartmentId());
                    if (materialIdByMdmId != null) {
                        this.logger.info("\u7b51\u6750\u7f51\u9879\u76ee\u4fe1\u606f\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                        ProjectVO projectVO = new ProjectVO();
                        projectVO.setDescription(todayUpdateDatum.getName());
                        projectVO.setName(todayUpdateDatum.getName());
                        projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                        projectVO.setAddress(Arrays.asList("\u6cb3\u5357", "\u90d1\u5dde\u5e02", "\u5c1a\u8d24\u8857"));
                        JSONObject jsonObject = this.insertProjectInfo(projectVO);
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {
                            Integer materialId = jsonObject.getInteger("object");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u9879\u76ee", 1, "");
                            this.mapper.insertSendRecord(entity);
                            materialOrgEntity = new MaterialProjectEntity();
                            materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                            materialOrgEntity.setProjectId(materialId);
                            materialOrgEntity.setDataType(1);
                            materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                            materialOrgEntity.setAddressStr("");
                            materialOrgEntity.setDescription(todayUpdateDatum.getName());
                            materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                            materialOrgEntity.setLastUpdateTime(new Date());
                            this.mapper.insertOrgInfo(materialOrgEntity);
                        } else {
                            String message = jsonObject.getString("message");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u9879\u76ee", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    } else {
                        this.logger.error("\u7b51\u6750\u7f51\u9879\u76ee\u65b0\u589e\u7236\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0\uff1a{},\u9879\u76ee\u4e3b\u6570\u636eid:{}", (Object)todayUpdateDatum.getOrgname(), (Object)todayUpdateDatum.getMasterDataId());
                    }
                } else if (todayUpdateDatum.getDataType() == 2) {
                    materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getProjectDepartmentId());
                    if (materialIdByMdmId != null) {
                        MadRecordEntity entity2;
                        String message;
                        Integer code;
                        JSONObject jsonObject;
                        ProjectVO projectVO;
                        Integer materialProjectId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                        if (materialProjectId != null) {
                            this.logger.info("\u7b51\u6750\u7f51\u9879\u76ee\u4fe1\u606f\u4fee\u6539\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            projectVO = new ProjectVO();
                            projectVO.setDescription(todayUpdateDatum.getName());
                            projectVO.setName(todayUpdateDatum.getName());
                            projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                            projectVO.setProjectId(materialProjectId);
                            projectVO.setAddress(Arrays.asList("\u6cb3\u5357", "\u90d1\u5dde\u5e02", "\u5c1a\u8d24\u8857"));
                            jsonObject = this.updateProjectInfo(projectVO);
                            code = jsonObject.getInteger("code");
                            if (code == 0) {
                                entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u9879\u76ee", 1, "");
                                this.mapper.insertSendRecord(entity);
                                materialOrgEntity = new MaterialProjectEntity();
                                materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                                materialOrgEntity.setProjectId(materialProjectId);
                                materialOrgEntity.setDataType(2);
                                materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                                materialOrgEntity.setDescription(todayUpdateDatum.getName());
                                materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                                materialOrgEntity.setLastUpdateTime(new Date());
                                this.mapper.updateOrgInfo(materialOrgEntity);
                            } else {
                                message = jsonObject.getString("message");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u9879\u76ee", 2, message);
                                this.mapper.insertSendRecord(entity2);
                            }
                        } else {
                            this.logger.info("\u7b51\u6750\u7f51\u9879\u76ee\u4fe1\u606f\u4fee\u6539\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            projectVO = new ProjectVO();
                            projectVO.setDescription(todayUpdateDatum.getName());
                            projectVO.setName(todayUpdateDatum.getName());
                            projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                            projectVO.setAddress(Arrays.asList("\u6cb3\u5357", "\u90d1\u5dde\u5e02", "\u5c1a\u8d24\u8857"));
                            jsonObject = this.insertProjectInfo(projectVO);
                            code = jsonObject.getInteger("code");
                            if (code == 0) {
                                Integer materialId = jsonObject.getInteger("object");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u9879\u76ee", 1, "");
                                this.mapper.insertSendRecord(entity2);
                                MaterialProjectEntity materialOrgEntity2 = new MaterialProjectEntity();
                                materialOrgEntity2.setMdmId(todayUpdateDatum.getMasterDataId());
                                materialOrgEntity2.setLastUpdateTime(new Date());
                                materialOrgEntity2.setProjectId(materialId);
                                materialOrgEntity2.setDataType(1);
                                materialOrgEntity2.setProjectName(todayUpdateDatum.getName());
                                materialOrgEntity2.setAddressStr("");
                                materialOrgEntity2.setDescription(todayUpdateDatum.getName());
                                materialOrgEntity2.setOwnersStr(materialIdByMdmId + "");
                                this.mapper.insertOrgInfo(materialOrgEntity2);
                            } else {
                                message = jsonObject.getString("message");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u9879\u76ee", 2, message);
                                this.mapper.insertSendRecord(entity2);
                            }
                        }
                    } else {
                        this.logger.error("\u7b51\u6750\u7f51\u9879\u76ee\u4fee\u6539\u7236\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0\uff1a{},\u9879\u76ee\u4e3b\u6570\u636eid:{}", (Object)todayUpdateDatum.getOrgname(), (Object)todayUpdateDatum.getMasterDataId());
                    }
                } else if (todayUpdateDatum.getDataType() == 3) {
                    // empty if block
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

