package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.foundation.mdm.bean.HrLogEnyity;
import com.ejianc.foundation.mdm.service.IHrLogService;
import com.ejianc.foundation.mdm.vo.HrLogEnyityVO;

/**
 * 获取数据日志
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("hrLogEnyity")
public class HrLogController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IHrLogService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HrLogEnyityVO> saveOrUpdate(@RequestBody HrLogEnyityVO saveOrUpdateVO) {
    	HrLogEnyity entity = BeanMapper.map(saveOrUpdateVO, HrLogEnyity.class);
    	if(entity.getId() == null || entity.getId() == 0){
        }
    	service.saveOrUpdate(entity, false);
    	HrLogEnyityVO vo = BeanMapper.map(entity, HrLogEnyityVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HrLogEnyityVO> queryDetail(Long id) {
    	HrLogEnyity entity = service.selectById(id);
    	HrLogEnyityVO vo = BeanMapper.map(entity, HrLogEnyityVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
