package com.ejianc.foundation.mdm.utils;

import java.net.URLEncoder;

/**
 * @author songlx
 * @version 1.0
 * @description: 郑州一建hr系统同步组织\岗位\人员数据 同步配置信息
 * @date 2022/1/12
 */
public class ZzyjSyncConfig {

//type	："ORG" 代表机构，"HR"代表人员，"POST"代表岗位
    public static String ORG = "ORG";

    public static String HR = "HR";

    public static String POST = "POST";

    private String hrHost;

    private String sysFlag;

    private String sysEtoken;

    private String sys;


    public ZzyjSyncConfig() {
    }


    public ZzyjSyncConfig(Object hrHost, Object sysFlag, Object sysEtoken) {
        this.hrHost = String.valueOf(hrHost);
        this.sysFlag = String.valueOf(sysFlag);
        this.sysEtoken = String.valueOf(sysEtoken);
        this.sys = "ejc";
    }
    
    public ZzyjSyncConfig(Object hrHost, Object sysFlag, Object sysEtoken, Object sys) {
        this.hrHost = String.valueOf(hrHost);
        this.sysFlag = String.valueOf(sysFlag);
        this.sysEtoken = String.valueOf(sysEtoken);
        this.sys = String.valueOf(sys);
    }

    public String getOrgUrl() {
//        return hrHost + "/HrHttpService/getOrgInfo?sysEtoken=" + sysEtoken + "&sqlWhere=ejccs%3C%3E0";
        return hrHost + "/HrHttpService/getOrgInfo?sysEtoken=" + sysEtoken + "&sqlWhere=" + sys + "%3C%3E0";
    }


    public String getPostUrl() {
//        return hrHost + "/HrHttpService/getPostInfo?sysEtoken=" + sysEtoken + "&sqlWhere=ejccs%3C%3E0";
        return hrHost + "/HrHttpService/getPostInfo?sysEtoken=" + sysEtoken + "&sqlWhere=" + sys + "%3C%3E0";
    }


    public String getUserUrl() {
//        return hrHost + "/HrHttpService/getUserInfo?sysEtoken=" + sysEtoken + "&sqlWhere=ejccs%3C%3E0";
        return hrHost + "/HrHttpService/getUserInfo?sysEtoken=" + sysEtoken + "&sqlWhere=" + sys + "%3C%3E0";
    }
    
    public String getJobUrl() {
    	return hrHost + "/HrUserSubInfoService/getUserSubData?sysEtoken=" + sysEtoken;
    }




    public String getUpdateUrl(){
        return hrHost + "/HrHttpService/updInfoState";
    }

    public String getUpdateParam(String type, String jsonStr) {
//        return "sysEtoken=" + sysEtoken
//                + "&jsonStr=" + URLEncoder.encode(jsonStr)
//                + "&type=" + type
//                + "&sysFlag=EJCCS";
        return "sysEtoken=" + sysEtoken
        		+ "&jsonStr=" + URLEncoder.encode(jsonStr)
        		+ "&type=" + type
        		+ "&sysFlag=" + sysFlag;
    }

    public String getHrHost() {
        return hrHost;
    }

    public void setHrHost(String hrHost) {
        this.hrHost = hrHost;
    }

    public String getSysFlag() {
        return sysFlag;
    }

    public void setSysFlag(String sysFlag) {
        this.sysFlag = sysFlag;
    }

    public String getSysEtoken() {
        return sysEtoken;
    }

    public void setSysEtoken(String sysEtoken) {
        this.sysEtoken = sysEtoken;
    }

	public String getSys() {
		return sys;
	}

	public void setSys(String sys) {
		this.sys = sys;
	}
}
