package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.param.DeleteParam;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.MdmUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/mdmManage")
public class MdmManageController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;
	
	/**
	 * 根据查询条件查询列表-分发数据
	 * 
	 * @param listParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody Map<String,Object> param) {
		if(param.get("modelCode")==null){
			throw new BusinessException("未获取到模型编码参数");
		}
		if(param.get("pageIndex")==null){
			throw new BusinessException("未获取到页数");
		}
		if(param.get("pageSize")==null){
			throw new BusinessException("未获取到条数");
		}
		Long pageIndex = param.get("pageIndex")!=null?Long.parseLong(param.get("pageIndex").toString()):1;
		Long pageSize = param.get("pageSize")!=null?Long.parseLong(param.get("pageSize").toString()):10;
		
		JSONObject responseData = new JSONObject();
		//获取主模型
		QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
		masterDataModelWrapper.eq("model_code", param.get("modelCode"));
		List<DataModelEntity> masterDataModelEntities = dataModelService.list(masterDataModelWrapper);
		DataModelEntity masterDataModelEntity = masterDataModelEntities.get(0);
		
		QueryWrapper<DataModelItemEntity> masterDataModelItemWrapper = new QueryWrapper<>();
		masterDataModelItemWrapper.eq("data_model_id", masterDataModelEntity.getId());
		masterDataModelItemWrapper.orderByAsc("sequence");
		List<DataModelItemEntity> dataModelItemEntities = dataModelItemService.list(masterDataModelItemWrapper);
		
		Map<String, Object> modelItemMap = new HashMap<String, Object>();        
		long startLine = (pageIndex==null?0:pageIndex-1) * pageSize;
		modelItemMap.put("pageIndex", startLine);
		modelItemMap.put("pageSize", pageSize);
		String searchSql = "";
		modelItemMap.put("lastUpdateTimeDesc", "desc");
		if(param.get("params")!=null){
			JSONObject params = JSONObject.parseObject(param.get("params").toString());
			for(String key : params.keySet()){
				if(searchSql.length()>0){
					searchSql += " and " + key + " like '%"+params.getString(key)+"%'";
				}else{
					searchSql += " " + key + " like '%"+params.getString(key)+"%'";
				}
			}
		}
		if(StringUtils.isNotBlank(searchSql)) {
			modelItemMap.put("searchSql", searchSql);
		}
		modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
		
		List<JSONObject> resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
		Long dataTotal = dataModelItemService.queryMdmDataCount(modelItemMap);
		
		MdmUtils.parseJSONObject(resultDataList, dataModelItemEntities);
		
		
		if(resultDataList != null && resultDataList.size() > 0) {
			QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
			childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
			List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
			if(childDataModelList != null && childDataModelList.size() > 0) {
				for(DataModelEntity childModel:childDataModelList) {
					//child模型项
					QueryWrapper<DataModelItemEntity> childDataModelItemWrapper = new QueryWrapper<>();
					childDataModelItemWrapper.eq("data_model_id", childModel.getId());
					List<DataModelItemEntity> childDataModelItemEntities = dataModelItemService.list(childDataModelItemWrapper);
					
					for(JSONObject masterData:resultDataList) {
						Map<String, Object> childParamMap = new HashMap<String, Object>();
						childParamMap.put("parentId", masterData.get("_master_data_id").toString());
						childParamMap.put("tableName", childModel.getModelCode());
						List<JSONObject> childDataList = dataModelItemService.queryMdmChildDataList(childParamMap);
						
						MdmUtils.parseJSONObject(childDataList, childDataModelItemEntities);
						masterData.put(childModel.getModelCode(), childDataList);
					}
				}
			}
		}

		responseData.put("current", pageIndex);
		responseData.put("size", pageSize);
		responseData.put("total", dataTotal);
		responseData.put("records", resultDataList);
		responseData.put("modelItems", dataModelItemEntities);
		
		return CommonResponse.success(responseData);
	}
	
	
	/**
	 * 删除主数据
	 * 
	 * @param deleteParam
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/deleteMdmData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteMdmData(@RequestBody DeleteParam deleteParam, HttpServletRequest request) {
		
		//获取主模型
		QueryWrapper<DataModelEntity> masterDataModelWrapper = new QueryWrapper<>();
		masterDataModelWrapper.eq("model_code", deleteParam.getDataModelCode());
		List<DataModelEntity> masterDataModelEntities = dataModelService.list(masterDataModelWrapper);
		DataModelEntity masterDataModelEntity = masterDataModelEntities.get(0);
		
		List<String> mdmIds = deleteParam.getMdmIds();
		String mdmIdStr = "";
		List<JSONObject> resultDataList = null;
		if(mdmIds != null && mdmIds.size() > 0) {
			for(String mdmId:mdmIds) {
				mdmIdStr += "'"+mdmId + "',";
			}
			if(StringUtils.isNotBlank(mdmIdStr)) {
				mdmIdStr = mdmIdStr.substring(0, mdmIdStr.length()-1);
			}
			Map<String, Object> modelItemMap = new HashMap<String, Object>();
			modelItemMap.put("mdmIdStr", mdmIdStr);
			modelItemMap.put("tableName", masterDataModelEntity.getModelCode());
			modelItemMap.put("pageIndex", -1);
			resultDataList = dataModelItemService.queryMdmDataList(modelItemMap);
			
			if(resultDataList != null && resultDataList.size() > 0) {
				QueryWrapper<DataModelEntity> childDataModelWrapper = new QueryWrapper<>();
				childDataModelWrapper.eq("parent_id", masterDataModelEntity.getId());
				List<DataModelEntity> childDataModelList = dataModelService.list(childDataModelWrapper);
				if(childDataModelList != null && childDataModelList.size() > 0) {
					for(DataModelEntity childModel:childDataModelList) {
						for(JSONObject masterData:resultDataList) {
							Map<String, Object> childParamMap = new HashMap<String, Object>();
							childParamMap.put("parentId", masterData.get("id").toString());
							childParamMap.put("tableName", childModel.getModelCode());
							
							dataModelItemService.deleteChildMdmData(childParamMap);
						}
					}
				}
			}
			dataModelItemService.deleteMasterMdmData(modelItemMap);
			
			return CommonResponse.success();
		}else{
			throw new BusinessException("主数据ids不正确");
		}
	}
}
