/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.ThirdSystemEntity;
import com.ejianc.foundation.mdm.service.IThirdSystemService;
import com.ejianc.foundation.mdm.vo.ThirdSystemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/thirdsys/"})
public class ThirdSystemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IThirdSystemService thirdSystemService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ThirdSystemVO thirdSystemVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"system_code", (Object)thirdSystemVo.getSystemCode());
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)queryWrapper));
        if (thirdSystemVo.getId() != null && thirdSystemVo.getId() > 0L) {
            if (thirdSystemEntity != null && !thirdSystemEntity.getId().equals(thirdSystemVo.getId())) {
                return CommonResponse.error((String)("\u4fee\u6539\u5931\u8d25\uff1a\u7cfb\u7edf\u7f16\u7801\u4e0e\u3010" + thirdSystemEntity.getSystemName() + "\u3011\u91cd\u590d\uff01"));
            }
            ThirdSystemEntity uniqueBean = (ThirdSystemEntity)((Object)this.thirdSystemService.getById(thirdSystemVo.getId()));
            uniqueBean.setSystemType(thirdSystemVo.getSystemType());
            uniqueBean.setSystemCode(thirdSystemVo.getSystemCode());
            uniqueBean.setSystemName(thirdSystemVo.getSystemName());
            uniqueBean.setServiceUrl(thirdSystemVo.getServiceUrl());
            uniqueBean.setEnableFlag(thirdSystemVo.getEnableFlag());
            uniqueBean.setSequence(thirdSystemVo.getSequence());
            this.thirdSystemService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (thirdSystemEntity != null) {
            return CommonResponse.error((String)("\u4fee\u6539\u5931\u8d25\uff1a\u7cfb\u7edf\u7f16\u7801\u4e0e\u3010" + thirdSystemEntity.getSystemName() + "\u3011\u91cd\u590d\uff01"));
        }
        ThirdSystemEntity saveBean = (ThirdSystemEntity)((Object)BeanMapper.map((Object)thirdSystemVo, ThirdSystemEntity.class));
        saveBean.setTicket(UUID.randomUUID().toString());
        this.thirdSystemService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ThirdSystemVO> queryDetail(@RequestParam Long id) {
        ThirdSystemEntity uniqueBean = (ThirdSystemEntity)((Object)this.thirdSystemService.getById(id));
        ThirdSystemVO thirdSystemVo = (ThirdSystemVO)BeanMapper.map((Object)((Object)uniqueBean), ThirdSystemVO.class);
        return CommonResponse.success((Object)thirdSystemVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.thirdSystemService.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ThirdSystemEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.thirdSystemService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/queryTree"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ThirdSystemEntity>> queryTree(@RequestBody JSONObject queryObject) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        String searchText = queryObject.getString("searchText");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryWrapper.like((Object)"system_name", (Object)searchText);
        }
        queryWrapper.orderByAsc((Object)"sequence");
        List dataList = this.thirdSystemService.list((Wrapper)queryWrapper);
        return CommonResponse.success((Object)dataList);
    }
}

