package com.ejianc.foundation.mdm.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_mdm_db_openapi")
public class DbOpenApiEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableField("data_source_id")
    private Long dataSourceId; //数据源Id
    @TableField("open_api_code")
    private String openApiCode; //openapi编码
    @TableField("open_api_name")
    public String openApiName; //openapi名称
    @TableField("open_api_param")
    private String openApiParam; //openapi参数 , 多个参数用逗号分隔
    @TableField("sequence")
    private Integer sequence; //排序
    @TableField("sql_content")
    private String sqlContent; //sql内容
    @TableField("remark")
    private String remark; //备注信息

    @TableField(exist = false)
    private String dataSourceName; //数据源名称
    @TableField(exist = false)
    private String accessTicket;

    public Long getDataSourceId() {
        return dataSourceId;
    }

    public void setDataSourceId(Long dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getOpenApiCode() {
        return openApiCode;
    }

    public void setOpenApiCode(String openApiCode) {
        this.openApiCode = openApiCode;
    }

    public String getOpenApiName() {
        return openApiName;
    }

    public void setOpenApiName(String openApiName) {
        this.openApiName = openApiName;
    }

    public String getOpenApiParam() {
        return openApiParam;
    }

    public void setOpenApiParam(String openApiParam) {
        this.openApiParam = openApiParam;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getSqlContent() {
        return sqlContent;
    }

    public void setSqlContent(String sqlContent) {
        this.sqlContent = sqlContent;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDataSourceName() {
        return dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getAccessTicket() {
        return accessTicket;
    }

    public void setAccessTicket(String accessTicket) {
        this.accessTicket = accessTicket;
    }
}
