package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataSourceSettingEntity;
import com.ejianc.foundation.mdm.service.IDataSourceSettingService;
import com.ejianc.foundation.mdm.utils.JdbcDataProvider;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.core.util.EnvironmentTools;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

@RestController
@RequestMapping("/dsSetting/")
public class DataSourceSettingController implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final String TEST_MYSQL_SQL = "select 1";
    private static final String TEST_ORACLE_SQL = "select 1 from dual";
    private static final String TEST_SQLSERVER_SQL = "select 1";

    @Autowired
    private IDataSourceSettingService dataSourceSettingService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Value("${refer.base-host:null}")
    private String baseHost;

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataSourceSettingEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        IPage<DataSourceSettingEntity> pageData = dataSourceSettingService.queryPage(queryParam);
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataSourceSettingEntity> queryDetail(@RequestParam Long id) {
        DataSourceSettingEntity uniqueBean = dataSourceSettingService.getById(id);
        return CommonResponse.success(uniqueBean);
    }

    @RequestMapping(value = "/testConnection", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> testConnection(@RequestParam Long id) {
        DataSourceSettingEntity uniqueBean = dataSourceSettingService.getById(id);
        uniqueBean.setDsPassword(DESUtils.decrypt(uniqueBean.getDsPassword()));

        Map<String, String> dataSourceMap = new HashMap<>();
        dataSourceMap.put("driver", uniqueBean.getDriverName());
        dataSourceMap.put("jdbcurl", uniqueBean.getDsUrl());
        dataSourceMap.put("username", uniqueBean.getDsUserName());
        dataSourceMap.put("password", uniqueBean.getDsPassword());
        dataSourceMap.put("pooled", "false");

        Map<String, String> query = new HashMap<>();
        if(uniqueBean.getDriverName().contains("mysql")) {
            query.put("sql", TEST_MYSQL_SQL);
        }

        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            boolean connectionFlag = jdbcDataProvider.testConnection();
            if(connectionFlag) {
                return CommonResponse.success("连接成功");
            }else{
                return CommonResponse.error("连接失败");
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        dataSourceSettingService.removeByIds(ids);
        return CommonResponse.success();
    }

    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DataSourceSettingEntity saveData) {
        if(saveData.getId() != null && saveData.getId()  > 0) {
            DataSourceSettingEntity uniqueBean = dataSourceSettingService.getById(saveData.getId());
            uniqueBean.setSourceName(saveData.getSourceName());
            uniqueBean.setDriverName(saveData.getDriverName());
            uniqueBean.setDsUrl(saveData.getDsUrl());
            uniqueBean.setDsUserName(saveData.getDsUserName());
            if(!saveData.getDsPassword().equals(uniqueBean.getDsPassword())) {
                uniqueBean.setDsPassword(DESUtils.encrypt(saveData.getDsPassword()));
            }
            dataSourceSettingService.saveOrUpdate(uniqueBean);
        }else{
            saveData.setDsPassword(DESUtils.encrypt(saveData.getDsPassword()));
            saveData.setAccessTicket(Base64.getEncoder().encodeToString(UUID.randomUUID().toString().replace("-", "").getBytes()));
            dataSourceSettingService.saveOrUpdate(saveData);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        String referBaseHost = "";
        if(StringUtils.isNotBlank(baseHost)&& !"null".equals(baseHost)){
            referBaseHost = baseHost;
        }else{
            referBaseHost = environmentTools.getBaseHost();
        }
        List<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();

        switch (refCode) {
            case "mdm_datasourcesetting_referList":
                refer.setRefCode("dsSetting");
                refer.setRefName("数据源配置");
                refer.setRefType("grid");
                refer.setDataurl(referBaseHost+"ejc-mdm-web/dsSetting/queryDsSettingRefList");
                refer.setIdField("id");
                refer.setCodeField("sourceName");
                refer.setNameField("sourceName");
                refer.setId(new Date().getTime());

                idHeader.setId(1l);
                idHeader.setName("主键");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(1);
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(2l);
                entityHeader.setName("数据源名称");
                entityHeader.setCode("sourceName");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(1);
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(3l);
                displayHeader.setName("驱动名称");
                displayHeader.setCode("driverName");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(1);
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(4l);
                entityFullHeader.setName("数据源地址");
                entityFullHeader.setCode("dsUrl");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(1);
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
                break;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", refer);
        return CommonResponse.success(refer);
    }

    @RequestMapping(value = "/queryDsSettingRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataSourceSettingEntity>> queryDsSettingRefList(@RequestParam(required = false) String condition,
            @RequestParam(required = false) String searchText,
            @RequestParam int pageSize,
            @RequestParam int pageNumber,
            @RequestParam(required=false) String relyCondition,
            @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        IPage<DataSourceSettingEntity> pageData = dataSourceSettingService.queryPage(queryParam);
        return CommonResponse.success("查询成功!", pageData);
    }
}
