package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.DataSourceSettingEntity;
import com.ejianc.foundation.mdm.bean.DbOpenApiEntity;
import com.ejianc.foundation.mdm.bean.DbOpenApiTransferLogEntity;
import com.ejianc.foundation.mdm.service.IDataSourceSettingService;
import com.ejianc.foundation.mdm.service.IDbOpenApiService;
import com.ejianc.foundation.mdm.service.IDbOpenApiTransferLogService;
import com.ejianc.foundation.mdm.utils.JdbcDataProvider;
import com.ejianc.foundation.mdm.utils.ProduceNumber;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DESUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping
public class DbOpenApiController implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    private IDbOpenApiService dbOpenApiService;
    @Autowired
    private IDataSourceSettingService dataSourceSettingService;
    @Autowired
    private IDbOpenApiTransferLogService dbOpenApiTransferLogService;

    @RequestMapping(value = "/dbOpenApi/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DbOpenApiEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        IPage<DbOpenApiEntity> pageData = dbOpenApiService.queryPage(queryParam);
        if(pageData != null && pageData.getRecords() != null) {
            for(DbOpenApiEntity dbOpenApiEntity : pageData.getRecords()) {
                DataSourceSettingEntity dataSourceSettingEntity = dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId());
                dbOpenApiEntity.setDataSourceName(dataSourceSettingEntity.getSourceName());
            }
        }
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value = "/dbOpenApi/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DbOpenApiEntity> queryDetail(@RequestParam Long id) {
        DbOpenApiEntity dbOpenApiEntity = dbOpenApiService.selectById(id);
        DataSourceSettingEntity dataSourceSettingEntity = dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId());
        dbOpenApiEntity.setDataSourceName(dataSourceSettingEntity.getSourceName());
        dbOpenApiEntity.setAccessTicket(dataSourceSettingEntity.getAccessTicket());
        return CommonResponse.success(dbOpenApiEntity);
    }

    @RequestMapping(value = "/dbOpenApi/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        dbOpenApiService.removeByIds(ids);
        return CommonResponse.success();
    }

    @RequestMapping(value = "/dbOpenApi/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DbOpenApiEntity saveData) {
        QueryWrapper<DbOpenApiEntity> queryWrapper = new QueryWrapper<>();
        if(saveData.getId() != null && saveData.getId() > 0) {
            DbOpenApiEntity uniqueBean = dbOpenApiService.selectById(saveData.getId());
            uniqueBean.setDataSourceId(saveData.getDataSourceId());
            if(!saveData.getOpenApiCode().equals(uniqueBean.getOpenApiCode())) {
                queryWrapper.eq("open_api_code", saveData.getOpenApiCode());
                queryWrapper.ne("id", saveData.getId());
                DbOpenApiEntity uniqueCodeBean = dbOpenApiService.getOne(queryWrapper);
                if(uniqueCodeBean != null) {
                    return CommonResponse.error("编码与【"+uniqueCodeBean.getOpenApiName()+"】重复!");
                }
                uniqueBean.setOpenApiCode(saveData.getOpenApiCode());
            }
            uniqueBean.setOpenApiName(saveData.getOpenApiName());
            uniqueBean.setOpenApiParam(saveData.getOpenApiParam());
            uniqueBean.setSequence(saveData.getSequence());
            uniqueBean.setSqlContent(saveData.getSqlContent());
            uniqueBean.setRemark(saveData.getRemark());
            dbOpenApiService.saveOrUpdate(uniqueBean);
        }else{
            saveData.setOpenApiCode(ProduceNumber.produce());
            queryWrapper.eq("open_api_code", saveData.getOpenApiCode());
            DbOpenApiEntity uniqueCodeBean = dbOpenApiService.getOne(queryWrapper);
            if(uniqueCodeBean != null) {
                return CommonResponse.error("编码与【"+uniqueCodeBean.getOpenApiName()+"】重复!");
            }
            dbOpenApiService.saveOrUpdate(saveData);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value = "/dbOpenApi/queryDbOpenLogList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DbOpenApiTransferLogEntity>> queryDbOpenLogList(@RequestBody QueryParam queryParam) {
        queryParam.getOrderMap().put("req_time", QueryParam.DESC);
        IPage<DbOpenApiTransferLogEntity> pageData = dbOpenApiTransferLogService.queryPage(queryParam);
        if(pageData != null && pageData.getRecords() != null) {
            for(DbOpenApiTransferLogEntity dbOpenApiTransferLogEntity : pageData.getRecords()) {
                DbOpenApiEntity dbOpenApiEntity = dbOpenApiService.selectById(dbOpenApiTransferLogEntity.getDbOpenapiId());
                dbOpenApiTransferLogEntity.setDbOpenApiName(dbOpenApiEntity.getOpenApiName());
            }
        }
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value = "/dbopenapi/query/{openApiCode}", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryOpenApiData(HttpServletRequest request, @PathVariable String openApiCode, @RequestBody JSONObject jsonObject) {
        String ticket = request.getHeader("ticket");
        if(StringUtils.isBlank(ticket)) {
            return CommonResponse.error("请求头中的ticket不能为空");
        }
        QueryWrapper<DbOpenApiEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("open_api_code", openApiCode);
        DbOpenApiEntity dbOpenApiEntity = dbOpenApiService.getOne(queryWrapper);
        if(dbOpenApiEntity == null) {
            return CommonResponse.error("未找到OpenCode： "+openApiCode+" 对应的开放接口！");
        }
        DataSourceSettingEntity dsSetting = dataSourceSettingService.getById(dbOpenApiEntity.getDataSourceId());
        if(!ticket.equals(dsSetting.getAccessTicket())) {
            return CommonResponse.error("ticket票据错误，不能访问该接口");
        }
        String queryParam = dbOpenApiEntity.getOpenApiParam();
        String sqlContent = dbOpenApiEntity.getSqlContent();
        if (StringUtils.isNotBlank(queryParam)) {
            String[] paramArr = queryParam.split(",");
            for (String param : paramArr) {
                if (!jsonObject.containsKey(param)) {
                    return CommonResponse.error("参数【" + param + "】未传入！");
                }
                String value = jsonObject.getString(param);
                if(value.toLowerCase().indexOf(";") >=0 || value.toLowerCase().indexOf("drop") >=0
                        || value.toLowerCase().indexOf("insert") >=0 || value.toLowerCase().indexOf("delete") >=0
                        || value.toLowerCase().indexOf("update") >=0) {
                    throw new BusinessException("参数中含有drop、insert、update、delete关键字。");
                }
                sqlContent = sqlContent.replaceAll("\\{"+param+"\\}", value);
            }
        }


        Map<String, String> dataSourceMap = new HashMap<>();
        dataSourceMap.put("driver", dsSetting.getDriverName());
        dataSourceMap.put("jdbcurl", dsSetting.getDsUrl());
        dataSourceMap.put("username", dsSetting.getDsUserName());
        dataSourceMap.put("password", DESUtils.decrypt(dsSetting.getDsPassword()));

        Map<String, String> query = new HashMap<>();
        query.put("sql", sqlContent);

        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        jdbcDataProvider.assignVal(dataSourceMap, query);
        List<JSONObject> records = jdbcDataProvider.getDataList();
        //记录日志
        new Thread(new Runnable() {
            @Override
            public void run() {
                DbOpenApiTransferLogEntity transferLog = new DbOpenApiTransferLogEntity();
                transferLog.setDbOpenapiId(dbOpenApiEntity.getId());
                transferLog.setReqTime(new Date());
                transferLog.setReqParams(jsonObject.toString());
                transferLog.setReqIp(getRemoteHost(request));
                transferLog.setCallResp(JSON.toJSONString(records));
                dbOpenApiTransferLogService.saveOrUpdate(transferLog);
            }
        }).start();

        return CommonResponse.success("数据查询成功！", records);
    }

    private String getRemoteHost(HttpServletRequest request) {
        String ip  = request.getHeader("x-forwarded-for");
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)){
            ip = request.getHeader("Proxy-client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)){
            ip = request.getHeader("WL-Client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)){
            ip = request.getRemoteHost();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1":ip;
    }


}
