package com.ejianc.foundation.mdm.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataCleanRuleDetailEntity;
import com.ejianc.foundation.mdm.bean.DataCleanRuleEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.mapper.DataCleanRuleMapper;
import com.ejianc.foundation.mdm.service.IDataCleanRuleDetailService;
import com.ejianc.foundation.mdm.service.IDataCleanRuleService;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.vo.DataCleanRuleDetailVO;
import com.ejianc.foundation.mdm.vo.DataCleanRuleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DataCleanRuleServiceImpl extends BaseServiceImpl<DataCleanRuleMapper, DataCleanRuleEntity> implements IDataCleanRuleService {

	@Autowired
	private IDataCleanRuleDetailService dataCleanRuleDetailService;
	@Autowired
	private IDataModelService dataModelService;
	@Autowired
	private IDataModelItemService dataModelItemService;
	@Autowired
	private DataCleanRuleMapper dataCleanRuleMapper;
	
	@Override
	public CommonResponse<DataCleanRuleVO> saveOrUpdate(DataCleanRuleVO dataCleanRuleVo) {
		QueryWrapper<DataCleanRuleEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("rule_code", dataCleanRuleVo.getRuleCode());
		
		DataCleanRuleEntity dataCleanRuleEntity = null;
		String operateMessage = "";
		if(dataCleanRuleVo.getId() != null) {
			queryWrapper.ne("id", dataCleanRuleVo.getId());
			List<DataCleanRuleEntity> dataCleanRuleEntities = baseMapper.selectList(queryWrapper);
			if(dataCleanRuleEntities != null && dataCleanRuleEntities.size() > 0) {
				return CommonResponse.error("数据清理模型编号已经存在，请重新填写");
			}
			dataCleanRuleEntity = super.getById(dataCleanRuleVo.getId());
			dataCleanRuleEntity.setRuleCode(dataCleanRuleVo.getRuleCode());
			dataCleanRuleEntity.setRuleName(dataCleanRuleVo.getRuleName());
			dataCleanRuleEntity.setDescription(dataCleanRuleVo.getDescription());
			
			operateMessage = "修改成功";
		}else{
			List<DataCleanRuleEntity> dataCleanRuleEntities = baseMapper.selectList(queryWrapper);
			if(dataCleanRuleEntities != null && dataCleanRuleEntities.size() > 0) {
				return CommonResponse.error("数据清理模型编号已经存在，请重新填写");
			}
			dataCleanRuleEntity = BeanMapper.map(dataCleanRuleVo, DataCleanRuleEntity.class);
			dataCleanRuleEntity.setId(IdWorker.getId());
			
			operateMessage = "保存成功";
		}
		this.saveOrUpdate(dataCleanRuleEntity, false);
		
		List<DataCleanRuleDetailVO> ruleDetailVos = dataCleanRuleVo.getDataCleanRuleDetailVos();
		List<DataCleanRuleDetailEntity> ruleDetailEntities = new ArrayList<>();
		List<Long> delDetailIds = new ArrayList<>();
		for(DataCleanRuleDetailVO detailVo:ruleDetailVos) {
			if(StringUtils.isNotBlank(detailVo.getRowState()) && "add".equals(detailVo.getRowState())) {
				DataCleanRuleDetailEntity detailEntity = BeanMapper.map(detailVo, DataCleanRuleDetailEntity.class);
				detailEntity.setRuleId(dataCleanRuleEntity.getId());
				ruleDetailEntities.add(detailEntity);
			}
			if(StringUtils.isNotBlank(detailVo.getRowState()) && "edit".equals(detailVo.getRowState())) {
				DataCleanRuleDetailEntity detailEntity = BeanMapper.map(detailVo, DataCleanRuleDetailEntity.class);
				ruleDetailEntities.add(detailEntity);
			}
			if(StringUtils.isNotBlank(detailVo.getRowState()) && "del".equals(detailVo.getRowState())) {
				delDetailIds.add(detailVo.getId());
			}
		}
		DataCleanRuleVO responseVo = BeanMapper.map(dataCleanRuleEntity, DataCleanRuleVO.class);
		if(ruleDetailEntities.size() > 0) {
			dataCleanRuleDetailService.saveOrUpdateBatch(ruleDetailEntities);
			responseVo.setDataCleanRuleDetailVos(BeanMapper.mapList(ruleDetailEntities, DataCleanRuleDetailVO.class));
		}
		if(delDetailIds.size() > 0) {
			dataCleanRuleDetailService.removeByIds(delDetailIds);
		}
		return CommonResponse.success(operateMessage);
	}

	@Override
	public DataCleanRuleVO queryDetail(Long id) {
		DataCleanRuleEntity dataCleanRuleEntity = super.getById(id);
		
		if(dataCleanRuleEntity != null) {
			DataCleanRuleVO dataCleanRuleVo = BeanMapper.map(dataCleanRuleEntity, DataCleanRuleVO.class);
			//获取数据模型
			DataModelEntity dataMode = dataModelService.selectById(dataCleanRuleVo.getDataModelId());
			if(dataMode!=null){
				dataCleanRuleVo.setDataModelName(dataMode.getModelName());
			}
			//查询清洗项
			QueryWrapper<DataCleanRuleDetailEntity> ruleDetailWrapper = new QueryWrapper<>();
			ruleDetailWrapper.eq("rule_id", dataCleanRuleVo.getId());
			List<DataCleanRuleDetailEntity> ruleDetailEntities = dataCleanRuleDetailService.list(ruleDetailWrapper);
			if(ruleDetailEntities != null && ruleDetailEntities.size() > 0) {
				List<DataCleanRuleDetailVO> ruleDetailVos = BeanMapper.mapList(ruleDetailEntities, DataCleanRuleDetailVO.class);
				for(DataCleanRuleDetailVO vo : ruleDetailVos){
					DataModelItemEntity dataModelItem = dataModelItemService.selectById(vo.getDataModelItemId());
					if(dataModelItem!=null){
						vo.setDataModelItemName(dataModelItem.getItemName());
					}
				}
				dataCleanRuleVo.setDataCleanRuleDetailVos(ruleDetailVos);
			}
			return dataCleanRuleVo;
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		QueryWrapper<DataCleanRuleDetailEntity> ruleDetailWrapper = new QueryWrapper<>();
		ruleDetailWrapper.eq("rule_id", id);
		dataCleanRuleDetailService.remove(ruleDetailWrapper);
		
		this.removeById(id);
	}

	@Override
	public IPage<DataCleanRuleVO> queryDataCleanPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		
		List<DataCleanRuleVO> records = dataCleanRuleMapper.queryDataCleanList(condition);
		Long count = dataCleanRuleMapper.queryDataCleanCount(condition);
		
		IPage<DataCleanRuleVO> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

}
