package com.ejianc.foundation.mdm.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RuleType implements Serializable {

	private static final long serialVersionUID = 4683022507383454207L;

	private String code;

	private String value;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	public static List<RuleType> obtainRuleTypes() {
		List<RuleType> ruleTypes = new ArrayList<>();
		RuleType uniqueRule = new RuleType();
		uniqueRule.setCode("unique_rule");
		uniqueRule.setValue("字段去重判断");
		ruleTypes.add(uniqueRule);
		
		RuleType requiredRule = new RuleType();
		requiredRule.setCode("required_rule");
		requiredRule.setValue("必填项判断");
		ruleTypes.add(requiredRule);
		
		RuleType emailRule = new RuleType();
		emailRule.setCode("email_rule");
		emailRule.setValue("邮箱格式判断");
		ruleTypes.add(emailRule);
		
		RuleType integerRule = new RuleType();
		integerRule.setCode("integer_rule");
		integerRule.setValue("整数格式判断");
		ruleTypes.add(integerRule);
		
		RuleType amountRule = new RuleType();
		amountRule.setCode("amount_rule");
		amountRule.setValue("金额格式判断");
		ruleTypes.add(amountRule);
		
		RuleType dateRule = new RuleType();
		dateRule.setCode("date_rule");
		dateRule.setValue("日期格式判断");
		ruleTypes.add(dateRule);
		
		RuleType referRule = new RuleType();
		referRule.setCode("refer_rule");
		referRule.setValue("参照类型判断");
		ruleTypes.add(referRule);
		
		return ruleTypes;
	}

}
