package com.ejianc.foundation.mdm.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 第三方集成系统
 * 
 * @author guoming
 *
 */
@TableName("ejc_mdm_thirdsystem")
public class ThirdSystemEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 系统类型： 1：生产系统 2：消费系统 3：生产&消费系统
	 */
	@TableField(value = "system_type")
	private Integer systemType;

	/**
	 * 系统编码
	 */
	@TableField(value = "system_code")
	private String systemCode;

	/**
	 * 系统名称
	 */
	@TableField(value = "system_name")
	private String systemName;

	/**
	 * 服务地址
	 */
	@TableField(value = "service_url")
	private String serviceUrl;

	/**
	 * 认证令牌
	 */
	@TableField(value = "ticket")
	private String ticket;

	/**
	 * 状态： 1启用 0停用
	 */
	@TableField(value = "enable_flag")
	private Integer enableFlag;

	/**
	 * 排序字段
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	public Integer getSystemType() {
		return systemType;
	}

	public void setSystemType(Integer systemType) {
		this.systemType = systemType;
	}

	public String getSystemCode() {
		return systemCode;
	}

	public void setSystemCode(String systemCode) {
		this.systemCode = systemCode;
	}

	public String getSystemName() {
		return systemName;
	}

	public void setSystemName(String systemName) {
		this.systemName = systemName;
	}

	public String getServiceUrl() {
		return serviceUrl;
	}

	public void setServiceUrl(String serviceUrl) {
		this.serviceUrl = serviceUrl;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public Integer getEnableFlag() {
		return enableFlag;
	}

	public void setEnableFlag(Integer enableFlag) {
		this.enableFlag = enableFlag;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

}
