package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.mdm.bean.EnumDetailEntity;
import com.ejianc.foundation.mdm.bean.EnumEntity;
import com.ejianc.foundation.mdm.service.IEnumDetailService;
import com.ejianc.foundation.mdm.service.IEnumService;
import com.ejianc.foundation.mdm.vo.EnumVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/enum/")
public class EnumController implements Serializable {

	private static final long serialVersionUID = 1L;

	@Autowired
	private IEnumService enumService;
	@Autowired
	private IEnumDetailService enumDetailService;

	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody EnumVO enumVo) {
		QueryWrapper<EnumEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("enum_code", enumVo.getEnumCode());
		EnumEntity enumEntity = enumService.getOne(queryWrapper);

		if (enumVo.getId() != null && enumVo.getId() > 0) {
			if (enumEntity != null && !enumEntity.getId().equals(enumVo.getId())) {
				return CommonResponse.error("修改失败：档案编码与【" + enumEntity.getEnumName() + "】重复！");
			}
			EnumEntity uniqueBean = enumService.getById(enumVo.getId());
			uniqueBean.setEnumCode(enumVo.getEnumCode());
			uniqueBean.setEnumName(enumVo.getEnumName());
			uniqueBean.setSequence(enumVo.getSequence());

			enumService.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功");
		} else {
			if (enumEntity != null) {
				return CommonResponse.error("修改失败：档案编码与【" + enumEntity.getEnumName() + "】重复！");
			}
			EnumEntity saveBean = BeanMapper.map(enumVo, EnumEntity.class);
			enumService.saveOrUpdate(saveBean, false);
			return CommonResponse.success("保存成功");
		}
	}

	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<EnumVO> queryDetail(@RequestParam Long id) {
		EnumEntity uniqueBean = enumService.getById(id);
		EnumVO enumVo = BeanMapper.map(uniqueBean, EnumVO.class);
		return CommonResponse.success(enumVo);
	}

	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if (ids != null && ids.size() > 0) {
			for (Long id : ids) {
				QueryWrapper<EnumDetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("enum_id", id);
				List<EnumDetailEntity> details = enumDetailService.list(queryWrapper);
				if (details != null && details.size() > 0) {
					return CommonResponse.error("要删除的枚举档案下有档案项，不允许删除");
				}
			}
			enumService.removeByIds(ids);
		}
		return CommonResponse.success("删除成功");
	}

	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<EnumEntity> pageData = enumService.queryPage(queryParam, false);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}

}
