package com.ejianc.foundation.bulidMaterialMdm.mapper;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bulidMaterialMdm.bean.*;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * 筑材信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface UserMapper extends BaseCrudMapper<MadUserEntity> {
    /**
     *获取要同步的组织数据
     */
    @Select("SELECT md.* FROM `employeemodel` md\n" +
            "LEFT JOIN ejc_buildmaterial_user ma\n" +
            "on ma.mdm_id = md._master_data_id\n" +
            " where DATE_SUB(CURDATE(),INTERVAL 1 DAY) <= Date(md._last_update_time)\n" +
            " and ( ma.id is null or ma.last_update_time < md._last_update_time)")
    List<MadUserEntity> getTodayUpdateData();

    /**
     *中间记录表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_record`(mdm_id,send_time,bill_type,is_success,error_reason) VALUE(#{mdmId},#{sendTime},#{billType},#{isSuccess},#{errorReason})")
    Integer insertSendRecord(MadRecordEntity entity);

    /**
     * 根据主数据id获取筑材网id
     */
    @Select("SELECT user_id FROM `ejc_buildmaterial_user` where mdm_id = #{mdmId} limit 1")
    Integer getMaterialIdByMdmId(Long mdmId);

    /**
     * 根据主数据id获取筑材网id
     */
    @Select("SELECT * FROM `ejc_buildmaterial_user` where mdm_id = #{mdmId} limit 1")
    MaterialUserEntity getUserInfoByMdmId(Long mdmId);

    /**
     *组织中间表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_user`(mdm_id,user_id,last_update_time,data_type,real_name,department_id,duty,password,phone,role_id,username) " +
            "VALUE(#{mdmId},#{userId},#{lastUpdateTime},#{dataType},#{realName},#{departmentId},#{duty},#{password},#{phone},#{roleId},#{username})")
    Integer insertUserInfo(MaterialUserEntity entity);


    /**
     *组织中间表修改数据
     */
    @Update("update `ejc_buildmaterial_user` set last_update_time = #{lastUpdateTime},real_name =#{realName},data_type=#{dataType},phone=#{phone}\n" +
            "where mdm_id = #{mdmId} and user_id = #{userId}")
    Integer updateUserInfo(MaterialUserEntity entity);

    /**
     *组织中间表删除数据
     */
    @Update("update `ejc_buildmaterial_user` set last_update_time = #{lastUpdateTime},data_type=#{dataType}\n" +
            "where mdm_id = #{mdmId} and user_id = #{userId}")
    Integer deleteUserInfo(MaterialUserEntity entity);


    /**
     *转移部门失败记录表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_user_transfer` (mdm_id,user_id,last_update_time,data_type,department_id,password,duty,phone,real_name,role_id,username,department_id_new,transfer_state,error_message) " +
            "VALUE(#{mdmId},#{userId},#{lastUpdateTime},#{dataType},#{departmentId},#{password},#{duty},#{phone},#{realName},#{roleId},#{username},#{departmentIdNew},#{transferState},#{errorMessage})")
    Integer insertTransferRecord(MaterialUserTransferEntity entity);


    /**
     *用户中间表修改部门数据
     */
    @Update("update `ejc_buildmaterial_user` set last_update_time = #{lastUpdateTime},department_id =#{departmentId}\n" +
            "where user_id = #{userId}")
    Integer updateUserDeptId(MaterialUserEntity entity);


    //参照
    List<UserVO> queryUserData(Page<UserVO> page,Integer departmentId);


    /**
     *查询库中所有组织个数（删除除外）
     */
    List<MadUserEntity> selectWithPage(Integer start);
}
