package com.ejianc.foundation.bulidMaterialMdm.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadOrgEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadRecordEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialOrgEntity;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IOrgService;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 组织部门信息
 *
 * @author generator
 *
 */
@Service("orgService")
public class OrgService implements IOrgService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISystemRequestService requestService;

    @Autowired
    private OrgMapper mapper;


    @Override
    public JSONObject insertOrgInfo(String departmentName, Integer parentId) {
        if (departmentName == null){
            throw new BusinessException("部门名称不允许为空！" );
        }
        JSONObject param = new JSONObject();
        param.put("departmentName",departmentName);
        if (parentId != null){
            param.put("parentId",parentId);
        }

        String responseBody = requestService.sendPostRequest("department/add", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);


        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getInteger("object")+"";
        }else {
             message = jsonObject.getString("message");
        }

        return jsonObject;
    }

    @Override
    public JSONObject updateOrgInfo(Integer departmentId, String departmentName, Integer parentId) {
        if (departmentName == null || departmentId == null){
            throw new BusinessException("部门名称和部门id不允许为空！" );
        }
        JSONObject param = new JSONObject();
        param.put("departmentId",departmentId);
        param.put("departmentName",departmentName);

        if (parentId != null){
            param.put("parentId",parentId);
        }

        String responseBody = requestService.sendPostRequest("department/update", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);

        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getString("object")+"";
        }else {
            message = jsonObject.getString("message");
        }
        return jsonObject;
    }

    @Override
    public OrgVO selectOrgInfo(Integer departmentId) {
        String url = "department/getList";
//        if (departmentId != null){
//            url = url+"?departmentId="+departmentId;
//        }
        JSONObject param = new JSONObject();
        if (departmentId != null){
            param.put("parentId",departmentId);
        }
        String responseBody = requestService.sendPostRequest(url,param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        OrgVO orgVO = null;
        if (code == 0){
             orgVO = JSONObject.parseObject(jsonObject.getString("object"), OrgVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return orgVO;
    }

    @Override
    public JSONObject deleteOrgInfo(Integer departmentId) {
        if (departmentId == null){
            throw new BusinessException("部门id不允许为空！" );
        }
        JSONObject param = new JSONObject();
        if (departmentId != null){
            param.put("departmentId",departmentId);
        }
        String responseBody = requestService.sendPostRequest("department/delete/",param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getString("object")+"";
        }else {
            message = jsonObject.getString("message");
        }
        return jsonObject;
    }

    /**
     * 第一次同步，数据初始化
     * @return
     */
    @Override
    public String orgInfoSyncFirst() {
        logger.info("筑材网初始化同步组织信息开始---------------->");
        /**
         * 1. 获取今天修改的组织信息
         * 2. 判断是新增还是删除还是修改
         * 3.   分别执行对应操作，插入执行记录
         *      新增：
         *      删除：
         *      修改：
         * 4.
         * 5.
         */
        int page = 0;
        boolean flag =true;
        while (flag) {
            int i = page * 100;
            List<MadOrgEntity> todayUpdateData = mapper.selectWithPage(i);

            if (todayUpdateData != null &&todayUpdateData.size() > 0) {
                for (MadOrgEntity todayUpdateDatum : todayUpdateData) {
                    if (!"虚拟组织".equals(todayUpdateDatum.getOrgtype())) {

                            //从记录表中获取筑材网对应父id
                            Integer materialIdByMdmId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                            /**
                             * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                             */
                            if (todayUpdateDatum.getParentid().equals(1502571152642412546L) ||//集团公司机关
                                    todayUpdateDatum.getParentid().equals(1502571152701132801L) ||//集团子公司
                                    todayUpdateDatum.getParentid().equals(1502571152793407490L) ||//集团分公司
                                    todayUpdateDatum.getParentid().equals(1502571152847933442L) ||//项目经理部
                                    todayUpdateDatum.getParentid().equals(1502571155922358273L) ||//其它施工项目部
                                    todayUpdateDatum.getParentid().equals(1502571152583692289L)//郑州一建集团
                            ) {//上级组织是虚拟层级则父id设置为空
                                materialIdByMdmId = null;
                            } else {
                                if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                                    logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getName());
                                    continue;
                                }
                            }
                            //进行插入操作
                            logger.info("筑材网组织信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                            JSONObject jsonObject = insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网新增成功
                                Integer materialId = jsonObject.getInteger("object");//筑材网返回id
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增组织", 1, "");
                                mapper.insertSendRecord(entity);
                                //组织中间表新增
                                MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                                mapper.insertOrgInfo(materialOrgEntity);
                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增组织", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                    }

                    try {
                        Thread.sleep(500); // 暂停0.5秒
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }else {
                flag = false;
            }
            page++;
        }
        return "同步完成！";
    }






    /**
     * 组织同步接口
     * @return
     */
    @Override
    public String orgInfoSync() {
        logger.info("筑材网同步组织信息开始---------------->");
        /**
         * 1. 获取今天修改的组织信息
         * 2. 判断是新增还是删除还是修改
         * 3.   分别执行对应操作，插入执行记录
         *      新增：
         *      删除：
         *      修改：
         * 4.
         * 5.
         */
        //1
        List<MadOrgEntity> todayUpdateData = mapper.getTodayUpdateData();

        if (todayUpdateData != null){
            for (MadOrgEntity todayUpdateDatum : todayUpdateData) {
                if (!"虚拟组织".equals(todayUpdateDatum.getOrgtype())) {
                    //2
                    if (todayUpdateDatum.getDataType() == 1) {//新增
                        //从记录表中获取筑材网对应父id
                        Integer materialIdByMdmId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                        /**
                         * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                         */
                        if (todayUpdateDatum.getParentid().equals(1502571152642412546L)||//集团公司机关
                                todayUpdateDatum.getParentid().equals(1502571152701132801L)||//集团子公司
                                todayUpdateDatum.getParentid().equals(1502571152793407490L)||//集团分公司
                                todayUpdateDatum.getParentid().equals(1502571152847933442L)||//项目经理部
                                todayUpdateDatum.getParentid().equals(1502571155922358273L)||//其它施工项目部
                        todayUpdateDatum.getParentid().equals(1502571152583692289L)//郑州一建集团
                        ) {//上级组织是虚拟层级则父id设置为空
                            materialIdByMdmId = null;
                        } else {
                            if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                                logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getName());
                                continue;
                            }
                        }
                        //进行插入操作
                        logger.info("筑材网组织信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                        JSONObject jsonObject = insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                        //判断操作结果
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {//筑材网新增成功
                            Integer materialId = jsonObject.getInteger("object");//筑材网返回id
                            //记录表新增
                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增组织", 1, "");
                            mapper.insertSendRecord(entity);
                            //组织中间表新增
                            MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                            mapper.insertOrgInfo(materialOrgEntity);
                        } else {
                            String message = jsonObject.getString("message");
                            //记录表新增
                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增组织", 2, message);
                            mapper.insertSendRecord(entity);
                        }

                    } else if (todayUpdateDatum.getDataType() == 2) {//修改
                        //从记录表中获取筑材网对应id
                        Integer materialId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                        //从记录表中获取筑材网对应父id
                        Integer materialparentId = null;
                        if (todayUpdateDatum.getParentid() != null && !(todayUpdateDatum.getParentid().equals(1502571152642412546L)||//集团公司机关
                                todayUpdateDatum.getParentid().equals(1502571152701132801L)||//集团子公司
                                todayUpdateDatum.getParentid().equals(1502571152793407490L)||//集团分公司
                                todayUpdateDatum.getParentid().equals(1502571152847933442L)||//项目经理部
                                todayUpdateDatum.getParentid().equals(1502571155922358273L)||//其它施工项目部
                                todayUpdateDatum.getParentid().equals(1502571152583692289L)//郑州一建集团
                         )) {
                            materialparentId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                        }
                        if (materialId != null ) {
                            logger.info("筑材网组织信息更新，id：{}", todayUpdateDatum.getMasterDataId());
                            //执行更新操作
                            JSONObject jsonObject = updateOrgInfo(materialId, todayUpdateDatum.getName(), materialparentId);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网修改成功
                                String object = jsonObject.getString("object");//筑材网返回信息
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改组织", 1, object);
                                mapper.insertSendRecord(entity);

                                //组织中间表修改
                                MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(),
                                        materialId, 2, todayUpdateDatum.getName(), materialparentId);
                                mapper.updateOrgInfo(materialOrgEntity);

                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改组织", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        }else {
                            //从记录表中获取筑材网对应父id
                            Integer materialIdByMdmId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                            /**
                             * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                             */
                            if (todayUpdateDatum.getParentid().equals(1502571152642412546L)||//集团公司机关
                                    todayUpdateDatum.getParentid().equals(1502571152701132801L)||//集团子公司
                                    todayUpdateDatum.getParentid().equals(1502571152793407490L)||//集团分公司
                                    todayUpdateDatum.getParentid().equals(1502571152847933442L)||//项目经理部
                                    todayUpdateDatum.getParentid().equals(1502571155922358273L)||//其它施工项目部
                                    todayUpdateDatum.getParentid().equals(1502571152583692289L)//郑州一建集团
                            ) {//上级组织是虚拟层级则父id设置为空
                                materialIdByMdmId = null;
                            } else {
                                if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                                    logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getName());
                                    continue;
                                }
                            }
                            //进行插入操作
                            logger.info("筑材网组织信息修改新增，id：{}", todayUpdateDatum.getMasterDataId());
                            JSONObject jsonObject = insertOrgInfo(todayUpdateDatum.getName(), materialIdByMdmId);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网新增成功
                                Integer materialId1 = jsonObject.getInteger("object");//筑材网返回id
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增组织", 1, "");
                                mapper.insertSendRecord(entity);
                                //组织中间表新增
                                MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(), materialId1, 1, todayUpdateDatum.getName(), materialIdByMdmId);
                                mapper.insertOrgInfo(materialOrgEntity);
                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增组织", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        }
                    } else if (todayUpdateDatum.getDataType() == 3) {//删除
                        //从记录表中获取筑材网对应id
                        Integer materialId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                            if (materialId != null) {
                                logger.info("筑材网组织信息删除，id：{}", todayUpdateDatum.getMasterDataId());

                                //执行删除操作
                                JSONObject jsonObject = deleteOrgInfo(materialId);
                                //判断操作结果
                                Integer code = jsonObject.getInteger("code");
                                if (code == 0) {//筑材网删除成功
                                    String object = jsonObject.getString("object");//筑材网返回信息
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 1, object);
                                    mapper.insertSendRecord(entity);

                                    //从记录表中获取筑材网对应父id
                                    Integer materialparentId = null;
                                    if (todayUpdateDatum.getParentid() != null) {
                                        materialparentId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
                                    }
                                    //组织中间表修改
                                    MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(),
                                            materialId, 3, todayUpdateDatum.getName(), materialparentId);
                                    mapper.updateOrgInfo(materialOrgEntity);

                                } else {
                                    String message = jsonObject.getString("message");
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 2, message);
                                    mapper.insertSendRecord(entity);
                                }
                            }else {
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 2, "中间表查询数据失败！");
                                mapper.insertSendRecord(entity);
                            }
                    }
                }

                try {
                    Thread.sleep(500); // 暂停0.5秒
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return "同步完成！";
    }

}
