package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataModelCategoryEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.service.IDataModelCategoryService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.utils.DataModelCategoryAsTree;
import com.ejianc.foundation.mdm.vo.DataModelCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("/datamodel/category/")
public class DataModelCategoryController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IDataModelCategoryService dataModelCategoryService;
	@Autowired
	private IDataModelService dataModelService;
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody DataModelCategoryVO dataModelCategoryVo) {
		QueryWrapper<DataModelCategoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_code", dataModelCategoryVo.getCategoryCode());
		DataModelCategoryEntity dataModelCategoryEntity = dataModelCategoryService.getOne(queryWrapper);
		if(dataModelCategoryVo.getId() != null && dataModelCategoryVo.getId() > 0) {
			if(dataModelCategoryEntity != null && !dataModelCategoryEntity.getId().equals(dataModelCategoryVo.getId())) {
				return CommonResponse.error("修改失败：分类编码与【" + dataModelCategoryEntity.getCategoryName() + "】重复！");
			}
			DataModelCategoryEntity uniqueBean = dataModelCategoryService.getById(dataModelCategoryVo.getId());
			uniqueBean.setCategoryCode(dataModelCategoryVo.getCategoryCode());
			uniqueBean.setCategoryName(dataModelCategoryVo.getCategoryName());
			uniqueBean.setSequence(dataModelCategoryVo.getSequence());
			
			dataModelCategoryService.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功");
		}else{
			if(dataModelCategoryEntity != null) {
				return CommonResponse.error("修改失败：分类编码与【" + dataModelCategoryEntity.getCategoryName() + "】重复！");
			}
			DataModelCategoryEntity saveBean = BeanMapper.map(dataModelCategoryVo, DataModelCategoryEntity.class);
			saveBean.setId(IdWorker.getId());
			if(saveBean.getParentId() != null && saveBean.getParentId() > 0) {
				DataModelCategoryEntity parentBean = dataModelCategoryService.getById(saveBean.getParentId());
				saveBean.setInnerCode(parentBean.getInnerCode()+"|"+saveBean.getId());
			}else{
				saveBean.setInnerCode(saveBean.getId()+"");
			}
			dataModelCategoryService.saveOrUpdate(saveBean, false);
			return CommonResponse.success("保存成功");
		}
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DataModelCategoryVO> queryDetail(@RequestParam Long id) {
		DataModelCategoryEntity uniqueBean = dataModelCategoryService.getById(id);
		DataModelCategoryVO dataModelCategoryVo = BeanMapper.map(uniqueBean, DataModelCategoryVO.class);
		return CommonResponse.success(dataModelCategoryVo);
	}

	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		QueryWrapper<DataModelEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", id);
		List<DataModelEntity> dataModelEntities = dataModelService.list(queryWrapper);
		if(dataModelEntities != null && dataModelEntities.size() > 0) {
			return CommonResponse.error("要删除的模型分类下已有数据模型了，不允许删除");
		}
		dataModelCategoryService.removeById(id);
		return CommonResponse.success("删除成功");
	}
	
	@RequestMapping(value = "/queryTree", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryTree(@RequestBody QueryParam queryParam) {
		String categoryName = null;
		if(queryParam != null && StringUtils.isNotBlank(queryParam.getSearchText())) {
			categoryName = queryParam.getSearchText();
		}
		List<DataModelCategoryEntity> dataModelCategoryEntities = dataModelCategoryService.queryDataModelCategoryList(categoryName);
		if(dataModelCategoryEntities != null) {
			List<DataModelCategoryEntity> treeList = DataModelCategoryAsTree.createTreeData(dataModelCategoryEntities);
			JSONObject dataResponse = new JSONObject();
			dataResponse.put("data", treeList);
			return CommonResponse.success(dataResponse);
		}
		return CommonResponse.success();
	}
	
}
