package com.ejianc.foundation.mdm.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.EnumDetailEntity;
import com.ejianc.foundation.mdm.service.IEnumDetailService;
import com.ejianc.foundation.mdm.vo.EnumDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

@RestController
@RequestMapping("/enumdetail/")
public class EnumDetailController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IEnumDetailService enumDetailService;
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody EnumDetailVO enumDetailVo) {
		QueryWrapper<EnumDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("detail_code", enumDetailVo.getDetailCode());
		EnumDetailEntity enumDetailEntity = enumDetailService.getOne(queryWrapper);
		
		if(enumDetailVo.getId() != null && enumDetailVo.getId() > 0) {
			if(enumDetailEntity != null && !enumDetailEntity.getId().equals(enumDetailVo.getId())) {
				return CommonResponse.error("修改失败：档案项编码与【" + enumDetailEntity.getCreateUserCode() + "】重复！");
			}
			EnumDetailEntity uniqueBean = enumDetailService.getById(enumDetailVo.getId());
			uniqueBean.setDetailCode(enumDetailVo.getDetailCode());
			uniqueBean.setDetailName(enumDetailVo.getDetailName());
			uniqueBean.setSequence(enumDetailVo.getSequence());
			
			enumDetailService.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功");
		}else{
			if(enumDetailEntity != null) {
				return CommonResponse.error("修改失败：档案项编码与【" + enumDetailEntity.getCreateUserCode() + "】重复！");
			}
			EnumDetailEntity saveBean = BeanMapper.map(enumDetailVo, EnumDetailEntity.class);
			enumDetailService.saveOrUpdate(saveBean, false);
			return CommonResponse.success("保存成功");
		}
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<EnumDetailVO> queryDetail(@RequestParam Long id) {
		EnumDetailEntity enumDetailEntity = enumDetailService.selectById(id);
		EnumDetailVO enumDetailVo = BeanMapper.map(enumDetailEntity, EnumDetailVO.class);
		return CommonResponse.success(enumDetailVo);
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		enumDetailService.removeByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		List<EnumDetailEntity> dataList = enumDetailService.queryList(queryParam);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}

}
