package com.ejianc.foundation.mdm.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.mapper.DataModelItemMapper;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DataModelItemServiceImpl extends BaseServiceImpl<DataModelItemMapper, DataModelItemEntity> implements IDataModelItemService {

	@Autowired
	private DataModelItemMapper dataModelItemMapper;
	
	@Override
	public List<JSONObject> queryMdmDataList(Map<String, Object> modelItemMap) {
		List<JSONObject> resultList = dataModelItemMapper.queryMdmDataList(modelItemMap);
		return resultList;
	}
	
	@Override
	public Long queryMdmDataCount(Map<String, Object> modelItemMap) {
		Long total = dataModelItemMapper.queryMdmDataCount(modelItemMap);
		return total;
	}

	@Override
	public List<JSONObject> queryMdmChildDataList(Map<String, Object> childParamMap) {
		List<JSONObject> childList = dataModelItemMapper.queryMdmChildDataList(childParamMap);
		return childList;
	}

	@Override
	public void deleteChildMdmData(Map<String, Object> childParamMap) {
		dataModelItemMapper.deleteChildMdmData(childParamMap);
	}

	@Override
	public void deleteMasterMdmData(Map<String, Object> modelItemMap) {
		dataModelItemMapper.deleteMasterMdmData(modelItemMap);
	}

	@Override
	public JSONObject queryUniqueByMasterDataId(String tableName, String masterDataId) {
		JSONObject jsonObject = dataModelItemMapper.queryUniqueByMasterDataId(tableName, masterDataId);
		return jsonObject;
	}

	@Override
	public void executeDeleteSql(String executeSql) {
		dataModelItemMapper.executeDeleteSql(executeSql);
	}

	@Override
	public void executeUpdateSql(String executeSql) {
		dataModelItemMapper.executeUpdateSql(executeSql);
	}

	@Override
	public void executeInsertSql(String executeSql) {
		dataModelItemMapper.executeInsertSql(executeSql);
	}

	@Override
	public JSONObject queryDataIsExist(Map<String, String> paramMap) {
		JSONObject jsonObject = dataModelItemMapper.queryDataIsExist(paramMap);
		return jsonObject;
	}

	@Override
	public JSONObject queryReferData(Map<String, String> referParamMap) {
		JSONObject jsonObject = dataModelItemMapper.queryReferData(referParamMap);
		return jsonObject;
	}

	@Override
	public JSONObject queryDataBySourceId(String tableName, String sourceId) {
		JSONObject uniqueObject = dataModelItemMapper.queryDataBySourceId(tableName, sourceId);
		return uniqueObject;
	}

	@Override
	public JSONObject getObjectBySqlCondition(String tableName, String sqlCondition) {
		JSONObject uniqueObject = dataModelItemMapper.getObjectBySqlCondition(tableName, sqlCondition);
		return uniqueObject;
	}

	@Override
	public void deleteMdmDataBySourceIds(String tableName, String delSourceIdStr) {
		dataModelItemMapper.deleteMdmDataBySourceIds(tableName, delSourceIdStr);
	}

	@Override
	public List<JSONObject> queryDataBySql(String sql) {
		return dataModelItemMapper.queryDataBySql(sql);
	}

	//查询未推送的状态的数据
	@Override
	public Long queryMdmDataStateCount(Map<String, Object> modelItemMap) {
		Long total = dataModelItemMapper.queryMdmDataStateCount(modelItemMap);
		return total;
	}

	@Override
	public List<JSONObject> queryMdmDataStateList(Map<String, Object> modelItemMap) {
		List<JSONObject> resultList = dataModelItemMapper.queryMdmDataStateList(modelItemMap);
		return resultList;
	}

	@Override
	public List<String> getEmployeeIdcardBySourceIds(String tableName, String delSourceIdStr) {
		return dataModelItemMapper.getEmployeeIdcardBySourceIds(tableName, delSourceIdStr);
	}
}
