package com.ejianc.foundation.mdm.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataModelCategoryEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.mapper.DataModelItemMapper;
import com.ejianc.foundation.mdm.mapper.DataModelMapper;
import com.ejianc.foundation.mdm.service.IDataModelCategoryService;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.vo.DataModelItemVO;
import com.ejianc.foundation.mdm.vo.DataModelVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class DataModelServiceImpl extends BaseServiceImpl<DataModelMapper, DataModelEntity> implements IDataModelService {

	@Autowired
	private IDataModelItemService dataModelItemService;
	@Autowired
	private IDataModelCategoryService dataModelCategoryService;
	@Autowired
	private DataModelMapper dataModelMapper;
	@Autowired
	private DataModelItemMapper dataModelItemMapper;
	
	@Override
	public CommonResponse<DataModelVO> saveOrUpdate(DataModelVO dataModelVo) {
		QueryWrapper<DataModelEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("model_code", dataModelVo.getModelCode());
		
		DataModelEntity dataModelEntity = null;
		String operateMessage="";
		if(dataModelVo.getId() != null) {
			queryWrapper.ne("id", dataModelVo.getId());
			List<DataModelEntity> dataModelEntities = baseMapper.selectList(queryWrapper);
			if(dataModelEntities != null && dataModelEntities.size() > 0) {
				return CommonResponse.error("数据模型编号已经存在，请重新填写");
			}
			dataModelEntity = super.getById(dataModelVo.getId());
			dataModelEntity.setModelCode(dataModelVo.getModelCode());
			dataModelEntity.setModelName(dataModelVo.getModelName());
			dataModelEntity.setSyncAddress(dataModelVo.getSyncAddress());
			dataModelEntity.setSequence(dataModelVo.getSequence());
			
			operateMessage = "修改成功";
		}else{
			List<DataModelEntity> dataModelEntities = baseMapper.selectList(queryWrapper);
			if(dataModelEntities != null && dataModelEntities.size() > 0) {
				return CommonResponse.error("数据模型编号已经存在，请重新填写");
			}
			dataModelEntity = BeanMapper.map(dataModelVo, DataModelEntity.class);
			dataModelEntity.setId(IdWorker.getId());
			
			operateMessage = "保存成功";
		}
		this.saveOrUpdate(dataModelEntity, false);
		
		List<DataModelItemVO> itemVos = dataModelVo.getDataModelItemVos();
		List<DataModelItemEntity> itemEntities = new ArrayList<DataModelItemEntity>();
		List<Long> delItemIds = new ArrayList<>();
		for(DataModelItemVO itemVo:itemVos) {
			if(StringUtils.isNotBlank(itemVo.getRowState()) && "add".equals(itemVo.getRowState())) {
				DataModelItemEntity itemEntity = BeanMapper.map(itemVo, DataModelItemEntity.class);
				itemEntity.setDataModelId(dataModelEntity.getId());
				itemEntities.add(itemEntity);
			}
			if(StringUtils.isNotBlank(itemVo.getRowState()) && "edit".equals(itemVo.getRowState())) {
				DataModelItemEntity itemEntity = BeanMapper.map(itemVo, DataModelItemEntity.class);
				itemEntities.add(itemEntity);
			}
			if(StringUtils.isNotBlank(itemVo.getRowState()) && "del".equals(itemVo.getRowState())) {
				delItemIds.add(itemVo.getId());
			}
		}
		DataModelVO responseVo = BeanMapper.map(dataModelEntity, DataModelVO.class);
		if(itemEntities.size() > 0) {
			dataModelItemService.saveOrUpdateBatch(itemEntities);
			responseVo.setDataModelItemVos(BeanMapper.mapList(itemEntities, DataModelItemVO.class));
		}
		if(delItemIds.size() > 0) {
			dataModelItemService.removeByIds(delItemIds);
		}
		
		return CommonResponse.success(operateMessage, responseVo);
	}

	@Override
	public DataModelVO queryDetail(Long id) {
		DataModelEntity dataModelEntity = super.getById(id);
		
		if(dataModelEntity != null) {
			DataModelVO dataModelVo = BeanMapper.map(dataModelEntity, DataModelVO.class);
			
			//查询模型项
			QueryWrapper<DataModelItemEntity> itemQueryWrapper = new QueryWrapper<>();
			itemQueryWrapper.eq("data_model_id", dataModelVo.getId());
			itemQueryWrapper.orderByAsc("sequence");
			List<DataModelItemEntity> itemEntities = dataModelItemService.list(itemQueryWrapper);
			if(itemEntities != null && itemEntities.size() > 0) {
				List<DataModelItemVO> itemVos = BeanMapper.mapList(itemEntities, DataModelItemVO.class);
				dataModelVo.setDataModelItemVos(itemVos);
			}
			
			if(dataModelVo.getParentId() != null && dataModelVo.getParentId() > 0) {
				DataModelItemVO parentModelItem = new DataModelItemVO();
				parentModelItem.setDataModelId(dataModelVo.getId());
				parentModelItem.setItemCode("_parent_id");
				parentModelItem.setItemName("父ID");
				parentModelItem.setDataType("long");
				dataModelVo.getDataModelItemVos().add(parentModelItem);
			}
			return dataModelVo;
		}
		return null;
	}

	@Override
	public CommonResponse<String> delete(Long id) {
		//查询数据模型所有子模型
		QueryWrapper<DataModelEntity> itemWrapper = new QueryWrapper<>();
		itemWrapper.eq("parent_id", id);
		List<DataModelEntity> childModels = this.list(itemWrapper);
		if(childModels != null && childModels.size() > 0) {
			for(DataModelEntity childModel:childModels) {
				deleteDataModel(childModel.getId());
			}
		}
		deleteDataModel(id);
		return CommonResponse.success();
	}
	
	private void deleteDataModel(Long modelId) {
		QueryWrapper<DataModelItemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("data_model_id", modelId);
		dataModelItemService.remove(queryWrapper);
		
		this.removeById(modelId);
	}

	@Override
	public IPage<DataModelEntity> queryDataModelPage(QueryParam queryParam) {
		IPage<DataModelEntity> page = new Page<>();
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				DataModelCategoryEntity categoryEntity = dataModelCategoryService.getById(parameter.getValue().toString());
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		List<DataModelEntity> records = dataModelMapper.queryList(condition);
		if(records != null && records.size() > 0) {
			Long count = dataModelMapper.queryCount(condition);
			
			page.setCurrent(queryParam.getPageIndex());
			page.setSize(queryParam.getPageSize());
			page.setTotal(count);
			page.setRecords(records);
		}
		return page;
	}
	
	private String obtainColumnType(DataModelItemEntity item) {
		String dataType = item.getDataType();
		String columnSql = "";
		switch(dataType) {
			case "string":
				columnSql = " varchar("+item.getDataLength()+") default null comment '"+item.getItemName()+"',";
				break;
			case "integer":
				columnSql = " int("+item.getDataLength()+") default null comment '"+item.getItemName()+"',";
				break;
			case "long":
				columnSql = " bigint(20) default null comment '"+item.getItemName()+"',";
				break;
			case "datetime":
				columnSql = " datetime default null comment '"+item.getItemName()+"',";
				break;
			case "date":
				columnSql = " datetime default null comment '"+item.getItemName()+"',";
				break;
			case "refer":
				columnSql = " bigint(20) default null comment '"+item.getItemName()+"',";
				break;
			case "decimal":
				columnSql = " decimal(28,8) default null comment '"+item.getItemName()+"',";
				break;
		}
		return columnSql;
	}

	@Override
	public void publishDataModel(Long dataModelId) {
		//TODO 
		dataModelMapper.updateDataModelState(dataModelId);
		
		//创建主表
		DataModelEntity dataModelEntity = super.getById(dataModelId);
		
		QueryWrapper<DataModelItemEntity> itemQueryWrapper = new QueryWrapper<>();
		itemQueryWrapper.eq("data_model_id", dataModelId);
		itemQueryWrapper.orderByAsc("sequence");
		List<DataModelItemEntity> itemEntities = dataModelItemService.list(itemQueryWrapper);
		
		String createSql = "create table `"+dataModelEntity.getModelCode()+"` (";
		createSql += " _master_data_id bigint(20) not null comment '主键ID',";
		createSql += " _last_update_time datetime default null comment '最后一次修改时间',";
		createSql += " _data_type tinyint(4) default null comment '数据状态（1：新增，2：修改，3：删除）',";
		createSql += " _source_id varchar(100) default null comment '对应业务主键ID',";
//		createSql += " _data_state tinyint(4) default null comment '数据推送状态（1：已推送，0：未推送）',";
		for(DataModelItemEntity item:itemEntities) {
			createSql += " `"+item.getItemCode()+"`"+obtainColumnType(item);
		}
		createSql += " PRIMARY KEY (`_master_data_id`) USING BTREE )";
		createSql += " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='"+dataModelEntity.getModelName()+"'";
		dataModelItemMapper.executeCreateSql(createSql);
		
		QueryWrapper<DataModelEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", dataModelId);
		List<DataModelEntity> childList = dataModelMapper.selectList(queryWrapper);
		if(childList != null && childList.size() > 0) {
			for(DataModelEntity childModel:childList) {
				QueryWrapper<DataModelItemEntity> childItemQueryWrapper = new QueryWrapper<>();
				childItemQueryWrapper.eq("data_model_id", childModel.getId());
				childItemQueryWrapper.orderByAsc("sequence");
				List<DataModelItemEntity> childItemEntities = dataModelItemService.list(childItemQueryWrapper);
				
				createSql = "create table `"+childModel.getModelCode()+"` (";
				createSql += " _master_data_id bigint(20) not null comment '主键ID',";
				createSql += " _last_update_time datetime default null comment '最后一次修改时间',";
				createSql += " _data_type tinyint(4) default null comment '数据状态（1：新增，2：修改，3：删除）',";
				createSql += " _source_id varchar(100) default null comment '对应业务主键ID', ";
//				createSql += " _data_state tinyint(4) default null comment '数据推送状态（1：已推送，0：未推送）', ";
				createSql += " _parent_id bigint(20) default null comment '父ID',";
				for(DataModelItemEntity item:childItemEntities) {
					createSql += " `"+item.getItemCode()+"`"+obtainColumnType(item);
				}
				createSql += " PRIMARY KEY (`_master_data_id`) USING BTREE )";
				createSql += " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='"+childModel.getModelName()+"'";
				
				dataModelItemMapper.executeCreateSql(createSql);
				dataModelMapper.updateDataModelState(childModel.getId());
			}
		}
		
	}

	@Override
	public List<DataModelEntity> queryChildren(Long dataModelId) {
		QueryWrapper<DataModelEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", dataModelId);
		List<DataModelEntity> dataList = dataModelMapper.selectList(queryWrapper);
		if(dataList != null && dataList.size() > 0) {
			for(DataModelEntity dataModel:dataList) {
				DataModelCategoryEntity categoryEntity = dataModelCategoryService.selectById(dataModel.getCategoryId());
				dataModel.setCategoryName(categoryEntity.getCategoryName());
			}
		}
		return dataList;
	}

}
