package com.ejianc.foundation.mdm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.mdm.bean.DataModelCategoryEntity;

public class DataModelCategoryAsTree {
	
	public static List<DataModelCategoryEntity> createTreeData(List<DataModelCategoryEntity> list) {
		List<DataModelCategoryEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, DataModelCategoryEntity> listMap = new HashMap<>();
		for(DataModelCategoryEntity item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	DataModelCategoryEntity item = list.get(i);
        	String parentId = (item.getParentId() != null && item.getParentId() > 0) ? item.getParentId().toString():"";
        	DataModelCategoryEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<DataModelCategoryEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<DataModelCategoryEntity> children = new ArrayList<DataModelCategoryEntity>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
